"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Status = exports.DetailType = exports.PipelineEvent = exports.ApplicationEvent = exports.ProjectEvent = exports.RepositoryEvent = exports.ApplicationNotificationRule = exports.ProjectNotificationRule = exports.PipelineNotificationRule = exports.RepositoryNotificationRule = exports.NotificationRule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codestarnotifications_1 = require("aws-cdk-lib/aws-codestarnotifications");
const constructs_1 = require("constructs");
class NotificationRule extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.targets = new Array();
        for (const target of props.targets || []) {
            this.addTarget(target);
        }
        const notificationRule = new aws_codestarnotifications_1.CfnNotificationRule(this, 'NotificationRule', {
            name: props.name,
            status: props.status || Status.ENABLED,
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: props.events,
            resource: props.resource,
        });
        this.notificationRuleArn = notificationRule.ref;
        this.node.addValidation({
            validate: () => {
                if (this.targets.length === 0) {
                    return ['Notification rule must have a target'];
                }
                return [];
            },
        });
    }
    addTarget(target) {
        this.targets.push(target.bind(this, this));
    }
}
exports.NotificationRule = NotificationRule;
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.NotificationRule", version: "2.1.0" };
class RepositoryNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.repository.repositoryArn,
        });
    }
}
exports.RepositoryNotificationRule = RepositoryNotificationRule;
_b = JSII_RTTI_SYMBOL_1;
RepositoryNotificationRule[_b] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.RepositoryNotificationRule", version: "2.1.0" };
class PipelineNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.pipeline.pipelineArn,
        });
    }
}
exports.PipelineNotificationRule = PipelineNotificationRule;
_c = JSII_RTTI_SYMBOL_1;
PipelineNotificationRule[_c] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.PipelineNotificationRule", version: "2.1.0" };
class ProjectNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.project.projectArn,
        });
    }
}
exports.ProjectNotificationRule = ProjectNotificationRule;
_d = JSII_RTTI_SYMBOL_1;
ProjectNotificationRule[_d] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.ProjectNotificationRule", version: "2.1.0" };
class ApplicationNotificationRule extends NotificationRule {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            resource: props.application.applicationArn,
        });
    }
}
exports.ApplicationNotificationRule = ApplicationNotificationRule;
_e = JSII_RTTI_SYMBOL_1;
ApplicationNotificationRule[_e] = { fqn: "@cloudcomponents/cdk-developer-tools-notifications.ApplicationNotificationRule", version: "2.1.0" };
var RepositoryEvent;
(function (RepositoryEvent) {
    RepositoryEvent["COMMENTS_ON_COMMITS"] = "codecommit-repository-comments-on-commits";
    RepositoryEvent["COMMENTS_ON_PULL_REQUEST"] = "codecommit-repository-comments-on-pull-requests";
    RepositoryEvent["APPROVAL_STATUS_CHANGED"] = "codecommit-repository-approvals-status-changed";
    RepositoryEvent["APPROVAL_RULE_OVERRIDE"] = "codecommit-repository-approvals-rule-override";
    RepositoryEvent["PULL_REQUEST_CREATED"] = "codecommit-repository-pull-request-created";
    RepositoryEvent["PULL_REQUEST_SOURCE_UPDATED"] = "codecommit-repository-pull-request-source-updated";
    RepositoryEvent["PULL_REQUEST_STATUS_CHANGED"] = "codecommit-repository-pull-request-status-changed";
    RepositoryEvent["PULL_REQUEST_MERGED"] = "codecommit-repository-pull-request-merged";
    RepositoryEvent["BRANCHES_AND_TAGS_CREATED"] = "codecommit-repository-branches-and-tags-created";
    RepositoryEvent["BRANCHES_AND_TAGS_DELETED"] = "codecommit-repository-branches-and-tags-deleted";
    RepositoryEvent["BRANCHES_AND_TAGS_UPDATED"] = "codecommit-repository-branches-and-tags-updated";
})(RepositoryEvent = exports.RepositoryEvent || (exports.RepositoryEvent = {}));
var ProjectEvent;
(function (ProjectEvent) {
    ProjectEvent["BUILD_STATE_FAILED"] = "codebuild-project-build-state-failed";
    ProjectEvent["BUILD_STATE_SUCCEEDED"] = "codebuild-project-build-state-succeeded";
    ProjectEvent["BUILD_STATE_IN_PROGRESS"] = "codebuild-project-build-state-in-progress";
    ProjectEvent["BUILD_STATE_STOPPED"] = "codebuild-project-build-state-stopped";
    ProjectEvent["BUILD_PHASE_FAILURE"] = "codebuild-project-build-phase-failure";
    ProjectEvent["BUILD_PHASE_SUCCESS"] = "codebuild-project-build-phase-success";
})(ProjectEvent = exports.ProjectEvent || (exports.ProjectEvent = {}));
var ApplicationEvent;
(function (ApplicationEvent) {
    ApplicationEvent["DEPLOYMENT_FAILED"] = "codedeploy-application-deployment-failed";
    ApplicationEvent["DEPLOYMENT_SUCCEEDED"] = "codedeploy-application-deployment-succeeded";
    ApplicationEvent["DEPLOYMENT_STARTED"] = "codedeploy-application-deployment-started";
})(ApplicationEvent = exports.ApplicationEvent || (exports.ApplicationEvent = {}));
var PipelineEvent;
(function (PipelineEvent) {
    PipelineEvent["ACTION_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-action-execution-succeeded";
    PipelineEvent["ACTION_EXECUTION_FAILED"] = "codepipeline-pipeline-action-execution-failed";
    PipelineEvent["ACTION_EXECUTION_CANCELED"] = "codepipeline-pipeline-action-execution-canceled";
    PipelineEvent["ACTION_EXECUTION_STARTED"] = "codepipeline-pipeline-action-execution-started";
    PipelineEvent["STAGE_EXECUTION_STARTED"] = "codepipeline-pipeline-stage-execution-started";
    PipelineEvent["STAGE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-stage-execution-succeeded";
    PipelineEvent["STAGE_EXECUTION_RESUMED"] = "codepipeline-pipeline-stage-execution-resumed";
    PipelineEvent["STAGE_EXECUTION_CANCELED"] = "codepipeline-pipeline-stage-execution-canceled";
    PipelineEvent["STAGE_EXECUTION_FAILED"] = "codepipeline-pipeline-stage-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_FAILED"] = "codepipeline-pipeline-pipeline-execution-failed";
    PipelineEvent["PIPELINE_EXECUTION_CANCELED"] = "codepipeline-pipeline-pipeline-execution-canceled";
    PipelineEvent["PIPELINE_EXECUTION_STARTED"] = "codepipeline-pipeline-pipeline-execution-started";
    PipelineEvent["PIPELINE_EXECUTION_RESUMED"] = "codepipeline-pipeline-pipeline-execution-resumed";
    PipelineEvent["PIPELINE_EXECUTION_SUCCEEDED"] = "codepipeline-pipeline-pipeline-execution-succeeded";
    PipelineEvent["PIPELINE_EXECUTION_SUPERSEDED"] = "codepipeline-pipeline-pipeline-execution-superseded";
    PipelineEvent["MANUAL_APPROVAL_FAILED"] = "codepipeline-pipeline-manual-approval-failed";
    PipelineEvent["MANUAL_APPROVAL_NEEDED"] = "codepipeline-pipeline-manual-approval-needed";
    PipelineEvent["MANUAL_APPROVAL_SUCCEEDED"] = "codepipeline-pipeline-manual-approval-succeeded";
})(PipelineEvent = exports.PipelineEvent || (exports.PipelineEvent = {}));
var DetailType;
(function (DetailType) {
    DetailType["FULL"] = "FULL";
    DetailType["BASIC"] = "BASIC";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
var Status;
(function (Status) {
    Status["DISABLED"] = "DISABLED";
    Status["ENABLED"] = "ENABLED";
})(Status = exports.Status || (exports.Status = {}));
//# sourceMappingURL=data:application/json;base64,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