#
# Copyright 2020 Two Sigma Open Source, LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from typing import Optional, Union

from nxv._style import Style


def font(
    fontname: Optional[str] = None, fontsize: Optional[Union[int, float]] = None
) -> Style:
    """
    Styles text in a graph using the given font.

    :param fontname: Optional font name.
    :param fontsize: Optional font size.
    :return: A :class:`~nxv.Style` object that applies this font.
    """
    d = {}
    if fontname is not None:
        d["fontname"] = fontname
    if fontsize is not None:
        d["fontsize"] = fontsize
    return Style(graph=d, node=d, edge=d)
