/* File: _glmnetmodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Wed Apr 22 22:50:57 2020
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *_glmnet_error;
static PyObject *_glmnet_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
/*need_typedefs*/

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(_glmnet_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int double_from_pyobj(double* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
#ifdef __sgi
        *v = PyFloat_AsDouble(obj);
#else
        *v = PyFloat_AS_DOUBLE(obj);
#endif
        return 1;
    }
    tmp = PyNumber_Float(obj);
    if (tmp) {
#ifdef __sgi
        *v = PyFloat_AsDouble(tmp);
#else
        *v = PyFloat_AS_DOUBLE(tmp);
#endif
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _glmnet_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
    PyObject* tmp = NULL;
    if (PyInt_Check(obj)) {
        *v = (int)PyInt_AS_LONG(obj);
        return 1;
    }
    tmp = PyNumber_Int(obj);
    if (tmp) {
        *v = PyInt_AS_LONG(tmp);
        Py_DECREF(tmp);
        return 1;
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyString_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = _glmnet_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC(lognet,LOGNET)(double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*);
extern void F_FUNC(splognet,SPLOGNET)(double*,int*,int*,int*,double*,int*,int*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*);
extern void F_FUNC(lsolns,LSOLNS)(int*,int*,int*,int*,double*,int*,int*,double*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/*********************************** lognet ***********************************/
static char doc_f2py_rout__glmnet_lognet[] = "\
lmu,a0,ca,ia,nin,dev0,dev,alm,nlp,jerr = lognet(parm,nc,x,y,g,jd,vp,cl,nx,flmin,ulam,thr,[ne,nlam,isd,intr,maxit,kopt])\n\nWrapper for ``lognet``.\
\n\nParameters\n----------\n"
"parm : input float\n"
"nc : input int\n"
"x : input rank-2 array('d') with bounds (no,ni)\n"
"y : input rank-2 array('d') with bounds (no,max(2,nc))\n"
"g : input rank-2 array('d') with bounds (no,shape(y,1))\n"
"jd : input rank-1 array('i') with bounds (*)\n"
"vp : input rank-1 array('d') with bounds (ni)\n"
"cl : input rank-2 array('d') with bounds (2,ni)\n"
"nx : input int\n"
"flmin : input float\n"
"ulam : input rank-1 array('d') with bounds (nlam)\n"
"thr : input float\n"
"\nOther Parameters\n----------------\n"
"ne : input int, optional\n    Default: min(shape(x,1), nx)\n"
"nlam : input int, optional\n    Default: len(ulam)\n"
"isd : input int, optional\n    Default: 1\n"
"intr : input int, optional\n    Default: 1\n"
"maxit : input int, optional\n    Default: 100000\n"
"kopt : input int, optional\n    Default: 0\n"
"\nReturns\n-------\n"
"lmu : int\n"
"a0 : rank-2 array('d') with bounds (nc,nlam)\n"
"ca : rank-3 array('d') with bounds (nx,nc,nlam)\n"
"ia : rank-1 array('i') with bounds (nx)\n"
"nin : rank-1 array('i') with bounds (nlam)\n"
"dev0 : rank-1 array('d') with bounds (nlam)\n"
"dev : rank-1 array('d') with bounds (nlam)\n"
"alm : rank-1 array('d') with bounds (nlam)\n"
"nlp : int\n"
"jerr : int";
/* extern void F_FUNC(lognet,LOGNET)(double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*); */
static PyObject *f2py_rout__glmnet_lognet(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,double*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double parm = 0;
  PyObject *parm_capi = Py_None;
  int no = 0;
  int ni = 0;
  int nc = 0;
  PyObject *nc_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[2] = {-1, -1};
  const int x_Rank = 2;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[2] = {-1, -1};
  const int y_Rank = 2;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *g = NULL;
  npy_intp g_Dims[2] = {-1, -1};
  const int g_Rank = 2;
  PyArrayObject *capi_g_tmp = NULL;
  int capi_g_intent = 0;
  PyObject *g_capi = Py_None;
  int *jd = NULL;
  npy_intp jd_Dims[1] = {-1};
  const int jd_Rank = 1;
  PyArrayObject *capi_jd_tmp = NULL;
  int capi_jd_intent = 0;
  PyObject *jd_capi = Py_None;
  double *vp = NULL;
  npy_intp vp_Dims[1] = {-1};
  const int vp_Rank = 1;
  PyArrayObject *capi_vp_tmp = NULL;
  int capi_vp_intent = 0;
  PyObject *vp_capi = Py_None;
  double *cl = NULL;
  npy_intp cl_Dims[2] = {-1, -1};
  const int cl_Rank = 2;
  PyArrayObject *capi_cl_tmp = NULL;
  int capi_cl_intent = 0;
  PyObject *cl_capi = Py_None;
  int ne = 0;
  PyObject *ne_capi = Py_None;
  int nx = 0;
  PyObject *nx_capi = Py_None;
  int nlam = 0;
  PyObject *nlam_capi = Py_None;
  double flmin = 0;
  PyObject *flmin_capi = Py_None;
  double *ulam = NULL;
  npy_intp ulam_Dims[1] = {-1};
  const int ulam_Rank = 1;
  PyArrayObject *capi_ulam_tmp = NULL;
  int capi_ulam_intent = 0;
  PyObject *ulam_capi = Py_None;
  double thr = 0;
  PyObject *thr_capi = Py_None;
  int isd = 0;
  PyObject *isd_capi = Py_None;
  int intr = 0;
  PyObject *intr_capi = Py_None;
  int maxit = 0;
  PyObject *maxit_capi = Py_None;
  int kopt = 0;
  PyObject *kopt_capi = Py_None;
  int lmu = 0;
  double *a0 = NULL;
  npy_intp a0_Dims[2] = {-1, -1};
  const int a0_Rank = 2;
  PyArrayObject *capi_a0_tmp = NULL;
  int capi_a0_intent = 0;
  double *ca = NULL;
  npy_intp ca_Dims[3] = {-1, -1, -1};
  const int ca_Rank = 3;
  PyArrayObject *capi_ca_tmp = NULL;
  int capi_ca_intent = 0;
  int *ia = NULL;
  npy_intp ia_Dims[1] = {-1};
  const int ia_Rank = 1;
  PyArrayObject *capi_ia_tmp = NULL;
  int capi_ia_intent = 0;
  int *nin = NULL;
  npy_intp nin_Dims[1] = {-1};
  const int nin_Rank = 1;
  PyArrayObject *capi_nin_tmp = NULL;
  int capi_nin_intent = 0;
  double *dev0 = NULL;
  npy_intp dev0_Dims[1] = {-1};
  const int dev0_Rank = 1;
  PyArrayObject *capi_dev0_tmp = NULL;
  int capi_dev0_intent = 0;
  double *dev = NULL;
  npy_intp dev_Dims[1] = {-1};
  const int dev_Rank = 1;
  PyArrayObject *capi_dev_tmp = NULL;
  int capi_dev_intent = 0;
  double *alm = NULL;
  npy_intp alm_Dims[1] = {-1};
  const int alm_Rank = 1;
  PyArrayObject *capi_alm_tmp = NULL;
  int capi_alm_intent = 0;
  int nlp = 0;
  int jerr = 0;
  static char *capi_kwlist[] = {"parm","nc","x","y","g","jd","vp","cl","nx","flmin","ulam","thr","ne","nlam","isd","intr","maxit","kopt",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOO|OOOOOO:_glmnet.lognet",\
    capi_kwlist,&parm_capi,&nc_capi,&x_capi,&y_capi,&g_capi,&jd_capi,&vp_capi,&cl_capi,&nx_capi,&flmin_capi,&ulam_capi,&thr_capi,&ne_capi,&nlam_capi,&isd_capi,&intr_capi,&maxit_capi,&kopt_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable parm */
    f2py_success = double_from_pyobj(&parm,parm_capi,"_glmnet.lognet() 1st argument (parm) can't be converted to double");
  if (f2py_success) {
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 3rd argument `x' of _glmnet.lognet to C/Fortran array" );
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable jd */
  ;
  capi_jd_intent |= F2PY_INTENT_IN;
  capi_jd_tmp = array_from_pyobj(NPY_INT,jd_Dims,jd_Rank,capi_jd_intent,jd_capi);
  if (capi_jd_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 6th argument `jd' of _glmnet.lognet to C/Fortran array" );
  } else {
    jd = (int *)(PyArray_DATA(capi_jd_tmp));

  /* Processing variable nx */
    f2py_success = int_from_pyobj(&nx,nx_capi,"_glmnet.lognet() 9th argument (nx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable flmin */
    f2py_success = double_from_pyobj(&flmin,flmin_capi,"_glmnet.lognet() 10th argument (flmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ulam */
  ;
  capi_ulam_intent |= F2PY_INTENT_IN;
  capi_ulam_tmp = array_from_pyobj(NPY_DOUBLE,ulam_Dims,ulam_Rank,capi_ulam_intent,ulam_capi);
  if (capi_ulam_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 11st argument `ulam' of _glmnet.lognet to C/Fortran array" );
  } else {
    ulam = (double *)(PyArray_DATA(capi_ulam_tmp));

  /* Processing variable thr */
    f2py_success = double_from_pyobj(&thr,thr_capi,"_glmnet.lognet() 12nd argument (thr) can't be converted to double");
  if (f2py_success) {
  /* Processing variable isd */
  if (isd_capi == Py_None) isd = 1; else
    f2py_success = int_from_pyobj(&isd,isd_capi,"_glmnet.lognet() 3rd keyword (isd) can't be converted to int");
  if (f2py_success) {
  /* Processing variable intr */
  if (intr_capi == Py_None) intr = 1; else
    f2py_success = int_from_pyobj(&intr,intr_capi,"_glmnet.lognet() 4th keyword (intr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable maxit */
  if (maxit_capi == Py_None) maxit = 100000; else
    f2py_success = int_from_pyobj(&maxit,maxit_capi,"_glmnet.lognet() 5th keyword (maxit) can't be converted to int");
  if (f2py_success) {
  /* Processing variable kopt */
  if (kopt_capi == Py_None) kopt = 0; else
    f2py_success = int_from_pyobj(&kopt,kopt_capi,"_glmnet.lognet() 6th keyword (kopt) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lmu */
  /* Processing variable nlp */
  /* Processing variable jerr */
  /* Processing variable no */
  no = shape(x,0);
  CHECKSCALAR(shape(x,0)==no,"shape(x,0)==no","hidden no","lognet:no=%d",no) {
  /* Processing variable ni */
  ni = shape(x,1);
  CHECKSCALAR(shape(x,1)==ni,"shape(x,1)==ni","hidden ni","lognet:ni=%d",ni) {
  /* Processing variable y */
  y_Dims[0]=no;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 4th argument `y' of _glmnet.lognet to C/Fortran array" );
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable g */
  g_Dims[0]=no,g_Dims[1]=shape(y,1);
  capi_g_intent |= F2PY_INTENT_IN;
  capi_g_tmp = array_from_pyobj(NPY_DOUBLE,g_Dims,g_Rank,capi_g_intent,g_capi);
  if (capi_g_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 5th argument `g' of _glmnet.lognet to C/Fortran array" );
  } else {
    g = (double *)(PyArray_DATA(capi_g_tmp));

  /* Processing variable vp */
  vp_Dims[0]=ni;
  capi_vp_intent |= F2PY_INTENT_IN;
  capi_vp_tmp = array_from_pyobj(NPY_DOUBLE,vp_Dims,vp_Rank,capi_vp_intent,vp_capi);
  if (capi_vp_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 7th argument `vp' of _glmnet.lognet to C/Fortran array" );
  } else {
    vp = (double *)(PyArray_DATA(capi_vp_tmp));

  /* Processing variable cl */
  cl_Dims[0]=2,cl_Dims[1]=ni;
  capi_cl_intent |= F2PY_INTENT_IN;
  capi_cl_tmp = array_from_pyobj(NPY_DOUBLE,cl_Dims,cl_Rank,capi_cl_intent,cl_capi);
  if (capi_cl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 8th argument `cl' of _glmnet.lognet to C/Fortran array" );
  } else {
    cl = (double *)(PyArray_DATA(capi_cl_tmp));

  /* Processing variable ne */
  if (ne_capi == Py_None) ne = min(shape(x,1), nx); else
    f2py_success = int_from_pyobj(&ne,ne_capi,"_glmnet.lognet() 1st keyword (ne) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nlam */
  if (nlam_capi == Py_None) nlam = len(ulam); else
    f2py_success = int_from_pyobj(&nlam,nlam_capi,"_glmnet.lognet() 2nd keyword (nlam) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((flmin < 1.0 || len(ulam)==nlam),"(flmin < 1.0 || len(ulam)==nlam)","2nd keyword nlam","lognet:nlam=%d",nlam) {
  /* Processing variable ia */
  ia_Dims[0]=nx;
  capi_ia_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ia_tmp = array_from_pyobj(NPY_INT,ia_Dims,ia_Rank,capi_ia_intent,Py_None);
  if (capi_ia_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `ia' of _glmnet.lognet to C/Fortran array" );
  } else {
    ia = (int *)(PyArray_DATA(capi_ia_tmp));

  /* Processing variable nin */
  nin_Dims[0]=nlam;
  capi_nin_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_nin_tmp = array_from_pyobj(NPY_INT,nin_Dims,nin_Rank,capi_nin_intent,Py_None);
  if (capi_nin_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `nin' of _glmnet.lognet to C/Fortran array" );
  } else {
    nin = (int *)(PyArray_DATA(capi_nin_tmp));

  /* Processing variable dev0 */
  dev0_Dims[0]=nlam;
  capi_dev0_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dev0_tmp = array_from_pyobj(NPY_DOUBLE,dev0_Dims,dev0_Rank,capi_dev0_intent,Py_None);
  if (capi_dev0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `dev0' of _glmnet.lognet to C/Fortran array" );
  } else {
    dev0 = (double *)(PyArray_DATA(capi_dev0_tmp));

  /* Processing variable dev */
  dev_Dims[0]=nlam;
  capi_dev_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dev_tmp = array_from_pyobj(NPY_DOUBLE,dev_Dims,dev_Rank,capi_dev_intent,Py_None);
  if (capi_dev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `dev' of _glmnet.lognet to C/Fortran array" );
  } else {
    dev = (double *)(PyArray_DATA(capi_dev_tmp));

  /* Processing variable alm */
  alm_Dims[0]=nlam;
  capi_alm_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_alm_tmp = array_from_pyobj(NPY_DOUBLE,alm_Dims,alm_Rank,capi_alm_intent,Py_None);
  if (capi_alm_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `alm' of _glmnet.lognet to C/Fortran array" );
  } else {
    alm = (double *)(PyArray_DATA(capi_alm_tmp));

  /* Processing variable nc */
    f2py_success = int_from_pyobj(&nc,nc_capi,"_glmnet.lognet() 2nd argument (nc) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(y,1)==max(2,nc),"shape(y,1)==max(2,nc)","2nd argument nc","lognet:nc=%d",nc) {
  /* Processing variable a0 */
  a0_Dims[0]=nc,a0_Dims[1]=nlam;
  capi_a0_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a0_tmp = array_from_pyobj(NPY_DOUBLE,a0_Dims,a0_Rank,capi_a0_intent,Py_None);
  if (capi_a0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `a0' of _glmnet.lognet to C/Fortran array" );
  } else {
    a0 = (double *)(PyArray_DATA(capi_a0_tmp));

  /* Processing variable ca */
  ca_Dims[0]=nx,ca_Dims[1]=nc,ca_Dims[2]=nlam;
  capi_ca_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ca_tmp = array_from_pyobj(NPY_DOUBLE,ca_Dims,ca_Rank,capi_ca_intent,Py_None);
  if (capi_ca_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `ca' of _glmnet.lognet to C/Fortran array" );
  } else {
    ca = (double *)(PyArray_DATA(capi_ca_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
      Py_BEGIN_ALLOW_THREADS
        (*f2py_func)(&parm,&no,&ni,&nc,x,y,g,jd,vp,cl,&ne,&nx,&nlam,&flmin,ulam,&thr,&isd,&intr,&maxit,&kopt,&lmu,a0,ca,ia,nin,dev0,dev,alm,&nlp,&jerr);
      Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("iNNNNNNNii",lmu,capi_a0_tmp,capi_ca_tmp,capi_ia_tmp,capi_nin_tmp,capi_dev0_tmp,capi_dev_tmp,capi_alm_tmp,nlp,jerr);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ca_tmp == NULL) ... else of ca*/
  /* End of cleaning variable ca */
  }  /*if (capi_a0_tmp == NULL) ... else of a0*/
  /* End of cleaning variable a0 */
  } /*CHECKSCALAR(shape(y,1)==max(2,nc))*/
  } /*if (f2py_success) of nc*/
  /* End of cleaning variable nc */
  }  /*if (capi_alm_tmp == NULL) ... else of alm*/
  /* End of cleaning variable alm */
  }  /*if (capi_dev_tmp == NULL) ... else of dev*/
  /* End of cleaning variable dev */
  }  /*if (capi_dev0_tmp == NULL) ... else of dev0*/
  /* End of cleaning variable dev0 */
  }  /*if (capi_nin_tmp == NULL) ... else of nin*/
  /* End of cleaning variable nin */
  }  /*if (capi_ia_tmp == NULL) ... else of ia*/
  /* End of cleaning variable ia */
  } /*CHECKSCALAR((flmin < 1.0 || len(ulam)==nlam))*/
  } /*if (f2py_success) of nlam*/
  /* End of cleaning variable nlam */
  } /*if (f2py_success) of ne*/
  /* End of cleaning variable ne */
  if((PyObject *)capi_cl_tmp!=cl_capi) {
    Py_XDECREF(capi_cl_tmp); }
  }  /*if (capi_cl_tmp == NULL) ... else of cl*/
  /* End of cleaning variable cl */
  if((PyObject *)capi_vp_tmp!=vp_capi) {
    Py_XDECREF(capi_vp_tmp); }
  }  /*if (capi_vp_tmp == NULL) ... else of vp*/
  /* End of cleaning variable vp */
  if((PyObject *)capi_g_tmp!=g_capi) {
    Py_XDECREF(capi_g_tmp); }
  }  /*if (capi_g_tmp == NULL) ... else of g*/
  /* End of cleaning variable g */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  } /*CHECKSCALAR(shape(x,1)==ni)*/
  /* End of cleaning variable ni */
  } /*CHECKSCALAR(shape(x,0)==no)*/
  /* End of cleaning variable no */
  /* End of cleaning variable jerr */
  /* End of cleaning variable nlp */
  /* End of cleaning variable lmu */
  } /*if (f2py_success) of kopt*/
  /* End of cleaning variable kopt */
  } /*if (f2py_success) of maxit*/
  /* End of cleaning variable maxit */
  } /*if (f2py_success) of intr*/
  /* End of cleaning variable intr */
  } /*if (f2py_success) of isd*/
  /* End of cleaning variable isd */
  } /*if (f2py_success) of thr*/
  /* End of cleaning variable thr */
  if((PyObject *)capi_ulam_tmp!=ulam_capi) {
    Py_XDECREF(capi_ulam_tmp); }
  }  /*if (capi_ulam_tmp == NULL) ... else of ulam*/
  /* End of cleaning variable ulam */
  } /*if (f2py_success) of flmin*/
  /* End of cleaning variable flmin */
  } /*if (f2py_success) of nx*/
  /* End of cleaning variable nx */
  if((PyObject *)capi_jd_tmp!=jd_capi) {
    Py_XDECREF(capi_jd_tmp); }
  }  /*if (capi_jd_tmp == NULL) ... else of jd*/
  /* End of cleaning variable jd */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of parm*/
  /* End of cleaning variable parm */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of lognet *******************************/

/********************************** splognet **********************************/
static char doc_f2py_rout__glmnet_splognet[] = "\
lmu,a0,ca,ia,nin,dev0,dev,alm,nlp,jerr = splognet(parm,no,ni,nc,x,ix,jx,y,g,jd,vp,cl,ne,nx,flmin,ulam,thr,[nlam,isd,intr,maxit,kopt])\n\nWrapper for ``splognet``.\
\n\nParameters\n----------\n"
"parm : input float\n"
"no : input int\n"
"ni : input int\n"
"nc : input int\n"
"x : input rank-1 array('d') with bounds (*)\n"
"ix : input rank-1 array('i') with bounds (*)\n"
"jx : input rank-1 array('i') with bounds (*)\n"
"y : input rank-2 array('d') with bounds (no,max(2,nc))\n"
"g : input rank-2 array('d') with bounds (no,shape(y,1))\n"
"jd : input rank-1 array('i') with bounds (*)\n"
"vp : input rank-1 array('d') with bounds (ni)\n"
"cl : input rank-2 array('d') with bounds (2,ni)\n"
"ne : input int\n"
"nx : input int\n"
"flmin : input float\n"
"ulam : input rank-1 array('d') with bounds (nlam)\n"
"thr : input float\n"
"\nOther Parameters\n----------------\n"
"nlam : input int, optional\n    Default: len(ulam)\n"
"isd : input int, optional\n    Default: 1\n"
"intr : input int, optional\n    Default: 1\n"
"maxit : input int, optional\n    Default: 100000\n"
"kopt : input int, optional\n    Default: 0\n"
"\nReturns\n-------\n"
"lmu : int\n"
"a0 : rank-2 array('d') with bounds (nc,nlam)\n"
"ca : rank-3 array('d') with bounds (nx,nc,nlam)\n"
"ia : rank-1 array('i') with bounds (nx)\n"
"nin : rank-1 array('i') with bounds (nlam)\n"
"dev0 : rank-1 array('d') with bounds (nlam)\n"
"dev : rank-1 array('d') with bounds (nlam)\n"
"alm : rank-1 array('d') with bounds (nlam)\n"
"nlp : int\n"
"jerr : int";
/* extern void F_FUNC(splognet,SPLOGNET)(double*,int*,int*,int*,double*,int*,int*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*); */
static PyObject *f2py_rout__glmnet_splognet(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,int*,int*,double*,int*,int*,double*,double*,int*,double*,double*,int*,int*,int*,double*,double*,double*,int*,int*,int*,int*,int*,double*,double*,int*,int*,double*,double*,double*,int*,int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double parm = 0;
  PyObject *parm_capi = Py_None;
  int no = 0;
  PyObject *no_capi = Py_None;
  int ni = 0;
  PyObject *ni_capi = Py_None;
  int nc = 0;
  PyObject *nc_capi = Py_None;
  double *x = NULL;
  npy_intp x_Dims[1] = {-1};
  const int x_Rank = 1;
  PyArrayObject *capi_x_tmp = NULL;
  int capi_x_intent = 0;
  PyObject *x_capi = Py_None;
  int *ix = NULL;
  npy_intp ix_Dims[1] = {-1};
  const int ix_Rank = 1;
  PyArrayObject *capi_ix_tmp = NULL;
  int capi_ix_intent = 0;
  PyObject *ix_capi = Py_None;
  int *jx = NULL;
  npy_intp jx_Dims[1] = {-1};
  const int jx_Rank = 1;
  PyArrayObject *capi_jx_tmp = NULL;
  int capi_jx_intent = 0;
  PyObject *jx_capi = Py_None;
  double *y = NULL;
  npy_intp y_Dims[2] = {-1, -1};
  const int y_Rank = 2;
  PyArrayObject *capi_y_tmp = NULL;
  int capi_y_intent = 0;
  PyObject *y_capi = Py_None;
  double *g = NULL;
  npy_intp g_Dims[2] = {-1, -1};
  const int g_Rank = 2;
  PyArrayObject *capi_g_tmp = NULL;
  int capi_g_intent = 0;
  PyObject *g_capi = Py_None;
  int *jd = NULL;
  npy_intp jd_Dims[1] = {-1};
  const int jd_Rank = 1;
  PyArrayObject *capi_jd_tmp = NULL;
  int capi_jd_intent = 0;
  PyObject *jd_capi = Py_None;
  double *vp = NULL;
  npy_intp vp_Dims[1] = {-1};
  const int vp_Rank = 1;
  PyArrayObject *capi_vp_tmp = NULL;
  int capi_vp_intent = 0;
  PyObject *vp_capi = Py_None;
  double *cl = NULL;
  npy_intp cl_Dims[2] = {-1, -1};
  const int cl_Rank = 2;
  PyArrayObject *capi_cl_tmp = NULL;
  int capi_cl_intent = 0;
  PyObject *cl_capi = Py_None;
  int ne = 0;
  PyObject *ne_capi = Py_None;
  int nx = 0;
  PyObject *nx_capi = Py_None;
  int nlam = 0;
  PyObject *nlam_capi = Py_None;
  double flmin = 0;
  PyObject *flmin_capi = Py_None;
  double *ulam = NULL;
  npy_intp ulam_Dims[1] = {-1};
  const int ulam_Rank = 1;
  PyArrayObject *capi_ulam_tmp = NULL;
  int capi_ulam_intent = 0;
  PyObject *ulam_capi = Py_None;
  double thr = 0;
  PyObject *thr_capi = Py_None;
  int isd = 0;
  PyObject *isd_capi = Py_None;
  int intr = 0;
  PyObject *intr_capi = Py_None;
  int maxit = 0;
  PyObject *maxit_capi = Py_None;
  int kopt = 0;
  PyObject *kopt_capi = Py_None;
  int lmu = 0;
  double *a0 = NULL;
  npy_intp a0_Dims[2] = {-1, -1};
  const int a0_Rank = 2;
  PyArrayObject *capi_a0_tmp = NULL;
  int capi_a0_intent = 0;
  double *ca = NULL;
  npy_intp ca_Dims[3] = {-1, -1, -1};
  const int ca_Rank = 3;
  PyArrayObject *capi_ca_tmp = NULL;
  int capi_ca_intent = 0;
  int *ia = NULL;
  npy_intp ia_Dims[1] = {-1};
  const int ia_Rank = 1;
  PyArrayObject *capi_ia_tmp = NULL;
  int capi_ia_intent = 0;
  int *nin = NULL;
  npy_intp nin_Dims[1] = {-1};
  const int nin_Rank = 1;
  PyArrayObject *capi_nin_tmp = NULL;
  int capi_nin_intent = 0;
  double *dev0 = NULL;
  npy_intp dev0_Dims[1] = {-1};
  const int dev0_Rank = 1;
  PyArrayObject *capi_dev0_tmp = NULL;
  int capi_dev0_intent = 0;
  double *dev = NULL;
  npy_intp dev_Dims[1] = {-1};
  const int dev_Rank = 1;
  PyArrayObject *capi_dev_tmp = NULL;
  int capi_dev_intent = 0;
  double *alm = NULL;
  npy_intp alm_Dims[1] = {-1};
  const int alm_Rank = 1;
  PyArrayObject *capi_alm_tmp = NULL;
  int capi_alm_intent = 0;
  int nlp = 0;
  int jerr = 0;
  static char *capi_kwlist[] = {"parm","no","ni","nc","x","ix","jx","y","g","jd","vp","cl","ne","nx","flmin","ulam","thr","nlam","isd","intr","maxit","kopt",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOOOOOOOO|OOOOO:_glmnet.splognet",\
    capi_kwlist,&parm_capi,&no_capi,&ni_capi,&nc_capi,&x_capi,&ix_capi,&jx_capi,&y_capi,&g_capi,&jd_capi,&vp_capi,&cl_capi,&ne_capi,&nx_capi,&flmin_capi,&ulam_capi,&thr_capi,&nlam_capi,&isd_capi,&intr_capi,&maxit_capi,&kopt_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable parm */
    f2py_success = double_from_pyobj(&parm,parm_capi,"_glmnet.splognet() 1st argument (parm) can't be converted to double");
  if (f2py_success) {
  /* Processing variable no */
    f2py_success = int_from_pyobj(&no,no_capi,"_glmnet.splognet() 2nd argument (no) can't be converted to int");
  if (f2py_success) {
  /* Processing variable x */
  ;
  capi_x_intent |= F2PY_INTENT_IN;
  capi_x_tmp = array_from_pyobj(NPY_DOUBLE,x_Dims,x_Rank,capi_x_intent,x_capi);
  if (capi_x_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 5th argument `x' of _glmnet.splognet to C/Fortran array" );
  } else {
    x = (double *)(PyArray_DATA(capi_x_tmp));

  /* Processing variable ix */
  ;
  capi_ix_intent |= F2PY_INTENT_IN;
  capi_ix_tmp = array_from_pyobj(NPY_INT,ix_Dims,ix_Rank,capi_ix_intent,ix_capi);
  if (capi_ix_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 6th argument `ix' of _glmnet.splognet to C/Fortran array" );
  } else {
    ix = (int *)(PyArray_DATA(capi_ix_tmp));

  /* Processing variable jx */
  ;
  capi_jx_intent |= F2PY_INTENT_IN;
  capi_jx_tmp = array_from_pyobj(NPY_INT,jx_Dims,jx_Rank,capi_jx_intent,jx_capi);
  if (capi_jx_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 7th argument `jx' of _glmnet.splognet to C/Fortran array" );
  } else {
    jx = (int *)(PyArray_DATA(capi_jx_tmp));

  /* Processing variable jd */
  ;
  capi_jd_intent |= F2PY_INTENT_IN;
  capi_jd_tmp = array_from_pyobj(NPY_INT,jd_Dims,jd_Rank,capi_jd_intent,jd_capi);
  if (capi_jd_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 10th argument `jd' of _glmnet.splognet to C/Fortran array" );
  } else {
    jd = (int *)(PyArray_DATA(capi_jd_tmp));

  /* Processing variable vp */
  ;
  capi_vp_intent |= F2PY_INTENT_IN;
  capi_vp_tmp = array_from_pyobj(NPY_DOUBLE,vp_Dims,vp_Rank,capi_vp_intent,vp_capi);
  if (capi_vp_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 11st argument `vp' of _glmnet.splognet to C/Fortran array" );
  } else {
    vp = (double *)(PyArray_DATA(capi_vp_tmp));

  /* Processing variable ne */
    f2py_success = int_from_pyobj(&ne,ne_capi,"_glmnet.splognet() 13rd argument (ne) can't be converted to int");
  if (f2py_success) {
  /* Processing variable nx */
    f2py_success = int_from_pyobj(&nx,nx_capi,"_glmnet.splognet() 14th argument (nx) can't be converted to int");
  if (f2py_success) {
  /* Processing variable flmin */
    f2py_success = double_from_pyobj(&flmin,flmin_capi,"_glmnet.splognet() 15th argument (flmin) can't be converted to double");
  if (f2py_success) {
  /* Processing variable ulam */
  ;
  capi_ulam_intent |= F2PY_INTENT_IN;
  capi_ulam_tmp = array_from_pyobj(NPY_DOUBLE,ulam_Dims,ulam_Rank,capi_ulam_intent,ulam_capi);
  if (capi_ulam_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 16th argument `ulam' of _glmnet.splognet to C/Fortran array" );
  } else {
    ulam = (double *)(PyArray_DATA(capi_ulam_tmp));

  /* Processing variable thr */
    f2py_success = double_from_pyobj(&thr,thr_capi,"_glmnet.splognet() 17th argument (thr) can't be converted to double");
  if (f2py_success) {
  /* Processing variable isd */
  if (isd_capi == Py_None) isd = 1; else
    f2py_success = int_from_pyobj(&isd,isd_capi,"_glmnet.splognet() 2nd keyword (isd) can't be converted to int");
  if (f2py_success) {
  /* Processing variable intr */
  if (intr_capi == Py_None) intr = 1; else
    f2py_success = int_from_pyobj(&intr,intr_capi,"_glmnet.splognet() 3rd keyword (intr) can't be converted to int");
  if (f2py_success) {
  /* Processing variable maxit */
  if (maxit_capi == Py_None) maxit = 100000; else
    f2py_success = int_from_pyobj(&maxit,maxit_capi,"_glmnet.splognet() 4th keyword (maxit) can't be converted to int");
  if (f2py_success) {
  /* Processing variable kopt */
  if (kopt_capi == Py_None) kopt = 0; else
    f2py_success = int_from_pyobj(&kopt,kopt_capi,"_glmnet.splognet() 5th keyword (kopt) can't be converted to int");
  if (f2py_success) {
  /* Processing variable lmu */
  /* Processing variable nlp */
  /* Processing variable jerr */
  /* Processing variable ni */
    f2py_success = int_from_pyobj(&ni,ni_capi,"_glmnet.splognet() 3rd argument (ni) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(vp)>=ni,"len(vp)>=ni","3rd argument ni","splognet:ni=%d",ni) {
  /* Processing variable y */
  y_Dims[0]=no;
  capi_y_intent |= F2PY_INTENT_IN;
  capi_y_tmp = array_from_pyobj(NPY_DOUBLE,y_Dims,y_Rank,capi_y_intent,y_capi);
  if (capi_y_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 8th argument `y' of _glmnet.splognet to C/Fortran array" );
  } else {
    y = (double *)(PyArray_DATA(capi_y_tmp));

  /* Processing variable g */
  g_Dims[0]=no,g_Dims[1]=shape(y,1);
  capi_g_intent |= F2PY_INTENT_IN;
  capi_g_tmp = array_from_pyobj(NPY_DOUBLE,g_Dims,g_Rank,capi_g_intent,g_capi);
  if (capi_g_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 9th argument `g' of _glmnet.splognet to C/Fortran array" );
  } else {
    g = (double *)(PyArray_DATA(capi_g_tmp));

  /* Processing variable cl */
  cl_Dims[0]=2,cl_Dims[1]=ni;
  capi_cl_intent |= F2PY_INTENT_IN;
  capi_cl_tmp = array_from_pyobj(NPY_DOUBLE,cl_Dims,cl_Rank,capi_cl_intent,cl_capi);
  if (capi_cl_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 12nd argument `cl' of _glmnet.splognet to C/Fortran array" );
  } else {
    cl = (double *)(PyArray_DATA(capi_cl_tmp));

  /* Processing variable nlam */
  if (nlam_capi == Py_None) nlam = len(ulam); else
    f2py_success = int_from_pyobj(&nlam,nlam_capi,"_glmnet.splognet() 1st keyword (nlam) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((flmin < 1.0 || len(ulam)==nlam),"(flmin < 1.0 || len(ulam)==nlam)","1st keyword nlam","splognet:nlam=%d",nlam) {
  /* Processing variable ia */
  ia_Dims[0]=nx;
  capi_ia_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ia_tmp = array_from_pyobj(NPY_INT,ia_Dims,ia_Rank,capi_ia_intent,Py_None);
  if (capi_ia_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `ia' of _glmnet.splognet to C/Fortran array" );
  } else {
    ia = (int *)(PyArray_DATA(capi_ia_tmp));

  /* Processing variable nin */
  nin_Dims[0]=nlam;
  capi_nin_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_nin_tmp = array_from_pyobj(NPY_INT,nin_Dims,nin_Rank,capi_nin_intent,Py_None);
  if (capi_nin_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `nin' of _glmnet.splognet to C/Fortran array" );
  } else {
    nin = (int *)(PyArray_DATA(capi_nin_tmp));

  /* Processing variable dev0 */
  dev0_Dims[0]=nlam;
  capi_dev0_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dev0_tmp = array_from_pyobj(NPY_DOUBLE,dev0_Dims,dev0_Rank,capi_dev0_intent,Py_None);
  if (capi_dev0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `dev0' of _glmnet.splognet to C/Fortran array" );
  } else {
    dev0 = (double *)(PyArray_DATA(capi_dev0_tmp));

  /* Processing variable dev */
  dev_Dims[0]=nlam;
  capi_dev_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_dev_tmp = array_from_pyobj(NPY_DOUBLE,dev_Dims,dev_Rank,capi_dev_intent,Py_None);
  if (capi_dev_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `dev' of _glmnet.splognet to C/Fortran array" );
  } else {
    dev = (double *)(PyArray_DATA(capi_dev_tmp));

  /* Processing variable alm */
  alm_Dims[0]=nlam;
  capi_alm_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_alm_tmp = array_from_pyobj(NPY_DOUBLE,alm_Dims,alm_Rank,capi_alm_intent,Py_None);
  if (capi_alm_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `alm' of _glmnet.splognet to C/Fortran array" );
  } else {
    alm = (double *)(PyArray_DATA(capi_alm_tmp));

  /* Processing variable nc */
    f2py_success = int_from_pyobj(&nc,nc_capi,"_glmnet.splognet() 4th argument (nc) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(y,1)==max(2, nc),"shape(y,1)==max(2, nc)","4th argument nc","splognet:nc=%d",nc) {
  /* Processing variable a0 */
  a0_Dims[0]=nc,a0_Dims[1]=nlam;
  capi_a0_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a0_tmp = array_from_pyobj(NPY_DOUBLE,a0_Dims,a0_Rank,capi_a0_intent,Py_None);
  if (capi_a0_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `a0' of _glmnet.splognet to C/Fortran array" );
  } else {
    a0 = (double *)(PyArray_DATA(capi_a0_tmp));

  /* Processing variable ca */
  ca_Dims[0]=nx,ca_Dims[1]=nc,ca_Dims[2]=nlam;
  capi_ca_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_ca_tmp = array_from_pyobj(NPY_DOUBLE,ca_Dims,ca_Rank,capi_ca_intent,Py_None);
  if (capi_ca_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `ca' of _glmnet.splognet to C/Fortran array" );
  } else {
    ca = (double *)(PyArray_DATA(capi_ca_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
      Py_BEGIN_ALLOW_THREADS
        (*f2py_func)(&parm,&no,&ni,&nc,x,ix,jx,y,g,jd,vp,cl,&ne,&nx,&nlam,&flmin,ulam,&thr,&isd,&intr,&maxit,&kopt,&lmu,a0,ca,ia,nin,dev0,dev,alm,&nlp,&jerr);
      Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("iNNNNNNNii",lmu,capi_a0_tmp,capi_ca_tmp,capi_ia_tmp,capi_nin_tmp,capi_dev0_tmp,capi_dev_tmp,capi_alm_tmp,nlp,jerr);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_ca_tmp == NULL) ... else of ca*/
  /* End of cleaning variable ca */
  }  /*if (capi_a0_tmp == NULL) ... else of a0*/
  /* End of cleaning variable a0 */
  } /*CHECKSCALAR(shape(y,1)==max(2, nc))*/
  } /*if (f2py_success) of nc*/
  /* End of cleaning variable nc */
  }  /*if (capi_alm_tmp == NULL) ... else of alm*/
  /* End of cleaning variable alm */
  }  /*if (capi_dev_tmp == NULL) ... else of dev*/
  /* End of cleaning variable dev */
  }  /*if (capi_dev0_tmp == NULL) ... else of dev0*/
  /* End of cleaning variable dev0 */
  }  /*if (capi_nin_tmp == NULL) ... else of nin*/
  /* End of cleaning variable nin */
  }  /*if (capi_ia_tmp == NULL) ... else of ia*/
  /* End of cleaning variable ia */
  } /*CHECKSCALAR((flmin < 1.0 || len(ulam)==nlam))*/
  } /*if (f2py_success) of nlam*/
  /* End of cleaning variable nlam */
  if((PyObject *)capi_cl_tmp!=cl_capi) {
    Py_XDECREF(capi_cl_tmp); }
  }  /*if (capi_cl_tmp == NULL) ... else of cl*/
  /* End of cleaning variable cl */
  if((PyObject *)capi_g_tmp!=g_capi) {
    Py_XDECREF(capi_g_tmp); }
  }  /*if (capi_g_tmp == NULL) ... else of g*/
  /* End of cleaning variable g */
  if((PyObject *)capi_y_tmp!=y_capi) {
    Py_XDECREF(capi_y_tmp); }
  }  /*if (capi_y_tmp == NULL) ... else of y*/
  /* End of cleaning variable y */
  } /*CHECKSCALAR(len(vp)>=ni)*/
  } /*if (f2py_success) of ni*/
  /* End of cleaning variable ni */
  /* End of cleaning variable jerr */
  /* End of cleaning variable nlp */
  /* End of cleaning variable lmu */
  } /*if (f2py_success) of kopt*/
  /* End of cleaning variable kopt */
  } /*if (f2py_success) of maxit*/
  /* End of cleaning variable maxit */
  } /*if (f2py_success) of intr*/
  /* End of cleaning variable intr */
  } /*if (f2py_success) of isd*/
  /* End of cleaning variable isd */
  } /*if (f2py_success) of thr*/
  /* End of cleaning variable thr */
  if((PyObject *)capi_ulam_tmp!=ulam_capi) {
    Py_XDECREF(capi_ulam_tmp); }
  }  /*if (capi_ulam_tmp == NULL) ... else of ulam*/
  /* End of cleaning variable ulam */
  } /*if (f2py_success) of flmin*/
  /* End of cleaning variable flmin */
  } /*if (f2py_success) of nx*/
  /* End of cleaning variable nx */
  } /*if (f2py_success) of ne*/
  /* End of cleaning variable ne */
  if((PyObject *)capi_vp_tmp!=vp_capi) {
    Py_XDECREF(capi_vp_tmp); }
  }  /*if (capi_vp_tmp == NULL) ... else of vp*/
  /* End of cleaning variable vp */
  if((PyObject *)capi_jd_tmp!=jd_capi) {
    Py_XDECREF(capi_jd_tmp); }
  }  /*if (capi_jd_tmp == NULL) ... else of jd*/
  /* End of cleaning variable jd */
  if((PyObject *)capi_jx_tmp!=jx_capi) {
    Py_XDECREF(capi_jx_tmp); }
  }  /*if (capi_jx_tmp == NULL) ... else of jx*/
  /* End of cleaning variable jx */
  if((PyObject *)capi_ix_tmp!=ix_capi) {
    Py_XDECREF(capi_ix_tmp); }
  }  /*if (capi_ix_tmp == NULL) ... else of ix*/
  /* End of cleaning variable ix */
  if((PyObject *)capi_x_tmp!=x_capi) {
    Py_XDECREF(capi_x_tmp); }
  }  /*if (capi_x_tmp == NULL) ... else of x*/
  /* End of cleaning variable x */
  } /*if (f2py_success) of no*/
  /* End of cleaning variable no */
  } /*if (f2py_success) of parm*/
  /* End of cleaning variable parm */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/****************************** end of splognet ******************************/

/*********************************** lsolns ***********************************/
static char doc_f2py_rout__glmnet_lsolns[] = "\
b = lsolns(ni,ca,ia,nin)\n\nWrapper for ``lsolns``.\
\n\nParameters\n----------\n"
"ni : input int\n"
"ca : input rank-3 array('d') with bounds (nx,nc,lmu)\n"
"ia : input rank-1 array('i') with bounds (nx)\n"
"nin : input rank-1 array('i') with bounds (lmu)\n"
"\nReturns\n-------\n"
"b : rank-3 array('d') with bounds (ni,nc,lmu)";
/* extern void F_FUNC(lsolns,LSOLNS)(int*,int*,int*,int*,double*,int*,int*,double*); */
static PyObject *f2py_rout__glmnet_lsolns(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,double*,int*,int*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int ni = 0;
  PyObject *ni_capi = Py_None;
  int nx = 0;
  int nc = 0;
  int lmu = 0;
  double *ca = NULL;
  npy_intp ca_Dims[3] = {-1, -1, -1};
  const int ca_Rank = 3;
  PyArrayObject *capi_ca_tmp = NULL;
  int capi_ca_intent = 0;
  PyObject *ca_capi = Py_None;
  int *ia = NULL;
  npy_intp ia_Dims[1] = {-1};
  const int ia_Rank = 1;
  PyArrayObject *capi_ia_tmp = NULL;
  int capi_ia_intent = 0;
  PyObject *ia_capi = Py_None;
  int *nin = NULL;
  npy_intp nin_Dims[1] = {-1};
  const int nin_Rank = 1;
  PyArrayObject *capi_nin_tmp = NULL;
  int capi_nin_intent = 0;
  PyObject *nin_capi = Py_None;
  double *b = NULL;
  npy_intp b_Dims[3] = {-1, -1, -1};
  const int b_Rank = 3;
  PyArrayObject *capi_b_tmp = NULL;
  int capi_b_intent = 0;
  static char *capi_kwlist[] = {"ni","ca","ia","nin",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO:_glmnet.lsolns",\
    capi_kwlist,&ni_capi,&ca_capi,&ia_capi,&nin_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable ni */
    f2py_success = int_from_pyobj(&ni,ni_capi,"_glmnet.lsolns() 1st argument (ni) can't be converted to int");
  if (f2py_success) {
  /* Processing variable ca */
  ;
  capi_ca_intent |= F2PY_INTENT_IN;
  capi_ca_tmp = array_from_pyobj(NPY_DOUBLE,ca_Dims,ca_Rank,capi_ca_intent,ca_capi);
  if (capi_ca_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 2nd argument `ca' of _glmnet.lsolns to C/Fortran array" );
  } else {
    ca = (double *)(PyArray_DATA(capi_ca_tmp));

  /* Processing variable nx */
  nx = shape(ca,0);
  /* Processing variable nc */
  nc = shape(ca,1);
  /* Processing variable lmu */
  lmu = shape(ca,2);
  /* Processing variable ia */
  ia_Dims[0]=nx;
  capi_ia_intent |= F2PY_INTENT_IN;
  capi_ia_tmp = array_from_pyobj(NPY_INT,ia_Dims,ia_Rank,capi_ia_intent,ia_capi);
  if (capi_ia_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 3rd argument `ia' of _glmnet.lsolns to C/Fortran array" );
  } else {
    ia = (int *)(PyArray_DATA(capi_ia_tmp));

  /* Processing variable nin */
  nin_Dims[0]=lmu;
  capi_nin_intent |= F2PY_INTENT_IN;
  capi_nin_tmp = array_from_pyobj(NPY_INT,nin_Dims,nin_Rank,capi_nin_intent,nin_capi);
  if (capi_nin_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting 4th argument `nin' of _glmnet.lsolns to C/Fortran array" );
  } else {
    nin = (int *)(PyArray_DATA(capi_nin_tmp));

  /* Processing variable b */
  b_Dims[0]=ni,b_Dims[1]=nc,b_Dims[2]=lmu;
  capi_b_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_b_tmp = array_from_pyobj(NPY_DOUBLE,b_Dims,b_Rank,capi_b_intent,Py_None);
  if (capi_b_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(_glmnet_error,"failed in converting hidden `b' of _glmnet.lsolns to C/Fortran array" );
  } else {
    b = (double *)(PyArray_DATA(capi_b_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
      Py_BEGIN_ALLOW_THREADS
        (*f2py_func)(&ni,&nx,&nc,&lmu,ca,ia,nin,b);
      Py_END_ALLOW_THREADS
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("N",capi_b_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_b_tmp == NULL) ... else of b*/
  /* End of cleaning variable b */
  if((PyObject *)capi_nin_tmp!=nin_capi) {
    Py_XDECREF(capi_nin_tmp); }
  }  /*if (capi_nin_tmp == NULL) ... else of nin*/
  /* End of cleaning variable nin */
  if((PyObject *)capi_ia_tmp!=ia_capi) {
    Py_XDECREF(capi_ia_tmp); }
  }  /*if (capi_ia_tmp == NULL) ... else of ia*/
  /* End of cleaning variable ia */
  /* End of cleaning variable lmu */
  /* End of cleaning variable nc */
  /* End of cleaning variable nx */
  if((PyObject *)capi_ca_tmp!=ca_capi) {
    Py_XDECREF(capi_ca_tmp); }
  }  /*if (capi_ca_tmp == NULL) ... else of ca*/
  /* End of cleaning variable ca */
  } /*if (f2py_success) of ni*/
  /* End of cleaning variable ni */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/******************************* end of lsolns *******************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/
/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"lognet",-1,{{-1}},0,(char *)F_FUNC(lognet,LOGNET),(f2py_init_func)f2py_rout__glmnet_lognet,doc_f2py_rout__glmnet_lognet},
  {"splognet",-1,{{-1}},0,(char *)F_FUNC(splognet,SPLOGNET),(f2py_init_func)f2py_rout__glmnet_splognet,doc_f2py_rout__glmnet_splognet},
  {"lsolns",-1,{{-1}},0,(char *)F_FUNC(lsolns,LSOLNS),(f2py_init_func)f2py_rout__glmnet_lsolns,doc_f2py_rout__glmnet_lsolns},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "_glmnet",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyMODINIT_FUNC PyInit__glmnet(void) {
#else
#define RETVAL
PyMODINIT_FUNC init_glmnet(void) {
#endif
  int i;
  PyObject *m,*d, *s, *tmp;
#if PY_VERSION_HEX >= 0x03000000
  m = _glmnet_module = PyModule_Create(&moduledef);
#else
  m = _glmnet_module = Py_InitModule("_glmnet", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module _glmnet (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module '_glmnet' is auto-generated with f2py (version:2).\nFunctions:\n"
"  lmu,a0,ca,ia,nin,dev0,dev,alm,nlp,jerr = lognet(parm,nc,x,y,g,jd,vp,cl,nx,flmin,ulam,thr,ne=min(shape(x,1), nx),nlam=len(ulam),isd=1,intr=1,maxit=100000,kopt=0)\n"
"  lmu,a0,ca,ia,nin,dev0,dev,alm,nlp,jerr = splognet(parm,no,ni,nc,x,ix,jx,y,g,jd,vp,cl,ne,nx,flmin,ulam,thr,nlam=len(ulam),isd=1,intr=1,maxit=100000,kopt=0)\n"
"  b = lsolns(ni,ca,ia,nin)\n"
".");
  PyDict_SetItemString(d, "__doc__", s);
  _glmnet_error = PyErr_NewException ("_glmnet.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }



/*eof initf2pywraphooks*/
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"_glmnet");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
