/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.table.TableDisplayLoadingMode;
import com.twosigma.beakerx.table.serializer.ObservableTableDisplaySerializer;
import com.twosigma.beakerx.table.serializer.TableSettings;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class TableDisplaySerializer
extends ObservableTableDisplaySerializer<TableDisplay> {
    private TableSettings settings;
    public static final String ALIGNMENT_FOR_COLUMN = "alignmentForColumn";
    public static final String ALIGNMENT_FOR_TYPE = "alignmentForType";
    public static final String COLUMNS_FROZEN = "columnsFrozen";
    public static final String COLUMN_ORDER = "columnOrder";
    public static final String COLUMNS_VISIBLE = "columnsVisible";
    public static final String DATA_FONT_SIZE = "dataFontSize";
    public static final String FONT_COLOR = "fontColor";
    public static final String HAS_INDEX = "hasIndex";
    public static final String HEADER_FONT_SIZE = "headerFontSize";
    public static final String HEADERS_VERTICAL = "headersVertical";
    public static final String RENDERER_FOR_COLUMN = "rendererForColumn";
    public static final String RENDERER_FOR_TYPE = "rendererForType";
    public static final String FILTERED_VALUES = "filteredValues";
    public static final String STRING_FORMAT_FOR_COLUMN = "stringFormatForColumn";
    public static final String STRING_FORMAT_FOR_TYPE = "stringFormatForType";
    public static final String TIME_ZONE = "timeZone";
    public static final String VALUES = "values";
    public static final String TYPE = "type";
    public static final String TABLE_DISPLAY = "TableDisplay";
    public static final String CELL_HIGHLIGHTERS = "cellHighlighters";
    public static final String TOOLTIPS = "tooltips";
    public static final String LOADING_MODE = "loadingMode";
    public static final String ROWS_TO_SHOW = "rowsToShow";
    public static final String AUTO_LINK_TABLE_LINKS = "auto_link_table_links";
    public static final String SHOW_PUBLICATION = "show_publication";

    public TableDisplaySerializer(TableSettings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(TableDisplay tableDisplay, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        TableDisplay tableDisplay2 = tableDisplay;
        synchronized (tableDisplay2) {
            jgen.writeStartObject();
            super.serialize(tableDisplay, jgen);
            jgen.writeObjectField(TYPE, (Object)TABLE_DISPLAY);
            jgen.writeObjectField("columnNames", tableDisplay.getColumnNames());
            jgen.writeObjectField("types", tableDisplay.getTypes());
            jgen.writeObjectField("subtype", (Object)tableDisplay.getSubtype());
            jgen.writeObjectField(STRING_FORMAT_FOR_TYPE, tableDisplay.getStringFormatForType());
            jgen.writeObjectField(STRING_FORMAT_FOR_COLUMN, tableDisplay.getStringFormatForColumn());
            jgen.writeObjectField(RENDERER_FOR_TYPE, tableDisplay.getRendererForType());
            jgen.writeObjectField(RENDERER_FOR_COLUMN, tableDisplay.getRendererForColumn());
            jgen.writeObjectField(ALIGNMENT_FOR_TYPE, tableDisplay.getAlignmentForType());
            jgen.writeObjectField(ALIGNMENT_FOR_COLUMN, tableDisplay.getAlignmentForColumn());
            jgen.writeObjectField(COLUMNS_FROZEN, tableDisplay.getColumnsFrozen());
            jgen.writeObjectField(COLUMNS_VISIBLE, tableDisplay.getColumnsVisible());
            jgen.writeObjectField(COLUMN_ORDER, tableDisplay.getColumnOrder());
            jgen.writeObjectField(CELL_HIGHLIGHTERS, tableDisplay.getCellHighlighters());
            jgen.writeObjectField(TOOLTIPS, tableDisplay.getTooltips());
            jgen.writeObjectField(DATA_FONT_SIZE, (Object)tableDisplay.getDataFontSize());
            jgen.writeObjectField(HEADER_FONT_SIZE, (Object)tableDisplay.getHeaderFontSize());
            jgen.writeObjectField(FONT_COLOR, tableDisplay.getFontColor().get());
            jgen.writeObjectField(ROWS_TO_SHOW, (Object)tableDisplay.getRowsToShow().getRows());
            if (tableDisplay.getFilteredValues() != null) {
                jgen.writeObjectField(FILTERED_VALUES, tableDisplay.getFilteredValues());
            }
            jgen.writeBooleanField(HEADERS_VERTICAL, tableDisplay.getHeadersVertical().booleanValue());
            jgen.writeObjectField(HAS_INDEX, (Object)tableDisplay.getHasIndex());
            jgen.writeObjectField(TIME_ZONE, (Object)tableDisplay.getTimeZone());
            jgen.writeObjectField(LOADING_MODE, (Object)TableDisplay.getLoadingMode());
            Map<String, Object> options = this.settings.options();
            for (String k : options.keySet()) {
                jgen.writeObjectField(k, options.get(k));
            }
            if (TableDisplay.getLoadingMode().equals((Object)TableDisplayLoadingMode.ALL)) {
                this.loadingAllMode(tableDisplay, jgen, tableDisplay.takeAllData());
            } else {
                this.loadingPageMode(jgen, tableDisplay.getValues());
            }
            jgen.writeEndObject();
        }
    }

    private void loadingPageMode(JsonGenerator jgen, List<List<?>> values) throws IOException {
        jgen.writeObjectField(VALUES, values);
    }

    private void loadingAllMode(TableDisplay tableDisplay, JsonGenerator jgen, List<List<?>> values) throws IOException {
        if (values.size() > tableDisplay.ROWS_LIMIT) {
            jgen.writeObjectField(VALUES, values.subList(0, tableDisplay.ROW_LIMIT_TO_INDEX));
            jgen.writeBooleanField("tooManyRows", true);
            jgen.writeObjectField("rowLength", (Object)values.size());
            jgen.writeObjectField("rowLimit", (Object)tableDisplay.ROWS_LIMIT);
            jgen.writeObjectField("rowLimitMsg", (Object)tableDisplay.getRowLimitMsg());
        } else {
            jgen.writeObjectField(VALUES, values);
            jgen.writeBooleanField("tooManyRows", false);
        }
    }
}

