/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.jvm.serialization.ObjectDeserializer;
import com.twosigma.beakerx.table.TableDisplay;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableDisplayDeSerializer
implements ObjectDeserializer {
    private static final Logger logger = LoggerFactory.getLogger((String)TableDisplayDeSerializer.class.getName());
    public static final String INDEX_NAME = "indexName";
    public static final String INDEX = "index";
    private final BeakerObjectConverter parent;

    public TableDisplayDeSerializer(BeakerObjectConverter p) {
        this.parent = p;
        this.parent.addKnownBeakerType("TableDisplay");
    }

    public static List<Map<String, Object>> getValuesAsRows(BeakerObjectConverter parent, JsonNode n, ObjectMapper mapper) throws IOException {
        List<List<?>> values = TableDisplayDeSerializer.getValues(parent, n, mapper);
        List<String> columns = TableDisplayDeSerializer.getColumns(n, mapper);
        return TableDisplay.getValuesAsRows(values, columns);
    }

    public static List<List<?>> getValuesAsMatrix(BeakerObjectConverter parent, JsonNode n, ObjectMapper mapper) throws IOException {
        List<List<?>> values = TableDisplayDeSerializer.getValues(parent, n, mapper);
        return TableDisplay.getValuesAsMatrix(values);
    }

    public static Map<String, Object> getValuesAsDictionary(BeakerObjectConverter parent, JsonNode n, ObjectMapper mapper) throws IOException {
        List<List<?>> values = TableDisplayDeSerializer.getValues(parent, n, mapper);
        return TableDisplay.getValuesAsDictionary(values);
    }

    public static List<List<?>> getValues(BeakerObjectConverter parent, JsonNode n, ObjectMapper mapper) throws IOException {
        ArrayList values = null;
        List classes = null;
        if (n.has("types")) {
            classes = (List)mapper.readValue(n.get("types").toString(), List.class);
        }
        if (n.has("values")) {
            JsonNode nn = n.get("values");
            values = new ArrayList();
            if (nn.isArray()) {
                for (JsonNode nno : nn) {
                    if (!nno.isArray()) continue;
                    ArrayList<Object> val = new ArrayList<Object>();
                    for (int i = 0; i < nno.size(); ++i) {
                        JsonNode nnoo = nno.get(i);
                        Object obj = parent.deserialize(nnoo, mapper);
                        val.add(TableDisplayDeSerializer.getValueForDeserializer(obj, classes != null && classes.size() > i ? (String)classes.get(i) : null));
                    }
                    values.add(val);
                }
            }
        }
        return values;
    }

    public static List<String> getColumns(JsonNode n, ObjectMapper mapper) throws IOException {
        List columns = null;
        if (n.has("columnNames")) {
            columns = (List)mapper.readValue(n.get("columnNames").toString(), List.class);
        }
        return columns;
    }

    public static List<String> getClasses(JsonNode n, ObjectMapper mapper) throws IOException {
        List classes = null;
        if (n.has("types")) {
            classes = (List)mapper.readValue(n.get("types").toString(), List.class);
        }
        return classes;
    }

    public static Object getValueForDeserializer(Object value, String clazz) {
        if (clazz != null) {
            if ("int64".equals(clazz)) {
                value = Long.parseLong(value.toString());
            } else if ("bigint".equals(clazz)) {
                value = new BigInteger(value.toString());
            }
        }
        return value;
    }

    public static Pair<String, Object> getDeserializeObject(BeakerObjectConverter parent, JsonNode n, ObjectMapper mapper) {
        Object o = null;
        String subtype = null;
        try {
            List<List<?>> values = TableDisplayDeSerializer.getValues(parent, n, mapper);
            List<String> columns = TableDisplayDeSerializer.getColumns(n, mapper);
            List<String> classes = TableDisplayDeSerializer.getClasses(n, mapper);
            if (n.has("subtype")) {
                subtype = (String)mapper.readValue(n.get("subtype").toString(), String.class);
            }
            if (subtype != null && subtype.equals("Dictionary")) {
                o = TableDisplayDeSerializer.getValuesAsDictionary(parent, n, mapper);
            } else if (subtype != null && subtype.equals("ListOfMaps") && columns != null && values != null) {
                o = TableDisplayDeSerializer.getValuesAsRows(parent, n, mapper);
            } else if (subtype != null && subtype.equals("Matrix")) {
                o = TableDisplayDeSerializer.getValuesAsMatrix(parent, n, mapper);
            }
            if (o == null) {
                o = n.has("hasIndex") && ((String)mapper.readValue(n.get("hasIndex").asText(), String.class)).equals("true") && columns != null && values != null && n.has(INDEX_NAME) ? TableDisplayDeSerializer.handleIndex(n, mapper, values, columns, classes) : new TableDisplay(values, columns, classes);
            }
        }
        catch (Exception e) {
            logger.error("exception deserializing TableDisplay ", (Throwable)e);
        }
        return new ImmutablePair(subtype, o);
    }

    @NotNull
    private static Object handleIndex(JsonNode n, ObjectMapper mapper, List<List<?>> values, List<String> columns, List<String> classes) throws IOException {
        boolean standardIndex;
        List indexName = (List)mapper.readValue(n.get(INDEX_NAME).toString(), List.class);
        boolean bl = standardIndex = indexName.size() == 1 && ((String)indexName.get(0)).equals(INDEX);
        if (standardIndex) {
            columns.remove(0);
            classes.remove(0);
            for (List<?> v : values) {
                v.remove(0);
            }
        } else {
            columns.set(0, String.join((CharSequence)", ", indexName.stream().map(TableDisplayDeSerializer::convertNullToIndexName).collect(Collectors.toList())));
        }
        TableDisplay td = new TableDisplay(values, columns, classes);
        if (!standardIndex) {
            td.setHasIndex("true");
        }
        return td;
    }

    private static String convertNullToIndexName(String x) {
        if (x == null) {
            return INDEX;
        }
        return x;
    }

    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        return TableDisplayDeSerializer.getDeserializeObject(this.parent, n, mapper).getRight();
    }

    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("TableDisplay");
    }
}

