/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.table;

import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.table.TableDisplay;
import com.twosigma.beakerx.table.TableDisplayModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Stream;

public class TableDisplayMapModel
extends TableDisplayModel {
    private Stream<Map<String, Object>> v;
    private Iterator<Map<String, Object>> valuesIterator;
    private BeakerObjectConverter serializer;
    private List<Map<String, Object>> initValues = new ArrayList<Map<String, Object>>();

    public TableDisplayMapModel(Stream<Map<String, Object>> v, BeakerObjectConverter serializer) {
        this.v = v;
        this.valuesIterator = v.iterator();
        this.serializer = serializer;
        this.values = new ArrayList();
        this.columns = new ArrayList();
        this.classes = new ArrayList();
        this.subtype = "ListOfMaps";
        this.initValues = this.nextValuesPage();
        this.createColumnNameAndType(this.initValues, serializer);
    }

    @Override
    public void initValues() {
        this.addToValues(this.buildValues(this.initValues));
        this.initValues = null;
    }

    private List<Map<String, Object>> allValues() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        while (this.valuesIterator.hasNext()) {
            list.add(this.valuesIterator.next());
        }
        return list;
    }

    @Override
    public List<List<?>> takeAllData() {
        List<List<?>> items = this.buildValues(this.allValues());
        this.addToValues(items);
        return this.values;
    }

    @Override
    public List<List<?>> takeNextPage() {
        List<List<?>> items = this.buildValues(this.nextValuesPage());
        this.addToValues(items);
        return items;
    }

    private void addToValues(List<List<?>> items) {
        this.values.addAll(items);
    }

    private List<List<?>> buildValues(List<Map<String, Object>> v) {
        ArrayList values = new ArrayList();
        for (Map<String, Object> m : v) {
            ArrayList<Object> vals = new ArrayList<Object>();
            for (String cn : this.columns) {
                if (m.containsKey(cn)) {
                    vals.add(this.getValueForSerializer(m.get(cn), this.serializer));
                    continue;
                }
                vals.add(null);
            }
            values.add(vals);
        }
        return values;
    }

    private List<Map<String, Object>> nextValuesPage(Iterator<Map<String, Object>> valuesIterator) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < TableDisplay.PAGE_SIZE && valuesIterator.hasNext(); ++i) {
            list.add(valuesIterator.next());
        }
        return list;
    }

    private List<Map<String, Object>> nextValuesPage() {
        return this.nextValuesPage(this.valuesIterator);
    }

    private void createColumnNameAndType(List<Map<String, Object>> values, BeakerObjectConverter serializer) {
        if (values.size() > 0) {
            ArrayList<String> columnOrder = new ArrayList<String>();
            ArrayList<String> columnsToCheck = new ArrayList<String>();
            LinkedHashMap<String, String> typeTracker = new LinkedHashMap<String, String>();
            Map<String, Object> firstRow = values.get(0);
            for (String columnName : firstRow.keySet()) {
                columnOrder.add(columnName);
                columnsToCheck.add(columnName);
                typeTracker.put(columnName, null);
            }
            ArrayList<String> columnsToRemove = new ArrayList<String>();
            for (Map<String, Object> row : values) {
                for (String columnToRemove : columnsToRemove) {
                    columnsToCheck.remove(columnToRemove);
                }
                columnsToRemove = new ArrayList();
                ListIterator columnCheckIterator = columnsToCheck.listIterator();
                while (columnCheckIterator.hasNext()) {
                    Object rowItem;
                    String columnToCheck = (String)columnCheckIterator.next();
                    String currentType = (String)typeTracker.get(columnToCheck);
                    if (currentType != null && currentType.equals("string") || (rowItem = row.get(columnToCheck)) == null) continue;
                    String colType = rowItem.getClass().getName();
                    String beakerColType = serializer.convertType(colType);
                    typeTracker.put(columnToCheck, beakerColType);
                    if (!beakerColType.equals("string")) continue;
                    columnsToRemove.add(columnToCheck);
                }
            }
            for (String columnName : columnOrder) {
                String columnType = (String)typeTracker.get(columnName);
                this.columns.add(columnName);
                this.classes.add(columnType);
            }
        }
    }
}

