/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality.kernelMagic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.NoSuchKernelException;
import com.twosigma.beakerx.kernel.PythonEntryPoint;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicKernelResponse;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KernelMagicCommand
implements MagicCommandFunctionality {
    public static final String KERNEL = "%%kernel";
    public static final String KERNEL_MAGIC_FORMAT_ERROR = "Wrong command format, should be %%kernel [kernel name]\n code";
    private KernelFunctionality kernel;

    public KernelMagicCommand(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        String iopubMsg;
        PythonEntryPoint pep;
        if (!this.validateCommandFormat(param)) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, this.getFormatErrorMessage(), MessageCreator.get());
        }
        String kernelName = this.getKernelName(param);
        try {
            pep = this.kernel.getPythonEntryPoint(kernelName);
        }
        catch (NoSuchKernelException e) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, String.format("Kernel %s is not available!", e.getMessage()), MessageCreator.get());
        }
        String codeBlock = param.getCommandCodeBlock();
        pep.evaluate(codeBlock);
        pep.getShellMsg();
        ArrayList<Message> messages = new ArrayList<Message>();
        while (!(iopubMsg = pep.getIopubMsg()).equals("null")) {
            try {
                Message msg = this.parseMessage(iopubMsg);
                messages.add(msg);
                String commId = (String)msg.getContent().get("comm_id");
                if (commId == null) continue;
                this.kernel.addCommIdManagerMapping(commId, kernelName);
            }
            catch (IOException e) {
                return new MagicKernelResponse(MagicCommandOutcomeItem.Status.ERROR, messages);
            }
        }
        return new MagicKernelResponse(MagicCommandOutcomeItem.Status.OK, messages);
    }

    protected String getKernelName(MagicCommandExecutionParam param) {
        return param.getCommand().split(" ")[1].trim();
    }

    protected String getFormatErrorMessage() {
        return KERNEL_MAGIC_FORMAT_ERROR;
    }

    protected boolean validateCommandFormat(MagicCommandExecutionParam param) {
        String[] magicArgs = param.getCommand().split(" ");
        return magicArgs.length == 2 && !param.getCommandCodeBlock().trim().isEmpty();
    }

    private Message parseMessage(String stringJson) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode json = mapper.readTree(stringJson);
        Message msg = new Message((Header)mapper.convertValue((Object)json.get("header"), Header.class));
        msg.setContent((Map)mapper.convertValue((Object)json.get("content"), Map.class));
        msg.setMetadata((Map)mapper.convertValue((Object)json.get("metadata"), Map.class));
        msg.setBuffers((List)mapper.convertValue((Object)json.get("buffers"), List.class));
        List identities = (List)mapper.convertValue((Object)json.get("comm_id"), List.class);
        msg.setIdentities(identities == null ? new ArrayList() : identities);
        return msg;
    }

    public String getMagicCommandName() {
        return KERNEL;
    }
}

