/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.MessageCreatorService;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.functionality.ClasspathMagicCommand;
import com.twosigma.beakerx.kernel.magic.command.functionality.MagicCommandUtils;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import java.util.Collection;

public class ClasspathAddDynamicMagicCommand
extends ClasspathMagicCommand {
    private static final String ADD = "add";
    private static final String DYNAMIC = "dynamic";
    public static final String CLASSPATH_ADD_DYNAMIC = "%classpath add dynamic";
    private EvaluationObjectFactory objectFactory;

    public ClasspathAddDynamicMagicCommand(KernelFunctionality kernel, MessageCreatorService messageCreatorService, EvaluationObjectFactory objectFactory) {
        super(kernel, messageCreatorService);
        this.objectFactory = objectFactory;
    }

    public String getMagicCommandName() {
        return CLASSPATH_ADD_DYNAMIC;
    }

    public boolean matchCommand(String command) {
        String[] commandParts = MagicCommandUtils.splitPath((String)command);
        return commandParts.length > 2 && commandParts[0].equals("%classpath") && commandParts[1].equals(ADD) && commandParts[2].equals(DYNAMIC);
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        EvaluationObject seo;
        String command = param.getCommand();
        String[] split = MagicCommandUtils.splitPath((String)command);
        if (split.length < 4) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "Wrong format. %classpath add dynamic", MessageCreator.get());
        }
        String codeToExecute = command.substring(command.indexOf(DYNAMIC) + DYNAMIC.length()).trim();
        TryResult either = this.kernel.executeCode(codeToExecute, seo = this.objectFactory.createSeo(codeToExecute, this.kernel, param.getCode().getMessage(), param.getExecutionCount()));
        if (either.isResult()) {
            try {
                return this.addJars(either.result());
            }
            catch (Exception e) {
                return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %classpath add dynamic : " + e.getMessage(), MessageCreator.get());
            }
        }
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, "There occurs problem during execution of %classpath add dynamic : " + either.error(), MessageCreator.get());
    }

    private MagicCommandOutcomeItem addJars(Object path) {
        if (path instanceof String) {
            return this.handleAddedJars((String)path);
        }
        if (path instanceof Collection) {
            return this.handleAddedJars((Collection)path);
        }
        throw new RuntimeException("Classpath dynamic handles String or Collection.");
    }
}

