/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.handler;

import com.twosigma.beakerx.handler.KernelHandler;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.msg.JupyterMessages;
import com.twosigma.beakerx.message.Header;
import com.twosigma.beakerx.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterruptMsgHandler
extends KernelHandler<Message> {
    private static final Logger logger = LoggerFactory.getLogger(InterruptMsgHandler.class);

    public InterruptMsgHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public void handle(Message message) {
        Message interruptReply = InterruptMsgHandler.createInterruptReply(JupyterMessages.INTERRUPT_REPLY, message);
        this.kernel.send(interruptReply);
        this.kernel.interruptKernel();
        this.kernel.interruptKernelDone();
        logger.info("Interrupting done");
    }

    private static Message createInterruptReply(JupyterMessages type, Message message) {
        Message reply = new Message(new Header(type, message.getHeader().getSession()));
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        return reply;
    }
}

