/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.comm;

import com.twosigma.beakerx.handler.KernelHandlerWrapper;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.comm.BaseHandler;
import com.twosigma.beakerx.message.Message;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlCommandListHandler
extends BaseHandler<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(KernelControlCommandListHandler.class);
    public static final String GET_KERNEL_CONTROL_COMMAND_LIST = "get_kernel_control_command_list";
    public static final String KERNEL_CONTROL_RESPONSE = "kernel_control_response";

    public KernelControlCommandListHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    public void handle(Message message) {
        KernelHandlerWrapper.wrapBusyIdle((KernelFunctionality)this.kernel, (Message)message, () -> this.handleMsg(message));
    }

    private void handleMsg(Message message) {
        logger.debug("Handing comm message content");
        Boolean value = (Boolean)this.getValueFromData(message, this.getHandlerCommand());
        if (value != null && value.booleanValue()) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put(KERNEL_CONTROL_RESPONSE, this.getCommKernelControlCommandList());
            this.publish(this.createReplyMessage(message, data));
        }
    }

    protected String[] getCommKernelControlCommandList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(GET_KERNEL_CONTROL_COMMAND_LIST);
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    public String getHandlerCommand() {
        return GET_KERNEL_CONTROL_COMMAND_LIST;
    }
}

