/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.jvm.object;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beakerx.util.SerializerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class BeakerDashboard
extends Observable {
    private String theStyle;
    private String theClass;
    public final List<dashRow> content = new ArrayList<dashRow>();

    public String getTheStyle() {
        return this.theStyle;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheStyle(String s) {
        this.theStyle = s;
    }

    public void setTheClass(String s) {
        this.theClass = s;
    }

    public List<dashRow> getRows() {
        return this.content;
    }

    public void addRow(dashRow o) {
        this.content.add(o);
    }

    public dashRow newRow() {
        return new dashRow();
    }

    public dashColumn newColumn(int w) {
        return new dashColumn(w);
    }

    public void clear() {
        this.content.clear();
    }

    public void redraw() {
        this.setChanged();
        this.notifyObservers();
    }

    public static class Serializer
    extends JsonSerializer<BeakerDashboard> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(BeakerDashboard value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            BeakerDashboard beakerDashboard = value;
            synchronized (beakerDashboard) {
                jgen.writeStartObject();
                jgen.writeObjectField("update_time", (Object)System.currentTimeMillis());
                jgen.writeObjectField("type", (Object)SerializerUtil.getTypeName(value));
                if (value.getTheStyle() != null) {
                    jgen.writeStringField("thestyle", value.getTheStyle());
                }
                if (value.getTheClass() != null) {
                    jgen.writeStringField("theclass", value.getTheClass());
                }
                jgen.writeArrayFieldStart("rows");
                jgen.writeEndArray();
                jgen.writeEndObject();
            }
        }
    }

    public class dashColumn {
        private final List<Object> payload = new ArrayList<Object>();
        private String theClass;
        private String theStyle;
        private int w;

        protected dashColumn(int _w) {
            this.w = _w;
        }

        public void serialize(JsonGenerator jgen, BeakerObjectConverter boc) throws JsonGenerationException, IOException {
            jgen.writeStartObject();
            jgen.writeNumberField("width", this.w);
            if (this.theStyle != null) {
                jgen.writeStringField("thestyle", this.theStyle);
            }
            if (this.theClass != null) {
                jgen.writeStringField("theclass", this.theClass);
            }
            jgen.writeArrayFieldStart("payload");
            for (Object o : this.payload) {
                if (o instanceof dashRow) {
                    ((dashRow)o).serialize(jgen, boc);
                    continue;
                }
                if (boc.writeObject(o, jgen, true)) continue;
                jgen.writeObject((Object)o.toString());
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }

        public List<Object> getPayload() {
            return this.payload;
        }

        public String getTheClass() {
            return this.theClass;
        }

        public void setTheClass(String c) {
            this.theClass = c;
        }

        public String getTheStyle() {
            return this.theStyle;
        }

        public void setTheStyle(String s) {
            this.theStyle = s;
        }

        public int getWidth() {
            return this.w;
        }

        public void setWidth(int _w) {
            this.w = _w;
        }

        public void addItem(Object o) throws Exception {
            if (o instanceof dashColumn) {
                throw new Exception("ERROR: cannot add a column inside a column");
            }
            this.payload.add(o);
        }
    }

    public class dashRow {
        private final List<dashColumn> payload = new ArrayList<dashColumn>();
        private String theClass;
        private String theStyle;

        protected dashRow() {
        }

        public List<dashColumn> getColumns() {
            return this.payload;
        }

        public String getTheClass() {
            return this.theClass;
        }

        public void setTheClass(String c) {
            this.theClass = c;
        }

        public String getTheStyle() {
            return this.theStyle;
        }

        public void setTheStyle(String s) {
            this.theStyle = s;
        }

        public void addColumn(dashColumn o) {
            this.payload.add(o);
        }

        public void serialize(JsonGenerator jgen, BeakerObjectConverter boc) throws JsonGenerationException, IOException {
            jgen.writeStartObject();
            if (this.theStyle != null) {
                jgen.writeStringField("thestyle", this.theStyle);
            }
            if (this.theClass != null) {
                jgen.writeStringField("theclass", this.theClass);
            }
            jgen.writeArrayFieldStart("cols");
            for (dashColumn r : this.payload) {
                r.serialize(jgen, boc);
            }
            jgen.writeEndArray();
            jgen.writeEndObject();
        }
    }
}

