/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.serializer.AbstractChartSerializer;
import com.twosigma.beakerx.chart.xychart.XYChart;
import java.io.IOException;

public class XYChartSerializer
extends AbstractChartSerializer<XYChart> {
    public static final String GRAPHICS_LIST = "graphics_list";
    public static final String LOD_THRESHOLD = "lodThreshold";
    public static final String X_AUTO_RANGE = "x_auto_range";
    public static final String X_LOWER_BOUND = "x_lower_bound";
    public static final String X_UPPER_BOUND = "x_upper_bound";
    public static final String LOG_X = "log_x";
    public static final String X_LOG_BASE = "x_log_base";
    public static final String X_TICK_LABELS_VISIBLE = "x_tickLabels_visible";
    public static final String Y_TICK_LABELS_VISIBLE = "y_tickLabels_visible";
    public static final String TEXTS = "texts";
    public static final String CONSTANT_BANDS = "constant_bands";
    public static final String CONSTANT_LINES = "constant_lines";
    public static final String RASTERS = "rasters";

    public void serialize(XYChart xychart, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        this.serialize(xychart, jgen);
        jgen.writeObjectField(GRAPHICS_LIST, xychart.getGraphics());
        jgen.writeObjectField(CONSTANT_LINES, xychart.getConstantLines());
        jgen.writeObjectField(CONSTANT_BANDS, xychart.getConstantBands());
        jgen.writeObjectField(RASTERS, xychart.getRasters());
        jgen.writeObjectField(TEXTS, xychart.getTexts());
        jgen.writeObjectField(X_AUTO_RANGE, (Object)xychart.getXAutoRange());
        jgen.writeObjectField(X_LOWER_BOUND, (Object)xychart.getXLowerBound());
        jgen.writeObjectField(X_UPPER_BOUND, (Object)xychart.getXUpperBound());
        jgen.writeObjectField(LOG_X, (Object)xychart.getLogX());
        jgen.writeObjectField(X_LOG_BASE, (Object)xychart.getXLogBase());
        if (xychart.getLodThreshold() != null) {
            jgen.writeObjectField(LOD_THRESHOLD, (Object)xychart.getLodThreshold());
        }
        jgen.writeObjectField(X_TICK_LABELS_VISIBLE, (Object)xychart.isxTickLabelsVisible());
        jgen.writeObjectField(Y_TICK_LABELS_VISIBLE, (Object)xychart.isyTickLabelsVisible());
        jgen.writeEndObject();
    }
}

