/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.twosigma.beakerx.chart.serializer.ObservableChartSerializer;
import com.twosigma.beakerx.chart.xychart.CombinedPlot;
import com.twosigma.beakerx.chart.xychart.XYChart;
import com.twosigma.beakerx.util.SerializerUtil;
import java.io.IOException;
import java.util.List;

public class CombinedPlotSerializer
extends ObservableChartSerializer<CombinedPlot> {
    public static final String X_LABEL = "x_label";

    public void serialize(CombinedPlot plot, JsonGenerator jgen, SerializerProvider sp) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        super.serialize(plot, jgen);
        jgen.writeObjectField("type", (Object)SerializerUtil.getTypeName(plot));
        jgen.writeObjectField("init_width", (Object)plot.getInitWidth());
        jgen.writeObjectField("init_height", (Object)plot.getInitHeight());
        jgen.writeObjectField("title", (Object)plot.getTitle());
        jgen.writeObjectField(X_LABEL, (Object)plot.getXLabel());
        List<XYChart> subplots = plot.getSubplots();
        if (!subplots.isEmpty()) {
            String plot_type = subplots.get(0).getClass().getSimpleName();
            if ("SimpleTimePlot".equals(plot_type)) {
                jgen.writeObjectField("plot_type", (Object)"TimePlot");
            } else {
                jgen.writeObjectField("plot_type", (Object)plot_type);
            }
        }
        jgen.writeObjectField("plots", subplots);
        jgen.writeObjectField("weights", plot.getWeights());
        jgen.writeObjectField("version", (Object)"groovy");
        jgen.writeObjectField("x_tickLabels_visible", (Object)plot.isxTickLabelsVisible());
        jgen.writeObjectField("y_tickLabels_visible", (Object)plot.isyTickLabelsVisible());
        jgen.writeObjectField("auto_zoom", (Object)plot.getAutoZoom());
        jgen.writeEndObject();
    }
}

