/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx;

import com.twosigma.beakerx.CodeCell;
import com.twosigma.beakerx.util.Images;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import jupyter.Displayer;
import jupyter.Displayers;

public class BeakerxDefaultDisplayers {
    public static void registerDefaults() {
        BeakerxDefaultDisplayers.registerCodeCellDisplayer();
        BeakerxDefaultDisplayers.registerImageDisplayer();
    }

    private static void registerCodeCellDisplayer() {
        Displayers.register(CodeCell.class, (Displayer)new Displayer<CodeCell>(){

            public Map<String, String> display(final CodeCell value) {
                return new HashMap<String, String>(){
                    {
                        StringBuilder sb = new StringBuilder("Cell Type:" + value.getCellType()).append(System.getProperty("line.separator"));
                        sb.append("Execution Count:").append(value.getExecutionCount()).append(System.getProperty("line.separator"));
                        sb.append("Metadata:").append(value.getMetadata()).append(System.getProperty("line.separator"));
                        sb.append("Source:").append(value.getSource());
                        this.put("text/plain", sb.toString());
                    }
                };
            }
        });
    }

    private static void registerImageDisplayer() {
        Displayers.register(RenderedImage.class, (Displayer)new Displayer<RenderedImage>(){

            public Map<String, String> display(final RenderedImage value) {
                return new HashMap<String, String>(){
                    {
                        try {
                            byte[] data = Images.encode(value);
                            String base64 = Base64.getEncoder().encodeToString(data);
                            this.put("image/png", base64);
                        }
                        catch (IOException exc) {
                            StringWriter sw = new StringWriter();
                            exc.printStackTrace(new PrintWriter(sw));
                            this.put("text/html", "<div><pre>" + sw.toString() + "</pre></div>");
                        }
                    }
                };
            }
        });
    }
}

