/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.groovy.autocomplete;

import com.twosigma.beakerx.kernel.Imports;
import groovy.lang.Binding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class GroovyReflectionCompletion {
    Binding binding;
    ClassLoader gcl;
    Imports imports;
    private BeanUtilsBean2 beanUtils = new BeanUtilsBean2();
    private Pattern indexedAccessPattern = Pattern.compile("(.*)\\[([0-9]{1,})\\]");
    static final Pattern CONSTRUCTOR_PATTERN = Pattern.compile("new ([A-Za-z0-9_]{1,})\\((\\s*[a-z0-9_A-Z]*:.*,\\s*){0,}\\s*([a-z0-9_A-Z]*)@@@\\s*\\)");
    public static final List<String> SUPPLEMENTARY_COLLECTION_COMPLETIONS = Arrays.asList("isEmpty()", "size()", "collectEntries { ", "collect { ", "find { ", "grep { ", "groupBy { ", "countBy { ");
    public static final List<String> STRING_COMPLETIONS = Arrays.asList("size()", "split(", "tokenize(", "matches(", "contains(");
    public static final List<String> IGNORE_METHODS = Arrays.asList("invokeMethod", "getMetaClass", "setMetaClass", "setProperty", "getProperty", "equals", "toString", "hashCode", "wait", "getClass", "notify", "notifyAll");

    public GroovyReflectionCompletion(Binding binding, ClassLoader classLoader, Imports imports) {
        this.binding = binding;
        this.gcl = classLoader;
        this.imports = imports;
    }

    public List<String> autocomplete(String text, int pos) {
        List<String> constructorResults = null;
        try {
            constructorResults = this.tryResolveConstructor(text, pos);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        List<String> expressionResults = null;
        try {
            expressionResults = this.autocompleteExpression(text, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> allResults = new ArrayList<String>();
        if (constructorResults != null) {
            allResults.addAll(constructorResults);
        }
        if (expressionResults != null) {
            allResults.addAll(expressionResults);
        }
        return allResults;
    }

    public List<String> autocompleteExpression(String text, int pos) {
        String bindingReference;
        Matcher m;
        String expr = this.resolveExpression(text, pos - 1);
        ArrayList<String> parts = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(expr, ".");
        while (tokenizer.hasMoreTokens()) {
            parts.add(tokenizer.nextToken());
        }
        if (text.endsWith(".")) {
            parts.add("");
        }
        if ((m = this.indexedAccessPattern.matcher(bindingReference = (String)parts.get(0))).matches()) {
            bindingReference = m.group(1);
        }
        if (this.binding.hasVariable(bindingReference) && (parts.size() > 1 || text.endsWith("."))) {
            return this.autocompleteFromObject(parts);
        }
        List<String> result = this.binding.getVariables().keySet().stream().filter(x -> x.startsWith(expr)).collect(Collectors.toList());
        return result;
    }

    private Class tryLoadClass(String className) {
        try {
            return this.gcl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public List<String> tryResolveConstructor(String text, int pos) throws ClassNotFoundException {
        ConstructorMatch match = this.tryMatchConstructor(text, pos);
        if (match == null) {
            return null;
        }
        return match.computeConstructorCompletions();
    }

    public ConstructorMatch tryMatchConstructor(String text, int pos) throws ClassNotFoundException {
        String matchText = text.substring(0, pos) + "@@@" + text.substring(pos);
        Matcher m = CONSTRUCTOR_PATTERN.matcher(matchText);
        if (m.find()) {
            String className = m.group(1);
            String propName = m.groupCount() > 1 ? m.group(m.groupCount()) : null;
            return new ConstructorMatch(text, pos, className, propName);
        }
        return null;
    }

    public String resolveExpression(String text, int pos) {
        int expressionEnd = this.findExpressionEnd(text, pos);
        int expressionStart = this.findExpressionStart(text, pos);
        if (expressionStart == expressionEnd) {
            return null;
        }
        String result = text.substring(expressionStart = Math.max(0, expressionStart), expressionEnd = Math.min(text.length(), expressionEnd)).trim();
        if (!Character.isJavaIdentifierPart(result.charAt(result.length() - 1))) {
            result = result.substring(0, result.length() - 1);
        }
        if (!Character.isJavaIdentifierPart(result.charAt(0))) {
            result = result.substring(1);
        }
        return result;
    }

    private int findExpressionStart(String text, int startPos) {
        int pos;
        ArrayList<Character> bracketStack = new ArrayList<Character>();
        for (pos = startPos; pos >= 0; --pos) {
            char c = text.charAt(pos);
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            if (c == ']') {
                bracketStack.add(Character.valueOf(c));
                continue;
            }
            if (c != '[' || bracketStack.isEmpty() || ((Character)bracketStack.get(bracketStack.size() - 1)).charValue() != ']') break;
            bracketStack.remove(bracketStack.size() - 1);
        }
        return pos;
    }

    private int findExpressionEnd(String text, int startPos) {
        char c;
        int pos;
        ArrayList<Character> bracketStack = new ArrayList<Character>();
        for (pos = startPos; pos < text.length() && (c = text.charAt(pos)) != '\n'; ++pos) {
            if (c == '.' || Character.isJavaIdentifierPart(c)) continue;
            if (c == ']') {
                bracketStack.add(Character.valueOf(c));
                continue;
            }
            if (c != '[' || bracketStack.isEmpty() || ((Character)bracketStack.get(bracketStack.size() - 1)).charValue() != ']') break;
            bracketStack.remove(bracketStack.size() - 1);
        }
        return pos;
    }

    List<String> autocompleteFromObject(List<String> parts) {
        List<String> lowPriorityCompletions = Arrays.asList("class", "metaClass");
        List<String> filteredCompletions = Arrays.asList("empty");
        List<String> iterableOnlyCompletions = Arrays.asList("join(");
        ArrayList<String> result = new ArrayList<String>();
        try {
            Object value;
            String bindingReference = parts.get(0);
            Matcher m = this.indexedAccessPattern.matcher(bindingReference);
            if (m.matches()) {
                List collValue = (List)this.binding.getVariable(m.group(1));
                value = collValue.get(Integer.parseInt(m.group(2)));
            } else {
                value = this.binding.getVariable(bindingReference);
            }
            for (int i = 1; i < parts.size() - 1; ++i) {
                String partExpr = parts.get(i);
                Matcher m2 = this.indexedAccessPattern.matcher(partExpr);
                value = m2.matches() ? PropertyUtils.getIndexedProperty((Object)value, (String)partExpr) : PropertyUtils.getSimpleProperty((Object)value, (String)partExpr);
                if (value != null) continue;
                return result;
            }
            String completionToken = parts.size() > 1 ? parts.get(parts.size() - 1) : "";
            List<String> properties = this.getObjectPropertyNames(value);
            ArrayList lowPri = new ArrayList();
            properties.forEach(key -> {
                if (key.startsWith(completionToken)) {
                    if (lowPriorityCompletions.contains(key)) {
                        lowPri.add(key);
                    } else {
                        result.add((String)key);
                    }
                }
            });
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                mapValue.keySet().stream().filter(k -> k.startsWith(completionToken)).forEach(k -> result.add((String)k));
            }
            if (value instanceof Iterable || value instanceof Map) {
                result.addAll(SUPPLEMENTARY_COLLECTION_COMPLETIONS);
                result.addAll(iterableOnlyCompletions);
            }
            if (value instanceof String) {
                result.addAll(STRING_COMPLETIONS);
            }
            result.removeIf(v -> !v.startsWith(completionToken));
            result.removeAll(filteredCompletions);
            result.addAll(this.getObjectMethodCompletions(value, completionToken));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List<String> getObjectPropertyNames(Object value) {
        return this.getClassPropertyNames(value.getClass());
    }

    private List<String> getClassMutablePropertyNames(Class clazz) {
        Stream<Method> methods = Stream.of(clazz.getMethods());
        List<String> properties = methods.filter(m -> m.getName().startsWith("set") && m.getName().length() > 3 && Character.isUpperCase(m.getName().charAt(3)) && Modifier.isPublic(m.getModifiers()) && m.getParameters().length == 1).map(m -> StringUtils.uncapitalize((String)m.getName().substring(3))).collect(Collectors.toList());
        return properties;
    }

    private List<String> getClassPropertyNames(Class clazz) {
        Stream<Method> methods = Stream.of(clazz.getMethods());
        List<String> properties = methods.filter(m -> m.getName().startsWith("get") && m.getName().length() > 3 && Character.isUpperCase(m.getName().charAt(3)) && Modifier.isPublic(m.getModifiers()) && m.getParameters().length == 0).map(m -> StringUtils.uncapitalize((String)m.getName().substring(3))).collect(Collectors.toList());
        return properties;
    }

    String formatMethod(Method m) {
        return m.getName() + "(" + Stream.of(m.getParameters()).map(x -> x.getType().getName().replaceAll("java.lang.", "").replaceAll("java.util.", "").replaceAll("groovy.lang.", "")).collect(Collectors.joining(",")) + ")";
    }

    boolean isNonPropertyMethod(Method m) {
        if (m.getName().startsWith("get") && m.getParameterCount() == 0) {
            return false;
        }
        return !m.getName().startsWith("set") || m.getParameterCount() != 1;
    }

    List<String> getObjectMethodCompletions(Object obj, String completionToken) {
        Class<?> c = obj.getClass();
        List<String> methodNames = Stream.of(c.getMethods()).filter(m -> this.isNonPropertyMethod((Method)m) && !IGNORE_METHODS.contains(m.getName())).filter(m -> m.getName().startsWith(completionToken)).map(m -> this.formatMethod((Method)m)).collect(Collectors.toList());
        return methodNames;
    }

    public class ConstructorMatch {
        String text;
        int pos;
        public String className;
        public String propName;

        public ConstructorMatch(String text, int pos, String className, String propName) {
            this.text = text;
            this.pos = pos;
            this.className = className;
            this.propName = propName;
        }

        public List<String> computeConstructorCompletions() throws ClassNotFoundException {
            Class clazz = this.findClassMatch();
            System.out.println("Loaded class " + clazz);
            ArrayList<String> result = new ArrayList<String>();
            GroovyReflectionCompletion.this.getClassMutablePropertyNames(clazz).forEach(prop -> {
                String completion = null;
                if (this.propName != null && !this.propName.isEmpty()) {
                    if (!prop.startsWith(this.propName)) {
                        return;
                    }
                    completion = this.text.substring(0, this.pos - this.propName.length()) + prop + ": ";
                } else {
                    completion = this.text.substring(0, this.pos) + prop + ": ";
                }
                result.add(completion);
            });
            return result;
        }

        private Class findClassMatch() throws ClassNotFoundException {
            String dotClassName = "." + this.className;
            ArrayList<String> classesToTry = new ArrayList<String>();
            classesToTry.add(this.className);
            GroovyReflectionCompletion.this.imports.getImportPaths().stream().filter(p -> !p.isStatic()).map(p -> p.path()).filter(path -> path.endsWith(".*") || path.endsWith(dotClassName)).map(path -> {
                if (path.endsWith(".*")) {
                    return path.substring(0, path.length() - 2) + dotClassName;
                }
                return path;
            }).forEach(classesToTry::add);
            Iterator i = classesToTry.iterator();
            String classToTry = (String)i.next();
            while (i.hasNext()) {
                Class clazz = GroovyReflectionCompletion.this.tryLoadClass(classToTry);
                if (clazz != null) {
                    return clazz;
                }
                classToTry = (String)i.next();
            }
            return null;
        }
    }
}

