/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.mimetype;

import com.twosigma.beakerx.util.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MIMEContainer {
    private static final int DEFAULT_IFRAME_WIDTH = 400;
    private static final int DEFAULT_IFRAME_HEIGHT = 300;
    public static final MIMEContainer HIDDEN = MIMEContainer.addMimeType("x-beakerx/empty");
    private MIME mime;
    private Object data = "";

    private MIMEContainer(MIME mime) {
        this.mime = mime;
    }

    public MIMEContainer(String mime, Object code) {
        this.mime = new MIME(mime);
        this.data = code;
    }

    public MIME getMime() {
        return this.mime;
    }

    public Object getData() {
        return this.data;
    }

    public static MIMEContainer JavaScript(Object data) {
        return MIMEContainer.addMimeType("application/javascript", data);
    }

    public static MIMEContainer HTML(Object data) {
        return MIMEContainer.addMimeType("text/html", data);
    }

    public static MIMEContainer Latex(Object data) {
        return MIMEContainer.addMimeType("text/latex", data);
    }

    public static MIMEContainer Text(Object data) {
        return MIMEContainer.addMimeType("text/plain", data);
    }

    public static MIMEContainer Markdown(Object data) {
        return MIMEContainer.addMimeType("text/markdown", data);
    }

    public static MIMEContainer Math(String data) {
        data = StringUtils.strip((String)data, (String)"$");
        return MIMEContainer.addMimeType("text/latex", "$$" + data + "$$");
    }

    public static MIMEContainer Javascript(Object data) {
        return MIMEContainer.addMimeType("application/javascript", data);
    }

    public static MIMEContainer IFrame(String src, Object width, int height) {
        String code = String.format("<iframe width = '%1$s' height= '%2$d' src = '%3$s' frameborder='0' allowfullscreen> </iframe>", width.toString(), height, src);
        return MIMEContainer.addMimeType("text/html", code);
    }

    private static MIMEContainer IFrame(String srcTemplate, String id, HashMap params) {
        Integer width = params.getOrDefault("width", 400);
        Integer height = Integer.parseInt(((Object)params.getOrDefault("height", 300)).toString());
        String src = String.format(srcTemplate, id, MIMEContainer.parseParams(params));
        return MIMEContainer.IFrame(src, width, height);
    }

    public static MIMEContainer VimeoVideo(String id, String ... params) {
        HashMap<String, Object> paramsAsMap = MIMEContainer.paramsToMap(params);
        return MIMEContainer.VimeoVideo(paramsAsMap, id);
    }

    public static MIMEContainer VimeoVideo(HashMap params, String id) {
        return MIMEContainer.IFrame("https://player.vimeo.com/video/%1$s", id, params);
    }

    public static MIMEContainer YoutubeVideo(String id, String ... params) {
        HashMap<String, Object> paramsAsMap = MIMEContainer.paramsToMap(params);
        return MIMEContainer.YoutubeVideo(paramsAsMap, id);
    }

    public static MIMEContainer YoutubeVideo(HashMap params, String id) {
        return MIMEContainer.IFrame("https://www.youtube.com/embed/%1$s%2$s", id, params);
    }

    public static MIMEContainer ScribdDocument(String id, String ... params) {
        HashMap<String, Object> paramsAsMap = MIMEContainer.paramsToMap(params);
        return MIMEContainer.ScribdDocument(paramsAsMap, id);
    }

    public static MIMEContainer ScribdDocument(HashMap params, String id) {
        return MIMEContainer.IFrame("https://www.scribd.com/embeds/%1$s/content%2$s", id, params);
    }

    public static MIMEContainer Video(String src) {
        String output = String.format("<video src='%1$s' controls> Your browser does not support the <data>video</data> element. </video>", src);
        return MIMEContainer.addMimeType("text/html", output);
    }

    private static MIMEContainer addMimeType(String mime) {
        return new MIMEContainer(new MIME(mime));
    }

    protected static MIMEContainer addMimeType(String mime, Object data) {
        return new MIMEContainer(mime, data.toString());
    }

    protected static boolean exists(String data) {
        File f = new File(data);
        return f.exists() && !f.isDirectory();
    }

    protected static boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected static byte[] getBytes(Object data) throws IOException {
        byte[] bytes;
        if (MIMEContainer.isValidURL(data.toString())) {
            bytes = ByteStreams.toByteArray(new URL(data.toString()).openStream());
        } else if (MIMEContainer.exists(data.toString())) {
            Path path = Paths.get(data.toString(), new String[0]);
            bytes = Files.readAllBytes(path);
        } else {
            throw new FileNotFoundException(data.toString() + " doesn't exist. ");
        }
        return bytes;
    }

    public String toString() {
        return this.getMime() + " CODE = " + this.getData();
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    private static HashMap<String, Object> paramsToMap(String ... params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        for (String param : params) {
            String[] parts = param.split("=");
            if (parts.length != 2) continue;
            paramsMap.put(parts[0], parts[1]);
        }
        return paramsMap;
    }

    private static String parseParams(HashMap paramsMap) {
        List<String> iframeParamKeys = Arrays.asList("width", "height", "id");
        StringBuilder sb = new StringBuilder();
        for (Object key : paramsMap.keySet()) {
            if (iframeParamKeys.contains(key)) continue;
            sb.append("&").append(key.toString()).append("=").append(paramsMap.get(key).toString());
        }
        String result = sb.toString().replaceFirst("&", "?");
        return result.length() > 0 ? result : "";
    }

    public static class MIME {
        public static final String TEXT_PLAIN = "text/plain";
        public static final String TEXT_HTML = "text/html";
        public static final String TEXT_LATEX = "text/latex";
        public static final String TEXT_MARKDOWN = "text/markdown";
        public static final String APPLICATION_JAVASCRIPT = "application/javascript";
        public static final String IMAGE_PNG = "image/png";
        public static final String IMAGE_JPEG = "image/jpeg";
        public static final String IMAGE_SVG = "image/svg+xml";
        public static final String HIDDEN = "x-beakerx/empty";
        private String mime;

        public MIME(String mime) {
            this.mime = mime;
        }

        public String asString() {
            return this.mime;
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

