# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class ReportHistoryResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "organisation_id": "str",
        "end_date": "date",
        "reports": "list[ReportHistoryModel]",
    }

    attribute_map = {
        "organisation_id": "organisationId",
        "end_date": "endDate",
        "reports": "reports",
    }

    def __init__(self, organisation_id=None, end_date=None, reports=None):  # noqa: E501
        """ReportHistoryResponse - a model defined in OpenAPI"""  # noqa: E501

        self._organisation_id = None
        self._end_date = None
        self._reports = None
        self.discriminator = None

        if organisation_id is not None:
            self.organisation_id = organisation_id
        if end_date is not None:
            self.end_date = end_date
        if reports is not None:
            self.reports = reports

    @property
    def organisation_id(self):
        """Gets the organisation_id of this ReportHistoryResponse.  # noqa: E501

        The requested Organisation to which the data pertains  # noqa: E501

        :return: The organisation_id of this ReportHistoryResponse.  # noqa: E501
        :rtype: str
        """
        return self._organisation_id

    @organisation_id.setter
    def organisation_id(self, organisation_id):
        """Sets the organisation_id of this ReportHistoryResponse.

        The requested Organisation to which the data pertains  # noqa: E501

        :param organisation_id: The organisation_id of this ReportHistoryResponse.  # noqa: E501
        :type: str
        """

        self._organisation_id = organisation_id

    @property
    def end_date(self):
        """Gets the end_date of this ReportHistoryResponse.  # noqa: E501

        The end date of the report  # noqa: E501

        :return: The end_date of this ReportHistoryResponse.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this ReportHistoryResponse.

        The end date of the report  # noqa: E501

        :param end_date: The end_date of this ReportHistoryResponse.  # noqa: E501
        :type: date
        """

        self._end_date = end_date

    @property
    def reports(self):
        """Gets the reports of this ReportHistoryResponse.  # noqa: E501


        :return: The reports of this ReportHistoryResponse.  # noqa: E501
        :rtype: list[ReportHistoryModel]
        """
        return self._reports

    @reports.setter
    def reports(self, reports):
        """Sets the reports of this ReportHistoryResponse.


        :param reports: The reports of this ReportHistoryResponse.  # noqa: E501
        :type: list[ReportHistoryModel]
        """

        self._reports = reports
