# coding: utf-8

"""
    DocuSign Rooms API - v2

    An API for an integrator to access the features of DocuSign Rooms  # noqa: E501

    OpenAPI spec version: v2
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class FormLibrariesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_form_libraries(self, account_id, **kwargs):
        """
        Gets a paged list of forms libraries.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_libraries(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Default value is 100 and max value is 100
        :param int start_position: Default value is 0
        :return: FormLibrarySummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_form_libraries_with_http_info(account_id, **kwargs)
        else:
            (data) = self.get_form_libraries_with_http_info(account_id, **kwargs)
            return data

    def get_form_libraries_with_http_info(self, account_id, **kwargs):
        """
        Gets a paged list of forms libraries.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_libraries_with_http_info(account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str account_id: (required)
        :param int count: Default value is 100 and max value is 100
        :param int start_position: Default value is 0
        :return: FormLibrarySummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'count', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_libraries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_form_libraries`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_libraries'.replace('{format}', 'json')
        path_params = {}
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormLibrarySummaryList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_form_library_forms(self, form_library_id, account_id, **kwargs):
        """
        Gets a paged list of forms in a forms library.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_library_forms(form_library_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_library_id: Library Id (required)
        :param str account_id: (required)
        :param int count: Default value is 100 and max value is 100
        :param int start_position: Default value is 0
        :return: FormSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_form_library_forms_with_http_info(form_library_id, account_id, **kwargs)
        else:
            (data) = self.get_form_library_forms_with_http_info(form_library_id, account_id, **kwargs)
            return data

    def get_form_library_forms_with_http_info(self, form_library_id, account_id, **kwargs):
        """
        Gets a paged list of forms in a forms library.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_form_library_forms_with_http_info(form_library_id, account_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_library_id: Library Id (required)
        :param str account_id: (required)
        :param int count: Default value is 100 and max value is 100
        :param int start_position: Default value is 0
        :return: FormSummaryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_library_id', 'account_id', 'count', 'start_position']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_form_library_forms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'form_library_id' is set
        if ('form_library_id' not in params) or (params['form_library_id'] is None):
            raise ValueError("Missing the required parameter `form_library_id` when calling `get_form_library_forms`")
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params) or (params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_form_library_forms`")


        collection_formats = {}

        resource_path = '/v2/accounts/{accountId}/form_libraries/{formLibraryId}/forms'.replace('{format}', 'json')
        path_params = {}
        if 'form_library_id' in params:
            path_params['formLibraryId'] = params['form_library_id']
        if 'account_id' in params:
            path_params['accountId'] = params['account_id']

        query_params = {}
        if 'count' in params:
            query_params['count'] = params['count']
        if 'start_position' in params:
            query_params['startPosition'] = params['start_position']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['text/plain', 'application/json', 'text/json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='FormSummaryList',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
