# Generated by Django 2.2.27 on 2022-12-20 10:37

from django.db import migrations, models
import django.db.models.deletion
import djangocms_mapycz_markers.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='MapPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_mapycz_markers_mapplugin', serialize=False, to='cms.CMSPlugin')),
                ('map_latitude', models.FloatField(default=49.64, verbose_name='Map Longitude')),
                ('map_longitude', models.FloatField(default=15.2, verbose_name='Map Latitude')),
                ('map_zoom', models.IntegerField(default=7, verbose_name='Map Zoom')),
                ('map_width', models.CharField(blank=True, help_text='For example 100%', max_length=255, null=True, verbose_name='Map width')),
                ('map_height', models.CharField(blank=True, help_text='For example 400px', max_length=255, null=True, verbose_name='Map height')),
                ('controls', models.BooleanField(default=True, help_text='Display map controls - zoom, map slider.', verbose_name='Map controls')),
                ('no_zoom', models.BooleanField(default=False, help_text='Disable scrolling zoom by mouse wheel.', verbose_name='No zoom')),
                ('clusterer', models.BooleanField(default=True, help_text='Enable Clusterer for display cluster of markers.', verbose_name='Clusterer')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='MarkerPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_mapycz_markers_markerplugin', serialize=False, to='cms.CMSPlugin')),
                ('address', models.CharField(blank=True, help_text='Street and number, city.', max_length=255, null=True, verbose_name='Address')),
                ('latitude', models.CharField(help_text='Geographical latitude.', max_length=255, verbose_name='Latitude')),
                ('longitude', models.CharField(help_text='Geographical longitude.', max_length=255, verbose_name='Longitude')),
                ('title', models.CharField(blank=True, help_text='Name of marker.', max_length=255, null=True, verbose_name='Title')),
                ('img_path', models.CharField(blank=True, help_text='URL to the icon image or simply one of [red, yellow, blue].', max_length=255, null=True, verbose_name='Icon')),
                ('img_styles', models.CharField(blank=True, help_text='Icon styles in JSON. Example: {"position": "absolute", "left": 0, "top": "2px", "textAlign": "center", "width": "22px", "color": "white", "fontWeight": "bold"}', max_length=255, null=True, validators=[djangocms_mapycz_markers.models.validate_json], verbose_name='Image styles')),
                ('img_text', models.CharField(blank=True, help_text='Icon text.', max_length=50, null=True, verbose_name='Icon text')),
                ('card_width', models.IntegerField(blank=True, null=True, verbose_name='Card width')),
                ('card_heigth', models.IntegerField(blank=True, null=True, verbose_name='Card heigth')),
                ('card_header', models.CharField(blank=True, max_length=255, null=True, verbose_name='Card header')),
                ('card_body', models.TextField(blank=True, null=True, verbose_name='Card nody')),
                ('card_footer', models.CharField(blank=True, max_length=255, null=True, verbose_name='Card footer')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ConnectorPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='djangocms_mapycz_markers_connectorplugin', serialize=False, to='cms.CMSPlugin')),
                ('address', models.CharField(help_text='Element name for Street and number, city.', max_length=255, verbose_name='Address')),
                ('latitude', models.CharField(blank=True, help_text='Element name for geographical latitude.', max_length=255, null=True, verbose_name='Latitude')),
                ('longitude', models.CharField(blank=True, help_text='Element name for geographical longitude.', max_length=255, null=True, verbose_name='Longitude')),
                ('title', models.CharField(blank=True, help_text='Element name for icon title.', max_length=255, null=True, verbose_name='Icon title')),
                ('card_header', models.CharField(blank=True, help_text='Element name for Card header.', max_length=255, null=True, verbose_name='Card header')),
                ('card_body', models.CharField(blank=True, help_text='Element names for Card body.', max_length=255, null=True, verbose_name='Card body')),
                ('card_footer', models.CharField(blank=True, help_text='Element name for Card footer.', max_length=255, null=True, verbose_name='Card footer')),
                ('map', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='djangocms_mapycz_markers.MapPlugin')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
