/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.core.io.FileInputState;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.IOSetting;

public class IteratingFileReader
implements IIteratingChemObjectReader {
    protected IIteratingChemObjectReader reader;
    protected String filename = "";

    public IteratingFileReader(File file) throws AmbitIOException {
    }

    public IteratingFileReader(File file, IChemFormat iChemFormat) throws AmbitIOException {
        try {
            this.reader = FileInputState.getReader(new FileInputStream(file), file.getName(), iChemFormat);
            this.filename = file.getName();
        }
        catch (Exception exception) {
            throw new AmbitIOException(this.getClass().getName(), (Throwable)exception, file.getName());
        }
    }

    public boolean accepts(Class clazz) {
        return this.reader.accepts(clazz);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public IOSetting[] getIOSettings() {
        return this.reader.getIOSettings();
    }

    public void addChemObjectIOListener(IChemObjectIOListener iChemObjectIOListener) {
        this.reader.addChemObjectIOListener(iChemObjectIOListener);
    }

    public void removeChemObjectIOListener(IChemObjectIOListener iChemObjectIOListener) {
        this.reader.removeChemObjectIOListener(iChemObjectIOListener);
    }

    public void remove() {
        this.reader.remove();
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    public Object next() {
        return this.reader.next();
    }

    public String toString() {
        return "Reading compounds from " + this.filename;
    }

    public IResourceFormat getFormat() {
        return this.reader.getFormat();
    }

    public void setErrorHandler(IChemObjectReaderErrorHandler iChemObjectReaderErrorHandler) {
        if (this.reader != null) {
            this.reader.setErrorHandler(iChemObjectReaderErrorHandler);
        }
    }

    public void handleError(String string) throws CDKException {
        if (this.reader != null) {
            this.reader.handleError(string);
        }
    }

    public void handleError(String string, Exception exception) throws CDKException {
        if (this.reader != null) {
            this.reader.handleError(string, exception);
        }
    }

    public void handleError(String string, int n, int n2, int n3) throws CDKException {
        if (this.reader != null) {
            this.reader.handleError(string, n, n2, n3);
        }
    }

    public void handleError(String string, int n, int n2, int n3, Exception exception) throws CDKException {
        if (this.reader != null) {
            this.reader.handleError(string, n, n2, n3, exception);
        }
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public void setReader(InputStream inputStream) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public void setReaderMode(IChemObjectReader.Mode mode) {
        if (this.reader != null) {
            this.reader.setReaderMode(mode);
        }
    }
}

