/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.Iterator;
import java.util.List;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.PaDELStandardize;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.qsar.AtomValenceTool;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.SSSRFinder;

public class ExtendedTopochemicalAtomDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"ETA_Alpha", "ETA_AlphaP", "ETA_dAlpha_A", "ETA_dAlpha_B", "ETA_Epsilon_1", "ETA_Epsilon_2", "ETA_Epsilon_3", "ETA_Epsilon_4", "ETA_Epsilon_5", "ETA_dEpsilon_A", "ETA_dEpsilon_B", "ETA_dEpsilon_C", "ETA_dEpsilon_D", "ETA_Psi_1", "ETA_dPsi_A", "ETA_dPsi_B", "ETA_Shape_P", "ETA_Shape_Y", "ETA_Shape_X", "ETA_Beta", "ETA_BetaP", "ETA_Beta_s", "ETA_BetaP_s", "ETA_Beta_ns", "ETA_BetaP_ns", "ETA_dBeta", "ETA_dBetaP", "ETA_Beta_ns_d", "ETA_BetaP_ns_d", "ETA_Eta", "ETA_EtaP", "ETA_Eta_R", "ETA_Eta_F", "ETA_EtaP_F", "ETA_Eta_L", "ETA_EtaP_L", "ETA_Eta_R_L", "ETA_Eta_F_L", "ETA_EtaP_F_L", "ETA_Eta_B", "ETA_EtaP_B", "ETA_Eta_B_RC", "ETA_EtaP_B_RC"};
    private int decimalPlaces = 5;

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("ExtendedTopochemicalAtomDescriptor", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
        if (objectArray.length > 1) {
            throw new CDKException("ExtendedTopochemicalAtomDescriptor only expects one parameter");
        }
        if (!(objectArray[0] instanceof Integer)) {
            throw new CDKException("The parameter must be of type Integer");
        }
        this.decimalPlaces = (Integer)objectArray[0];
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        IChemObject iChemObject;
        Object object;
        IAtomContainer iAtomContainer2 = null;
        try {
            iAtomContainer2 = iAtomContainer.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PaDELStandardize.StandardizeNitro(iAtomContainer2);
        int n3 = iAtomContainer2.getAtomCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            object = iAtomContainer2.getAtom(i);
            int n4 = object.getAtomicNumber();
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
            dArray3[i] = 0.3;
            if (n4 == 1) continue;
            int n5 = n4;
            int n6 = AtomValenceTool.getValence((IAtom)object);
            int n7 = AtomConstants.period[n4];
            dArray[i] = this.Round((double)(n5 - n6) / (double)n6 * (1.0 / (double)(n7 - 1)), this.decimalPlaces);
            dArray2[i] = 0.5;
            dArray3[i] = this.Round(-dArray[i] + 0.3 * (double)AtomValenceTool.getValence((IAtom)object), this.decimalPlaces);
        }
        double[] dArray4 = new double[n3];
        object = new double[n3];
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            iChemObject = iAtomContainer2.getAtom(i);
            object[i] = 0.0;
            dArray5[i] = 0.0;
            dArray6[i] = 0.0;
            double d = 0.0;
            n2 = 0;
            double d2 = 0.0;
            n = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n8 = 1;
            boolean bl3 = false;
            List<IBond> list = iAtomContainer2.getConnectedBondsList((IAtom)iChemObject);
            for (IBond iBond : list) {
                IAtom iAtom = iBond.getConnectedAtom((IAtom)iChemObject);
                if (iAtom.getSymbol().equals("H")) continue;
                d += 0.5;
                int n9 = iAtomContainer2.getAtomNumber(iAtom);
                double d3 = Math.abs(dArray3[i] - dArray3[n9]);
                if (d3 <= 0.3) {
                    Object object2 = object;
                    int n4 = i;
                    object2[n4] = object2[n4] + 0.5;
                } else {
                    Object object3 = object;
                    int n5 = i;
                    object3[n5] = object3[n5] + 0.75;
                }
                if (iBond.getFlag(5)) {
                    n2 = 1;
                } else if (iBond.getOrder() == IBond.Order.SINGLE) {
                    if (n == 0) {
                        if (iAtom.getSymbol().equals("C")) {
                            List<IBond> list2 = iAtomContainer2.getConnectedBondsList(iAtom);
                            for (IBond iBond2 : list2) {
                                if (iBond2.getOrder() == IBond.Order.DOUBLE || iBond2.getFlag(5)) {
                                    bl = true;
                                } else {
                                    if (iBond2.getOrder() != IBond.Order.TRIPLE) continue;
                                    n8 = 2;
                                    bl = true;
                                }
                                break;
                            }
                        } else if ((double)(AtomValenceTool.getValence(iAtom) - iAtom.getFormalCharge()) - iAtomContainer2.getBondOrderSum(iAtom) >= 2.0) {
                            bl = true;
                        }
                        if (bl2 && bl) {
                            n = 1;
                        }
                    }
                } else if (iBond.getOrder() == IBond.Order.DOUBLE || iBond.getOrder() == IBond.Order.TRIPLE) {
                    int n12;
                    if (iBond.getOrder() == IBond.Order.DOUBLE) {
                        n12 = 1;
                    } else {
                        n12 = 2;
                        n8 = 2;
                    }
                    bl2 = true;
                    if (n == 0) {
                        if (bl) {
                            n = 1;
                        } else if (iAtom.getSymbol().equals("C")) {
                            List<IBond> list3 = iAtomContainer2.getConnectedBondsList(iAtom);
                            Iterator iterator = list3.iterator();
                            while (iterator.hasNext()) {
                                IBond iBond3 = (IBond)iterator.next();
                                if (iBond3.getOrder() != IBond.Order.SINGLE) continue;
                                IAtom iAtom2 = iBond3.getConnectedAtom(iAtom);
                                if (iAtom2.getSymbol().equals("C")) {
                                    List<IBond> list2 = iAtomContainer2.getConnectedBondsList(iAtom2);
                                    for (IBond iBond4 : list2) {
                                        if (iBond4.getOrder() == IBond.Order.DOUBLE || iBond4.getFlag(5)) {
                                            bl = true;
                                        } else {
                                            if (iBond4.getOrder() != IBond.Order.TRIPLE) continue;
                                            n8 = 2;
                                            bl = true;
                                        }
                                        break;
                                    }
                                } else if ((double)(AtomValenceTool.getValence(iAtom2) - iAtom2.getFormalCharge()) - iAtomContainer2.getBondOrderSum(iAtom2) >= 2.0) {
                                    bl = true;
                                }
                                if (!bl) continue;
                                n = 1;
                                break;
                            }
                        }
                    }
                    double d4 = 0.0;
                    d4 = d3 <= 0.3 ? (d4 += 1.0) : (d4 += 1.5);
                    d2 += d4 * (double)n12;
                }
                if (!((double)(AtomValenceTool.getValence((IAtom)iChemObject) - iChemObject.getFormalCharge()) - iAtomContainer2.getBondOrderSum((IAtom)iChemObject) >= 2.0) || iChemObject.getFlag(5) || iChemObject.getFlag(1) || !iAtom.getFlag(5) || !iAtom.getFlag(1)) continue;
                bl3 = true;
            }
            int n6 = i;
            dArray5[n6] = dArray5[n6] + ((n2 != 0 ? 2.0 : 0.0) + (n != 0 ? 1.5 * (double)n8 : d2) + (bl3 ? 0.5 : 0.0));
            dArray6[i] = bl3 ? 0.5 : 0.0;
            dArray4[i] = (double)(object[i] + dArray5[i]);
            dArray7[i] = this.Round(dArray[i] / dArray4[i], this.decimalPlaces);
            dArray8[i] = this.Round(dArray2[i] / d, this.decimalPlaces);
        }
        SSSRFinder sSSRFinder = new SSSRFinder(iAtomContainer2);
        iChemObject = sSSRFinder.findEssentialRings();
        int n14 = iChemObject.getAtomContainerCount();
        int n7 = 0;
        n2 = 0;
        int n16 = 0;
        int n8 = 0;
        n = 0;
        double d = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d2 = 0.0;
        double d10 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d9 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        int[][] nArray = TopologicalMatrix.getMatrix(iAtomContainer);
        for (int i = 0; i < n3; ++i) {
            IAtom iAtom = iAtomContainer2.getAtom(i);
            List<IAtom> list = iAtomContainer2.getConnectedAtomsList(iAtom);
            ++n7;
            ++n8;
            int n9 = iAtom.getAtomicNumber();
            if (n9 != 1) {
                ++n2;
                int d23 = 0;
                for (IAtom iAtom3 : list) {
                    if (iAtom3.getSymbol().equals("H")) continue;
                    ++d23;
                }
                if (d23 == 0) {
                    n16 += 5;
                    d8 += 1.9;
                } else if (d23 == 1) {
                    d3 += dArray[i];
                    n16 += 4;
                    d8 += 1.6;
                } else if (d23 == 2) {
                    n16 += 3;
                    d8 += 1.3;
                } else if (d23 == 3) {
                    d4 += dArray[i];
                    n16 += 2;
                    d8 += 1.0;
                } else if (d23 == 4) {
                    d9 += dArray[i];
                    ++n16;
                    d8 += 0.7;
                }
                d7 += dArray3[i];
                if (iAtom.getSymbol().equals("C")) {
                    int j = 0;
                    if (iAtom.getFlag(5)) {
                        ++j;
                    } else {
                        for (IAtom iAtom4 : list) {
                            if (!iAtom4.getSymbol().equals("C")) continue;
                            IBond iBond = iAtomContainer2.getBond(iAtom, iAtom4);
                            if (iBond.getOrder() == IBond.Order.DOUBLE) {
                                ++j;
                                continue;
                            }
                            if (iBond.getOrder() != IBond.Order.TRIPLE) continue;
                            j += 2;
                        }
                    }
                    n8 += j;
                    d2 += (double)j * 0.3;
                } else if (iAtom.getSymbol().equals("N")) {
                    int iAtom4 = 0;
                    if (iAtom.getFlag(5)) {
                        iAtom4 = 3 + iAtom.getFormalCharge() - (int)iAtomContainer2.getBondOrderSum(iAtom);
                    }
                    n8 += iAtom4;
                    d2 += (double)iAtom4 * 0.3;
                }
                d11 += object[i];
                d12 += dArray5[i];
                d13 += dArray6[i];
                for (int j = i + 1; j < n3; ++j) {
                    IAtom iAtom5 = iAtomContainer2.getAtom(j);
                    if (iAtom5.getSymbol().equals("H")) continue;
                    d14 += Math.pow(dArray7[i] * dArray7[j] / (double)(nArray[i][j] * nArray[i][j]), 0.5);
                    d15 += Math.pow(dArray8[i] * dArray8[j] / (double)(nArray[i][j] * nArray[i][j]), 0.5);
                    if (nArray[i][j] != 1) continue;
                    d16 += Math.pow(dArray7[i] * dArray7[j], 0.5);
                    d17 += Math.pow(dArray8[i] * dArray8[j], 0.5);
                }
            } else {
                for (IAtom iAtom6 : list) {
                    if (iAtom6.getSymbol().equals("C")) continue;
                    ++n;
                    d10 += dArray3[i];
                    break;
                }
            }
            d += dArray[i];
            d5 += dArray2[i];
            d6 += dArray3[i];
            d2 += dArray3[i];
        }
        d11 /= 2.0;
        d12 = (d12 - d13) / 2.0 + d13;
        double d18 = d;
        double d19 = d / (double)n2;
        double d20 = Math.max((d - d5) / (double)n2, 0.0);
        double d21 = Math.max((d5 - d) / (double)n2, 0.0);
        double d22 = d6 / (double)n7;
        double d23 = d7 / (double)n2;
        double d24 = d8 / (double)n16;
        double d25 = d2 / (double)n8;
        double d26 = (d7 + d10) / (double)(n2 + n);
        double d27 = d22 - d24;
        double d28 = d22 - d25;
        double d29 = d24 - d25;
        double d30 = d23 - d26;
        double d31 = d / d7;
        double d32 = this.Round(0.71429, this.decimalPlaces);
        double d33 = Math.max(d32 - d31, 0.0);
        double d34 = Math.max(d31 - d32, 0.0);
        double d35 = d3 / d18;
        double d36 = d4 / d18;
        double d37 = d9 / d18;
        double d38 = d11 + d12;
        double d39 = d38 / (double)n2;
        double d40 = d11;
        double d41 = d11 / (double)n2;
        double d42 = d12;
        double d43 = d12 / (double)n2;
        double d44 = d12 - d11;
        double d45 = d44 / (double)n2;
        double d46 = d13;
        double d47 = d46 / (double)n2;
        double d48 = d14;
        double d49 = d14 / (double)n2;
        double d50 = d15;
        double d51 = d15 - d14;
        double d52 = d51 / (double)n2;
        double d53 = d16;
        double d54 = d16 / (double)n2;
        double d55 = d17;
        double d56 = d17 - d16;
        double d57 = d56 / (double)n2;
        double d58 = n2 > 3 ? 1.414 + (double)(n2 - 3) * 0.5 - d17 : 0.0;
        double d59 = d58 / (double)n2;
        double d60 = d58 + 0.086 * (double)n14;
        double d61 = d60 / (double)n2;
        d18 = this.Round(d18, this.decimalPlaces);
        d19 = this.Round(d19, this.decimalPlaces);
        d20 = this.Round(d20, this.decimalPlaces);
        d21 = this.Round(d21, this.decimalPlaces);
        d22 = this.Round(d22, this.decimalPlaces);
        d23 = this.Round(d23, this.decimalPlaces);
        d24 = this.Round(d24, this.decimalPlaces);
        d25 = this.Round(d25, this.decimalPlaces);
        d26 = this.Round(d26, this.decimalPlaces);
        d27 = this.Round(d27, this.decimalPlaces);
        d28 = this.Round(d28, this.decimalPlaces);
        d29 = this.Round(d29, this.decimalPlaces);
        d30 = this.Round(d30, this.decimalPlaces);
        d31 = this.Round(d31, this.decimalPlaces);
        d33 = this.Round(d33, this.decimalPlaces);
        d34 = this.Round(d34, this.decimalPlaces);
        d35 = this.Round(d35, this.decimalPlaces);
        d36 = this.Round(d36, this.decimalPlaces);
        d37 = this.Round(d37, this.decimalPlaces);
        d38 = this.Round(d38, this.decimalPlaces);
        d39 = this.Round(d39, this.decimalPlaces);
        d40 = this.Round(d40, this.decimalPlaces);
        d41 = this.Round(d41, this.decimalPlaces);
        d42 = this.Round(d42, this.decimalPlaces);
        d43 = this.Round(d43, this.decimalPlaces);
        d44 = this.Round(d44, this.decimalPlaces);
        d45 = this.Round(d45, this.decimalPlaces);
        d46 = this.Round(d46, this.decimalPlaces);
        d47 = this.Round(d47, this.decimalPlaces);
        d48 = this.Round(d48, this.decimalPlaces);
        d49 = this.Round(d49, this.decimalPlaces);
        d50 = this.Round(d50, this.decimalPlaces);
        d51 = this.Round(d51, this.decimalPlaces);
        d52 = this.Round(d52, this.decimalPlaces);
        d53 = this.Round(d53, this.decimalPlaces);
        d54 = this.Round(d54, this.decimalPlaces);
        d55 = this.Round(d55, this.decimalPlaces);
        d56 = this.Round(d56, this.decimalPlaces);
        d57 = this.Round(d57, this.decimalPlaces);
        d58 = this.Round(d58, this.decimalPlaces);
        d59 = this.Round(d59, this.decimalPlaces);
        d60 = this.Round(d60, this.decimalPlaces);
        d61 = this.Round(d61, this.decimalPlaces);
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(d18);
        doubleArrayResult.add(d19);
        doubleArrayResult.add(d20);
        doubleArrayResult.add(d21);
        doubleArrayResult.add(d22);
        doubleArrayResult.add(d23);
        doubleArrayResult.add(d24);
        doubleArrayResult.add(d25);
        doubleArrayResult.add(d26);
        doubleArrayResult.add(d27);
        doubleArrayResult.add(d28);
        doubleArrayResult.add(d29);
        doubleArrayResult.add(d30);
        doubleArrayResult.add(d31);
        doubleArrayResult.add(d33);
        doubleArrayResult.add(d34);
        doubleArrayResult.add(d35);
        doubleArrayResult.add(d36);
        doubleArrayResult.add(d37);
        doubleArrayResult.add(d38);
        doubleArrayResult.add(d39);
        doubleArrayResult.add(d40);
        doubleArrayResult.add(d41);
        doubleArrayResult.add(d42);
        doubleArrayResult.add(d43);
        doubleArrayResult.add(d44);
        doubleArrayResult.add(d45);
        doubleArrayResult.add(d46);
        doubleArrayResult.add(d47);
        doubleArrayResult.add(d48);
        doubleArrayResult.add(d49);
        doubleArrayResult.add(d50);
        doubleArrayResult.add(d51);
        doubleArrayResult.add(d52);
        doubleArrayResult.add(d53);
        doubleArrayResult.add(d54);
        doubleArrayResult.add(d55);
        doubleArrayResult.add(d56);
        doubleArrayResult.add(d57);
        doubleArrayResult.add(d58);
        doubleArrayResult.add(d59);
        doubleArrayResult.add(d60);
        doubleArrayResult.add(d61);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }

    private double Round(double d, int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 *= 10;
        }
        if (d < 0.0) {
            return Math.ceil(d * (double)n2 - 0.5) / (double)n2;
        }
        return Math.floor(d * (double)n2 + 0.5) / (double)n2;
    }
}

