/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.regression;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRegressionObjects
extends ModelTestBase {
    protected Model m;
    protected Resource S;
    protected Property P;
    protected static int numberSubjects = 7;
    protected static int numberPredicates = 3;
    protected static final String subjectPrefix = "http://aldabaran/test6/s";
    protected static final String predicatePrefix = "http://aldabaran/test6/";

    public NewRegressionObjects(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(NewRegressionObjects.class);
    }

    protected Model getModel() {
        return ModelFactory.createDefaultModel();
    }

    public void setUp() {
        this.m = this.getModel();
        this.S = this.m.createResource("http://nowhere.man/subject");
        this.P = this.m.createProperty("http://nowhere.man/predicate");
    }

    public void tearDown() {
        this.m = null;
        this.S = null;
        this.P = null;
    }

    public void testListSubjects() {
        Set<Statement> statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList((Iterator)this.m.listSubjects());
        NewRegressionObjects.assertEquals((int)numberSubjects, (int)L.size());
        Set<Resource> wanted = this.subjectSet(numberSubjects);
        NewRegressionObjects.assertEquals(wanted, (Object)NewRegressionObjects.iteratorToSet(L.iterator()));
    }

    public void testListNamespaces() {
        Set<Statement> statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList((Iterator)this.m.listNameSpaces());
        NewRegressionObjects.assertEquals((int)numberPredicates, (int)L.size());
        Set<String> wanted = this.predicateSet(numberPredicates);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListStatements() {
        Set<Statement> statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList((Iterator)this.m.listStatements());
        NewRegressionObjects.assertEquals((int)statements.size(), (int)L.size());
        NewRegressionObjects.assertEquals(statements, new HashSet(L));
    }

    public void testListObjectsOfPropertyByProperty() {
        Set<Statement> statements = this.fill(this.m);
        List L = NewRegressionObjects.iteratorToList((Iterator)this.m.listObjectsOfProperty(NewRegressionObjects.property((String)"http://aldabaran/test6/0/p")));
        NewRegressionObjects.assertEquals((int)numberSubjects, (int)L.size());
        Set<Literal> wanted = this.literalsFor(0);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListObjectsOfPropertyBySubject() {
        int size = 10;
        Resource s = this.m.createResource();
        for (int i = 0; i < size; ++i) {
            this.m.addLiteral(s, RDF.value, i);
        }
        List L = NewRegressionObjects.iteratorToList((Iterator)this.m.listObjectsOfProperty(s, RDF.value));
        NewRegressionObjects.assertEquals((int)size, (int)L.size());
        Set<Literal> wanted = this.literalsUpto(size);
        NewRegressionObjects.assertEquals(wanted, new HashSet(L));
    }

    public void testListObjects() {
        this.fill(this.m);
        Set<Literal> wanted = this.literalsUpto(numberSubjects * numberPredicates);
        NewRegressionObjects.assertEquals(wanted, (Object)NewRegressionObjects.iteratorToSet((Iterator)this.m.listObjects()));
    }

    protected Set<Resource> subjectSet(int limit) {
        HashSet<Resource> result = new HashSet<Resource>();
        for (int i = 0; i < limit; ++i) {
            result.add(NewRegressionObjects.resource((String)(subjectPrefix + i)));
        }
        return result;
    }

    protected Set<String> predicateSet(int limit) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < limit; ++i) {
            result.add(predicatePrefix + i + "/");
        }
        return result;
    }

    protected Set<Literal> literalsUpto(int limit) {
        HashSet<Literal> result = new HashSet<Literal>();
        for (int i = 0; i < limit; ++i) {
            result.add(this.m.createTypedLiteral(i));
        }
        return result;
    }

    protected Set<Literal> literalsFor(int predicate) {
        HashSet<Literal> result = new HashSet<Literal>();
        for (int i = 0; i < numberSubjects; ++i) {
            result.add(this.m.createTypedLiteral(i * numberPredicates + predicate));
        }
        return result;
    }

    protected Set<Statement> fill(Model m) {
        HashSet<Statement> statements = new HashSet<Statement>();
        for (int i = 0; i < numberSubjects; ++i) {
            for (int j = 0; j < numberPredicates; ++j) {
                Statement s = m.createLiteralStatement(NewRegressionObjects.resource((String)(subjectPrefix + i)), NewRegressionObjects.property((String)(predicatePrefix + j + "/p")), i * numberPredicates + j);
                m.add(s);
                statements.add(s);
            }
        }
        NewRegressionObjects.assertEquals((long)(numberSubjects * numberPredicates), (long)m.size());
        return statements;
    }
}

