# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nepseutils']

package_data = \
{'': ['*']}

install_requires = \
['cryptography>=3.4.7,<4.0.0',
 'requests>=2.25.1,<3.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'tenacity>=7.0.0,<8.0.0']

setup_kwargs = {
    'name': 'nepseutils',
    'version': '0.3.3',
    'description': 'Collection of scripts to interact with NEPSE related websites!',
    'long_description': '# NEPSE Utils\nCollection of scripts to interact with NEPSE related sites.\n\n## Installation instruction\n\n### For Windows:\n* **Step 1:** Download Python installer from [here](http://python.org/downloads). Choose version greater than 3.9.\n* **Step 2:** Launch the installer, tick "Add Python 3.10 to PATH" on the first page and complete the installation.\n* **Step 3:** Search for command prompt and open it.\n* **Step 4:** Verify that you have python version greater than 3.9 by typing `python --version`\n* **Step 5:** Verify that you have pip installed by entering `pip --version`\n* **Step 6:** Install nepseutils by entering: `pip install nepseutils`\n* **Step 7:** Launch nepseutils by entering: `python -m nepseutils`\n\n### For Linux and Mac:\n* **Step 1:** Install Python (Version greater than 3.9) using your package manager.\n* **Step 2:** Pip might not come with python in some of the distros. To install it, you can use your package manager or enter the following command `curl https://bootstrap.pypa.io/get-pip.py | python`\n* **Step 3:** Verify that you have python version greater than 3.9 by typing `python --version`\n* **Step 4:** Verify that you have pip installed by entering `pip --version`\n* **Step 5:** Install nepseutils by entering: `pip install nepseutils`\n* **Step 6:** Launch nepseutils by entering: `python -m nepseutils`\n\n*Note: Some distros might default to python2 when both python2 and python3 are installed so you might need to enter python3 and pip3 instead of python and pip.*\n\n## Commands:\n|  Command       |  Description                 |\n|----------------|------------------------------|\n|`add`           | Add an account               |\n|`remove`        | Remove an account            |\n|`change lock`   | Change unlock password       |\n|`list accounts` | Show list of accounts        |\n|`list results`  | Show list of results         |\n|`azcaptcha init`| Add azcaptcha token          |\n|`apply`         | Apply open issues            |\n|`status`        | Check IPO application status |\n|`result`        | Check IPO result             |\n|`exit`          | Exit the shell               |\n\n## Usage\n\nYou can launch nepseutils by entering `python -m nepseutils` in your command line. On the first launch, it will ask you to set a new password for nepseutils (Not MeroShare). You will have to enter this next time you launch nepseutils.\n### Launching nepseutils:\n```\npython -m nepseutils\n```\n\n### Adding an account\n#### Command:\n```\nadd {16_digit_dmat_number} {meroshare_password} {crn} {meroshare_pin}\n```\n*You don\'t need to enter other infos. It will be automatically obtained.*\n#### Example:\n```\nNepseUtils > add 1234567891234567 myp@ssw0rd 02-R00222224 1234 \n```\n#### Sample Output:\n```\nSuccessfully obtained details for account: Ram Bahadur\n```\n\n### Applying for IPO\n#### Command:\n```\napply\n```\n\nThen you will see this kind of output:\n```\nNepseUtils > apply\n+----------+----------------+-------+------------+\n| Share ID | Company Name   | Scrip | Close Date |\n+----------+----------------+-------+------------+\n|   401    | Sample Company |  SMPL | 2021-01-01 |\n+----------+--------------+-------+--------------+\nEnter Share ID:\n```\nEnter share ID of company that you want to apply for.\n\n```\nEnter Share ID: 401\nUnits to Apply:\n```\nEnter number of units (Not rupees) that you want to apply. This will apply IPO for all the added accounts.\n\n### Checking IPO Result\n*Note: MeroShare has added a captcha for checking result. AZCaptcha token is needed for automatically solving captchas. Add token with `azcaptcha init`!*\n#### Command:\n```\nresult\n```\n#### Sample Output:\n```\nNepseUtils > result\n+----+------------+-------------------------------------------------+\n| ID |   Scrip    |                      Name                       |\n+----+------------+-------------------------------------------------+\n| 1  |   MLBSL    |     MAHILA LAGHUBITTA BITTIYA SANSTHA LTD.      |\n| 2  |    SBCF    |              Sunrise Bluechip Fund              |\n| 3  |    JLIC    |            Jyoti Life Insurance Ltd             |\n| 4  | NIBLSFUND  |             NIBL Samriddhi Fund -2              |\n| 5  |    CHDC    |     CEDB Hydropower Development Company Ltd     |\n| 6  |   PSFUND   |               Prabhu Select Fund                |\n| 7  | NMBD209293 |           4% NMB Energy Bond 2092/93            |\n| 8  | PRVUD2087  |            8.5 % PRVU Debenture 2087            |\n| 10 |   MKJCL    |     Mailung Khola Jal Vidhyut Company Ltd.      |\n| 11 |    SLIL    |          Sanima Life Insurance Limited          |\n| 12 | NABILD2085 |             8% Nabil Debenture 2085             |\n| 13 |   MALBSL   |   Manushi Laghubitta Bittiya Sanstha Limited    |\n| 14 |   MEGAMF   |               Mega Mutual Fund -1               |\n| 15 |    TPCL    |           Terhathum Power Company Ltd           |\n| 16 |  NMBSBFE   |            NMB Saral Bachat Fund - E            |\n| 17 |    NBF3    |              Nabil Balanced Fund 3              |\n| 18 |    SUL     |                 Sahas Urja Ltd.                 |\n| 19 |   BBNHCL   |     Buddhabhumi Nepal Hydro Power Co. Ltd.      |\n| 20 |   NYADI    |            Nyadi Hydropower Limited             |\n| 21 |   MBKJCL   |   Madhya Bhotekoshi Jalabidhyut Company Ltd.    |\n| 22 |    SPCL    |           Samling Power Company Ltd.            |\n| 23 |  CBLD2088  |            Civil Bank Debenture 2088            |\n| 24 |   JSLBS    | Jalpa Samudayik Laghubitta Bittiya Sanstha Ltd. |\n| 25 |    ENL     |             Emerging Nepal Limited              |\n+----+------------+-------------------------------------------------+\nChoose a company ID:\n```\n\nEnter ID of company that you want to check result for.\n\n```\nChoose a company ID: 21\n+----------------------------+---------+----------+\n|            Name            | Alloted | Quantity |\n+----------------------------+---------+----------+\n|       Ram  Bahadur         |  False  |   None   |\n|       Hari  Bahadur        |  True   |    10    |\n|       Shyam  Prasad        |  False  |   None   |\n+----------------------------+---------+----------+\n```\n\n\n### Removing account\n#### Command:\n```\nremove\n```\n#### Sample Output\n```\n+----+----------------------------+------------------+------------------+--------------+\n| ID |            Name            |       DMAT       |     Account      |     CRN      |\n+----+----------------------------+------------------+------------------+--------------+\n| 1  |       Ram  Bahadur         | 1201970008888888 | 0075757575757575 | 07-819284939 |\n| 2  |      Hari  Bahadur         | 1201970007878887 |  8758752835478   |  M52394589   |\n| 3  |      Shyam  Prasad         | 1201970002278282 | 5923459259243594 |  F59824935   |\n+----+----------------------------+------------------+------------------+--------------+\nChoose an account ID:\n```\nThen choose account to remove.\n\n### Show added accounts\n#### Command:\n```\nlist accounts\n```\n#### Sample Output\n```\n+----+----------------------------+------------------+------------------+--------------+\n| ID |            Name            |       DMAT       |     Account      |     CRN      |\n+----+----------------------------+------------------+------------------+--------------+\n| 1  |       Ram  Bahadur         | 1201970008888888 | 0075757575757575 | 07-819284939 |\n| 2  |      Hari  Bahadur         | 1201970007878887 |  8758752835478   |  M52394589   |\n| 3  |      Shyam  Prasad         | 1201970002278282 | 5923459259243594 |  F59824935   |\n+----+----------------------------+------------------+------------------+--------------+\n```\n',
    'author': 'Daze',
    'author_email': 'dazehere@yandex.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/arpandaze/nepseutils',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
