/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.condition;

public enum ConditionAction {
    NULL(0, false, ""),
    RELEVANT(1, true, "Make relevant"),
    NOT_RELEVANT(2, true, "Make not relevant"),
    ENABLE(3, false, "Enable"),
    READ_ONLY(4, false, "Make read-only"),
    LOCK(5, false, "Lock"),
    UNLOCK(6, false, "Unlock"),
    REQUIRE(7, false, "Require"),
    DONT_REQUIRE(8, false, "Make not required");

    private final int code;
    private final boolean cascading;
    private String verb;

    private ConditionAction(int code, boolean cascading, String verb) {
        this.code = code;
        this.cascading = cascading;
        this.verb = verb;
    }

    public static ConditionAction from(int code) {
        for (ConditionAction candidate : ConditionAction.values()) {
            if (candidate.code != code) continue;
            return candidate;
        }
        throw new RuntimeException("Unknown Condition action with code " + code);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isCascading() {
        return this.cascading;
    }

    public String getVerb() {
        return this.verb;
    }
}

