/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.SelectChoice;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.condition.IConditionExpr;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.model.util.restorable.RestoreUtils;
import org.javarosa.core.services.locale.Localizable;
import org.javarosa.core.services.locale.Localizer;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapNullable;
import org.javarosa.core.util.externalizable.ExtWrapTagged;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.model.xform.XPathReference;
import org.javarosa.xform.parse.RandomizeHelper;
import org.javarosa.xpath.XPathConditional;
import org.javarosa.xpath.expr.XPathFuncExpr;
import org.javarosa.xpath.expr.XPathNumericLiteral;
import org.javarosa.xpath.expr.XPathPathExpr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsetBinding
implements Externalizable,
Localizable {
    private static final Logger logger = LoggerFactory.getLogger(ItemsetBinding.class);
    public TreeReference nodesetRef;
    public IConditionExpr nodesetExpr;
    public TreeReference contextRef;
    public TreeReference labelRef;
    public IConditionExpr labelExpr;
    public boolean labelIsItext;
    public boolean copyMode;
    public IConditionExpr copyExpr;
    public TreeReference copyRef;
    public TreeReference valueRef;
    public IConditionExpr valueExpr;
    private TreeReference destRef;
    private List<SelectChoice> choices;
    public boolean randomize = false;
    public XPathNumericLiteral randomSeedNumericExpr = null;
    public XPathPathExpr randomSeedPathExpr = null;

    public List<SelectChoice> getChoices() {
        return this.choices;
    }

    private Long resolveRandomSeed(DataInstance model, EvaluationContext ec) {
        if (this.randomSeedNumericExpr != null) {
            return ((Double)this.randomSeedNumericExpr.eval(model, ec)).longValue();
        }
        if (this.randomSeedPathExpr != null) {
            return XPathFuncExpr.toNumeric(this.randomSeedPathExpr.eval(model, ec)).longValue();
        }
        return null;
    }

    public void setChoices(List<SelectChoice> choices, DataInstance model, EvaluationContext ec, Localizer localizer) {
        String curLocale;
        if (this.choices != null) {
            logger.warn("previous choices not cleared out");
            this.clearChoices();
        }
        List<SelectChoice> list = this.choices = this.randomize ? RandomizeHelper.shuffle(choices, this.resolveRandomSeed(model, ec)) : choices;
        if (this.randomize) {
            for (int i = 0; i < choices.size(); ++i) {
                choices.get(i).setIndex(i);
            }
        }
        if (localizer != null && (curLocale = localizer.getLocale()) != null) {
            this.localeChanged(curLocale, localizer);
        }
    }

    public void clearChoices() {
        this.choices = null;
    }

    @Override
    public void localeChanged(String locale, Localizer localizer) {
        if (this.choices != null) {
            for (int i = 0; i < this.choices.size(); ++i) {
                this.choices.get(i).localeChanged(locale, localizer);
            }
        }
    }

    public TreeReference getDestRef() {
        return this.destRef;
    }

    public IConditionExpr getRelativeValue() {
        TreeReference relRef = null;
        if (this.copyRef == null) {
            relRef = this.valueRef;
        } else if (this.valueRef != null) {
            relRef = this.valueRef.relativize(this.copyRef);
        }
        return relRef != null ? RestoreUtils.xfFact.refToPathExpr(relRef) : null;
    }

    public void initReferences(QuestionDef q) {
        this.nodesetRef = ItemsetBinding.getAbsoluteRef(this.nodesetExpr, this.contextRef);
        if (this.labelExpr != null) {
            this.labelRef = ItemsetBinding.getAbsoluteRef(this.labelExpr, this.nodesetRef);
        }
        if (this.copyExpr != null) {
            this.copyRef = ItemsetBinding.getAbsoluteRef(this.copyExpr, this.nodesetRef);
        }
        if (this.valueExpr != null) {
            this.valueRef = ItemsetBinding.getAbsoluteRef(this.valueExpr, this.nodesetRef);
        }
        if (q != null) {
            this.destRef = ((TreeReference)q.getBind().getReference()).clone();
            if (this.copyMode) {
                this.destRef.add(this.copyRef.getNameLast(), -1);
            }
        }
    }

    private static TreeReference getAbsoluteRef(IConditionExpr condExpr, TreeReference baseRef) {
        XPathPathExpr xPathPathExpr = (XPathPathExpr)((XPathConditional)condExpr).getExpr();
        IDataReference dataReference = FormDef.getAbsRef(new XPathReference(xPathPathExpr), baseRef);
        return (TreeReference)dataReference.getReference();
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException, DeserializationException {
        this.nodesetExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.contextRef = (TreeReference)ExtUtil.read(in, TreeReference.class, pf);
        this.labelExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapTagged(), pf);
        this.valueExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.copyExpr = (IConditionExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.labelIsItext = ExtUtil.readBool(in);
        this.copyMode = ExtUtil.readBool(in);
        this.randomize = ExtUtil.readBool(in);
        this.randomSeedNumericExpr = (XPathNumericLiteral)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
        this.randomSeedPathExpr = (XPathPathExpr)ExtUtil.read(in, new ExtWrapNullable(new ExtWrapTagged()), pf);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        ExtUtil.write(out, new ExtWrapTagged(this.nodesetExpr));
        ExtUtil.write(out, this.contextRef);
        ExtUtil.write(out, new ExtWrapTagged(this.labelExpr));
        ExtUtil.write(out, new ExtWrapNullable(this.valueExpr == null ? null : new ExtWrapTagged(this.valueExpr)));
        ExtUtil.write(out, new ExtWrapNullable(this.copyExpr == null ? null : new ExtWrapTagged(this.copyExpr)));
        ExtUtil.writeBool(out, this.labelIsItext);
        ExtUtil.writeBool(out, this.copyMode);
        ExtUtil.writeBool(out, this.randomize);
        ExtUtil.write(out, new ExtWrapNullable(this.randomSeedNumericExpr == null ? null : new ExtWrapTagged(this.randomSeedNumericExpr)));
        ExtUtil.write(out, new ExtWrapNullable(this.randomSeedPathExpr == null ? null : new ExtWrapTagged(this.randomSeedPathExpr)));
    }
}

