# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pulpcore.client.pulp_ansible.configuration import Configuration


class AnsibleCollectionVersion(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'upload': 'str',
        'file': 'file',
        'repository': 'str',
        'name': 'str',
        'namespace': 'str',
        'version': 'str'
    }

    attribute_map = {
        'upload': 'upload',
        'file': 'file',
        'repository': 'repository',
        'name': 'name',
        'namespace': 'namespace',
        'version': 'version'
    }

    def __init__(self, upload=None, file=None, repository=None, name=None, namespace=None, version=None, local_vars_configuration=None):  # noqa: E501
        """AnsibleCollectionVersion - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._upload = None
        self._file = None
        self._repository = None
        self._name = None
        self._namespace = None
        self._version = None
        self.discriminator = None

        if upload is not None:
            self.upload = upload
        if file is not None:
            self.file = file
        if repository is not None:
            self.repository = repository
        self.name = name
        self.namespace = namespace
        self.version = version

    @property
    def upload(self):
        """Gets the upload of this AnsibleCollectionVersion.  # noqa: E501

        An uncommitted upload that may be turned into the artifact of the content unit.  # noqa: E501

        :return: The upload of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._upload

    @upload.setter
    def upload(self, upload):
        """Sets the upload of this AnsibleCollectionVersion.

        An uncommitted upload that may be turned into the artifact of the content unit.  # noqa: E501

        :param upload: The upload of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """

        self._upload = upload

    @property
    def file(self):
        """Gets the file of this AnsibleCollectionVersion.  # noqa: E501

        An uploaded file that may be turned into the artifact of the content unit.  # noqa: E501

        :return: The file of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: file
        """
        return self._file

    @file.setter
    def file(self, file):
        """Sets the file of this AnsibleCollectionVersion.

        An uploaded file that may be turned into the artifact of the content unit.  # noqa: E501

        :param file: The file of this AnsibleCollectionVersion.  # noqa: E501
        :type: file
        """

        self._file = file

    @property
    def repository(self):
        """Gets the repository of this AnsibleCollectionVersion.  # noqa: E501

        A URI of a repository the new content unit should be associated with.  # noqa: E501

        :return: The repository of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this AnsibleCollectionVersion.

        A URI of a repository the new content unit should be associated with.  # noqa: E501

        :param repository: The repository of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def name(self):
        """Gets the name of this AnsibleCollectionVersion.  # noqa: E501

        The name of the collection.  # noqa: E501

        :return: The name of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AnsibleCollectionVersion.

        The name of the collection.  # noqa: E501

        :param name: The name of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 64):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def namespace(self):
        """Gets the namespace of this AnsibleCollectionVersion.  # noqa: E501

        The namespace of the collection.  # noqa: E501

        :return: The namespace of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this AnsibleCollectionVersion.

        The namespace of the collection.  # noqa: E501

        :param namespace: The namespace of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and namespace is None:  # noqa: E501
            raise ValueError("Invalid value for `namespace`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                namespace is not None and len(namespace) > 64):
            raise ValueError("Invalid value for `namespace`, length must be less than or equal to `64`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                namespace is not None and len(namespace) < 1):
            raise ValueError("Invalid value for `namespace`, length must be greater than or equal to `1`")  # noqa: E501

        self._namespace = namespace

    @property
    def version(self):
        """Gets the version of this AnsibleCollectionVersion.  # noqa: E501

        The version of the collection.  # noqa: E501

        :return: The version of this AnsibleCollectionVersion.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this AnsibleCollectionVersion.

        The version of the collection.  # noqa: E501

        :param version: The version of this AnsibleCollectionVersion.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                version is not None and len(version) > 128):
            raise ValueError("Invalid value for `version`, length must be less than or equal to `128`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                version is not None and len(version) < 1):
            raise ValueError("Invalid value for `version`, length must be greater than or equal to `1`")  # noqa: E501

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnsibleCollectionVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnsibleCollectionVersion):
            return True

        return self.to_dict() != other.to_dict()
