import logging, colorlog
from logging.handlers import RotatingFileHandler
from colorlog import ColoredFormatter
import sys

file_logging = False
logfile_path = 'android_pentest.log'
logsize = 1048576 * 10  # 10M
logrotate = 5
# logger_severity = logging.DEBUG
logger_severity = logging.INFO

formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')

log_colors = {'DEBUG': 'blue', 'INFO': 'reset',
              'WARNING': 'yellow', 'ERROR': 'red',
              'CRITICAL': 'bold_red', 'SUCCESS': 'green'}
log_level = {'DEBUG': '[D]', 'INFO': '[I]',
              'WARNING': '[*]', 'ERROR': '[-]',
              'CRITICAL': '[-]', 'SUCCESS': '[+]'}

# --- log usage ---
# log.success('test')
# log.warning('test')
# log.error('test')
# log.critical('test')
# log.info('test')

# Add new logging level
SUCCESS = 25
logging.addLevelName(SUCCESS, 'SUCCESS')  # addLevelName(25, 'MESSAGE')

def success(self, msg, *args, **kwargs):
    if self.isEnabledFor(SUCCESS):
        self._log(SUCCESS, msg, args, **kwargs)

logging.success = success
logging.Logger.success = success


# logging levels
log = logging.getLogger(__name__)
log.setLevel(logger_severity)

if file_logging:
    handler = RotatingFileHandler(logfile_path, maxBytes=logsize, backupCount=logrotate, encoding='utf-8')
    handler.setLevel(logger_severity)
    handler.setFormatter(formatter)
    log.addHandler(handler)

console_handler = logging.StreamHandler(sys.stdout)
console_handler.setLevel(logger_severity)
colored_formatter = ColoredFormatter('%(cyan)s%(asctime)s %(log_color)s[%(levelname).1s] %(message)s%(reset)s'.format(), log_colors=log_colors, datefmt="[%H:%M:%S]")
console_handler.setFormatter(colored_formatter)

log.addHandler(console_handler)

def getLogger():
    return log