/// Files: kernel/trace/ring_buffer.c
/// Fix: bbeb97464eefc65f506084fd9f18f21653e01137
/// Fixes: b23d7a5f4a07af02343cdd28fe1f7488bac3afda

virtual detect

@err_ring_buffer_reset_cpu@
identifier buffer, cpu, cpu_buffer;
position p;
@@

ring_buffer_reset_cpu(struct trace_buffer *buffer, int cpu)
{
	...
	struct ring_buffer_per_cpu *cpu_buffer = buffer->buffers[cpu];
	... when != mutex_lock(&buffer->mutex);
	atomic_inc(&cpu_buffer->resize_disabled);@p
	...
	atomic_dec(&cpu_buffer->resize_disabled);
	... when != mutex_unlock(&buffer->mutex);
}

@err_ring_buffer_reset_online_cpus@
identifier buffer, cpu, cpu_buffer;
iterator name for_each_online_buffer_cpu;
position p;
@@

ring_buffer_reset_online_cpus(struct trace_buffer *buffer)
{
	...
	struct ring_buffer_per_cpu *cpu_buffer;
	... when != mutex_lock(&buffer->mutex);
	for_each_online_buffer_cpu(buffer, cpu)@p {
		...
		atomic_inc(&cpu_buffer->resize_disabled);
		...
	}
	...
	for_each_online_buffer_cpu(buffer, cpu) {
		...
		atomic_dec(&cpu_buffer->resize_disabled)
		...
	}
	... when != mutex_unlock(&buffer->mutex);
}

@script:python depends on detect@
p << err_ring_buffer_reset_cpu.p;
@@

coccilib.report.print_report(p[0], "ERROR: CVE-2020-27825")

@script:python depends on detect@
p << err_ring_buffer_reset_online_cpus.p;
@@

coccilib.report.print_report(p[0], "ERROR: CVE-2020-27825")
