from typing import Any

from pandas.core.computation import (
    expr as expr,
    ops as ops,
    scope as _scope,
)
from pandas.core.computation.expr import BaseExprVisitor as BaseExprVisitor
from pandas.core.indexes.base import Index

class PyTablesScope(_scope.Scope):
    queryables: dict[str, Any]
    def __init__(
        self,
        level: int,
        global_dict=...,
        local_dict=...,
        queryables: dict[str, Any] | None = ...,
    ) -> None: ...

class Term(ops.Term):
    env = ...
    def __new__(cls, name, env, side=..., encoding=...): ...
    def __init__(self, name, env: PyTablesScope, side=..., encoding=...) -> None: ...
    @property
    def value(self): ...
    @value.setter
    def value(self, new_value) -> None: ...

class Constant(Term):
    def __init__(self, value, env: PyTablesScope, side=..., encoding=...) -> None: ...

class BinOp(ops.BinOp):
    op: str
    queryables: dict[str, Any]
    encoding = ...
    condition = ...
    def __init__(
        self, op: str, lhs, rhs, queryables: dict[str, Any], encoding
    ) -> None: ...
    def prune(self, klass): ...
    def conform(self, rhs): ...
    @property
    def is_valid(self) -> bool: ...
    @property
    def is_in_table(self) -> bool: ...
    @property
    def kind(self): ...
    @property
    def meta(self): ...
    @property
    def metadata(self): ...
    def generate(self, v) -> str: ...
    def convert_value(self, v) -> TermValue: ...
    def convert_values(self) -> None: ...

class FilterBinOp(BinOp):
    filter: tuple[Any, Any, Index] | None = ...
    def invert(self): ...
    def format(self): ...
    def evaluate(self): ...
    def generate_filter_op(self, invert: bool = ...): ...

class JointFilterBinOp(FilterBinOp):
    def format(self) -> None: ...
    def evaluate(self): ...

class ConditionBinOp(BinOp):
    def invert(self) -> None: ...
    def format(self): ...
    condition = ...
    def evaluate(self): ...

class JointConditionBinOp(ConditionBinOp):
    condition = ...
    def evaluate(self): ...

class UnaryOp(ops.UnaryOp):
    def prune(self, klass): ...

class PyTablesExprVisitor(BaseExprVisitor):
    const_type = ...
    term_type = ...
    def __init__(self, env, engine, parser, **kwargs): ...
    def visit_UnaryOp(self, node, **kwargs): ...
    def visit_Index(self, node, **kwargs): ...
    def visit_Assign(self, node, **kwargs): ...
    def visit_Subscript(self, node, **kwargs): ...
    def visit_Attribute(self, node, **kwargs): ...
    def translate_In(self, op): ...

class PyTablesExpr(expr.Expr):
    encoding = ...
    condition = ...
    filter = ...
    terms = ...
    expr = ...
    def __init__(
        self,
        where,
        queryables: dict[str, Any] | None = ...,
        encoding=...,
        scope_level: int = ...,
    ) -> None: ...
    def evaluate(self): ...

class TermValue:
    value = ...
    converted = ...
    kind = ...
    def __init__(self, value, converted, kind: str) -> None: ...
    def tostring(self, encoding) -> str: ...

def maybe_expression(s) -> bool: ...
