
module new_task_spawner_wrapper (
    input clk,
    input rstn,
    //Input stream from accelerator
    input         stream_in_tvalid,
    output        stream_in_tready,
    input  [1:0]  stream_in_tdest,
    input  [63:0] stream_in_tdata,
    input         stream_in_tlast,
    //Output stream to hwruntime
    output        stream_out_tvalid,
    input         stream_out_tready,
    output [1:0]  stream_out_tdest,
    output [63:0] stream_out_tdata,
    output        stream_out_tlast,
    //Ack in interface
    input        ack_in_tvalid,
    output       ack_in_tready,
    input [63:0] ack_in_tdata,
    //Ack out interface
    output       ack_out_tvalid,
    input        ack_out_tready,
    output [7:0] ack_out_tdata
);

    newtask_spawner new_task_spawner_I (
        .clk(clk),
        .rstn(rstn),
        .stream_in_tvalid(stream_in_tvalid),
        .stream_in_tready(stream_in_tready),
        .stream_in_tdest(stream_in_tdest),
        .stream_in_tdata(stream_in_tdata),
        .stream_in_tlast(stream_in_tlast),
        .stream_out_tvalid(stream_out_tvalid),
        .stream_out_tready(stream_out_tready),
        .stream_out_tdest(stream_out_tdest),
        .stream_out_tdata(stream_out_tdata),
        .stream_out_tlast(stream_out_tlast),
        .ack_in_tvalid(ack_in_tvalid),
        .ack_in_tready(ack_in_tready),
        .ack_in_tdata(ack_in_tdata),
        .ack_out_tvalid(ack_out_tvalid),
        .ack_out_tready(ack_out_tready),
        .ack_out_tdata(ack_out_tdata)
    );

endmodule
