# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ReimburseBankAccountInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_type': 'int',
        'number': 'str',
        'holder_name': 'str',
        'holder_name_kana': 'str',
        'bank_code': 'str',
        'bank_name_kana': 'str',
        'bank_branch_code': 'str',
        'bank_branch_name_kana': 'str'
    }

    attribute_map = {
        'account_type': 'account_type',
        'number': 'number',
        'holder_name': 'holder_name',
        'holder_name_kana': 'holder_name_kana',
        'bank_code': 'bank_code',
        'bank_name_kana': 'bank_name_kana',
        'bank_branch_code': 'bank_branch_code',
        'bank_branch_name_kana': 'bank_branch_name_kana'
    }

    def __init__(self, account_type=None, number=None, holder_name=None, holder_name_kana=None, bank_code=None, bank_name_kana=None, bank_branch_code=None, bank_branch_name_kana=None, local_vars_configuration=None):  # noqa: E501
        """ReimburseBankAccountInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_type = None
        self._number = None
        self._holder_name = None
        self._holder_name_kana = None
        self._bank_code = None
        self._bank_name_kana = None
        self._bank_branch_code = None
        self._bank_branch_name_kana = None
        self.discriminator = None

        self.account_type = account_type
        self.number = number
        self.holder_name = holder_name
        self.holder_name_kana = holder_name_kana
        if bank_code is not None:
            self.bank_code = bank_code
        if bank_name_kana is not None:
            self.bank_name_kana = bank_name_kana
        if bank_branch_code is not None:
            self.bank_branch_code = bank_branch_code
        if bank_branch_name_kana is not None:
            self.bank_branch_name_kana = bank_branch_name_kana

    @property
    def account_type(self):
        """Gets the account_type of this ReimburseBankAccountInput.  # noqa: E501

        口座種別（1:普通, 2:当座, 4:貯蓄）  # noqa: E501

        :return: The account_type of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: int
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this ReimburseBankAccountInput.

        口座種別（1:普通, 2:当座, 4:貯蓄）  # noqa: E501

        :param account_type: The account_type of this ReimburseBankAccountInput.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and account_type is None:  # noqa: E501
            raise ValueError("Invalid value for `account_type`, must not be `None`")  # noqa: E501
        allowed_values = [1, 2, 4]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and account_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `account_type` ({0}), must be one of {1}"  # noqa: E501
                .format(account_type, allowed_values)
            )

        self._account_type = account_type

    @property
    def number(self):
        """Gets the number of this ReimburseBankAccountInput.  # noqa: E501

        口座番号  # noqa: E501

        :return: The number of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this ReimburseBankAccountInput.

        口座番号  # noqa: E501

        :param number: The number of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and number is None:  # noqa: E501
            raise ValueError("Invalid value for `number`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number is not None and len(number) > 10):
            raise ValueError("Invalid value for `number`, length must be less than or equal to `10`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number is not None and len(number) < 7):
            raise ValueError("Invalid value for `number`, length must be greater than or equal to `7`")  # noqa: E501

        self._number = number

    @property
    def holder_name(self):
        """Gets the holder_name of this ReimburseBankAccountInput.  # noqa: E501

        口座名義  # noqa: E501

        :return: The holder_name of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._holder_name

    @holder_name.setter
    def holder_name(self, holder_name):
        """Sets the holder_name of this ReimburseBankAccountInput.

        口座名義  # noqa: E501

        :param holder_name: The holder_name of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and holder_name is None:  # noqa: E501
            raise ValueError("Invalid value for `holder_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                holder_name is not None and len(holder_name) > 50):
            raise ValueError("Invalid value for `holder_name`, length must be less than or equal to `50`")  # noqa: E501

        self._holder_name = holder_name

    @property
    def holder_name_kana(self):
        """Gets the holder_name_kana of this ReimburseBankAccountInput.  # noqa: E501

        口座名義半角カナ  # noqa: E501

        :return: The holder_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._holder_name_kana

    @holder_name_kana.setter
    def holder_name_kana(self, holder_name_kana):
        """Sets the holder_name_kana of this ReimburseBankAccountInput.

        口座名義半角カナ  # noqa: E501

        :param holder_name_kana: The holder_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and holder_name_kana is None:  # noqa: E501
            raise ValueError("Invalid value for `holder_name_kana`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                holder_name_kana is not None and len(holder_name_kana) > 50):
            raise ValueError("Invalid value for `holder_name_kana`, length must be less than or equal to `50`")  # noqa: E501

        self._holder_name_kana = holder_name_kana

    @property
    def bank_code(self):
        """Gets the bank_code of this ReimburseBankAccountInput.  # noqa: E501

        銀行コード（銀行コードもしくは銀行名半角カナどちらかの設定が必要）  # noqa: E501

        :return: The bank_code of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._bank_code

    @bank_code.setter
    def bank_code(self, bank_code):
        """Sets the bank_code of this ReimburseBankAccountInput.

        銀行コード（銀行コードもしくは銀行名半角カナどちらかの設定が必要）  # noqa: E501

        :param bank_code: The bank_code of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                bank_code is not None and len(bank_code) > 4):
            raise ValueError("Invalid value for `bank_code`, length must be less than or equal to `4`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                bank_code is not None and len(bank_code) < 4):
            raise ValueError("Invalid value for `bank_code`, length must be greater than or equal to `4`")  # noqa: E501

        self._bank_code = bank_code

    @property
    def bank_name_kana(self):
        """Gets the bank_name_kana of this ReimburseBankAccountInput.  # noqa: E501

        銀行名半角カナ（銀行コードもしくは銀行名半角カナどちらかの設定が必要）  # noqa: E501

        :return: The bank_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._bank_name_kana

    @bank_name_kana.setter
    def bank_name_kana(self, bank_name_kana):
        """Sets the bank_name_kana of this ReimburseBankAccountInput.

        銀行名半角カナ（銀行コードもしくは銀行名半角カナどちらかの設定が必要）  # noqa: E501

        :param bank_name_kana: The bank_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                bank_name_kana is not None and len(bank_name_kana) > 255):
            raise ValueError("Invalid value for `bank_name_kana`, length must be less than or equal to `255`")  # noqa: E501

        self._bank_name_kana = bank_name_kana

    @property
    def bank_branch_code(self):
        """Gets the bank_branch_code of this ReimburseBankAccountInput.  # noqa: E501

        支店コード（支店コードもしくは支店名半角カナどちらかの設定が必要）  # noqa: E501

        :return: The bank_branch_code of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._bank_branch_code

    @bank_branch_code.setter
    def bank_branch_code(self, bank_branch_code):
        """Sets the bank_branch_code of this ReimburseBankAccountInput.

        支店コード（支店コードもしくは支店名半角カナどちらかの設定が必要）  # noqa: E501

        :param bank_branch_code: The bank_branch_code of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                bank_branch_code is not None and len(bank_branch_code) > 3):
            raise ValueError("Invalid value for `bank_branch_code`, length must be less than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                bank_branch_code is not None and len(bank_branch_code) < 3):
            raise ValueError("Invalid value for `bank_branch_code`, length must be greater than or equal to `3`")  # noqa: E501

        self._bank_branch_code = bank_branch_code

    @property
    def bank_branch_name_kana(self):
        """Gets the bank_branch_name_kana of this ReimburseBankAccountInput.  # noqa: E501

        支店名半角カナ（支店コードもしくは支店名半角カナどちらかの設定が必要）  # noqa: E501

        :return: The bank_branch_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :rtype: str
        """
        return self._bank_branch_name_kana

    @bank_branch_name_kana.setter
    def bank_branch_name_kana(self, bank_branch_name_kana):
        """Sets the bank_branch_name_kana of this ReimburseBankAccountInput.

        支店名半角カナ（支店コードもしくは支店名半角カナどちらかの設定が必要）  # noqa: E501

        :param bank_branch_name_kana: The bank_branch_name_kana of this ReimburseBankAccountInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                bank_branch_name_kana is not None and len(bank_branch_name_kana) > 255):
            raise ValueError("Invalid value for `bank_branch_name_kana`, length must be less than or equal to `255`")  # noqa: E501

        self._bank_branch_name_kana = bank_branch_name_kana

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReimburseBankAccountInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReimburseBankAccountInput):
            return True

        return self.to_dict() != other.to_dict()
