# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ReceiptInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'content': 'str',
        'content_type': 'str',
        'filename': 'str',
        'process_type': 'str',
        'split_pdf': 'bool'
    }

    attribute_map = {
        'content': 'content',
        'content_type': 'content_type',
        'filename': 'filename',
        'process_type': 'process_type',
        'split_pdf': 'split_pdf'
    }

    def __init__(self, content=None, content_type=None, filename=None, process_type=None, split_pdf=None, local_vars_configuration=None):  # noqa: E501
        """ReceiptInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._content = None
        self._content_type = None
        self._filename = None
        self._process_type = None
        self._split_pdf = None
        self.discriminator = None

        self.content = content
        self.content_type = content_type
        self.filename = filename
        if process_type is not None:
            self.process_type = process_type
        if split_pdf is not None:
            self.split_pdf = split_pdf

    @property
    def content(self):
        """Gets the content of this ReceiptInput.  # noqa: E501

        領収書画像バイナリをBase64エンコードしたもの  # noqa: E501

        :return: The content of this ReceiptInput.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this ReceiptInput.

        領収書画像バイナリをBase64エンコードしたもの  # noqa: E501

        :param content: The content of this ReceiptInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and content is None:  # noqa: E501
            raise ValueError("Invalid value for `content`, must not be `None`")  # noqa: E501

        self._content = content

    @property
    def content_type(self):
        """Gets the content_type of this ReceiptInput.  # noqa: E501

        領収書画像ファイルのcontent type（MIME type）  # noqa: E501

        :return: The content_type of this ReceiptInput.  # noqa: E501
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """Sets the content_type of this ReceiptInput.

        領収書画像ファイルのcontent type（MIME type）  # noqa: E501

        :param content_type: The content_type of this ReceiptInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and content_type is None:  # noqa: E501
            raise ValueError("Invalid value for `content_type`, must not be `None`")  # noqa: E501

        self._content_type = content_type

    @property
    def filename(self):
        """Gets the filename of this ReceiptInput.  # noqa: E501

        領収書画像ファイルのファイル名  # noqa: E501

        :return: The filename of this ReceiptInput.  # noqa: E501
        :rtype: str
        """
        return self._filename

    @filename.setter
    def filename(self, filename):
        """Sets the filename of this ReceiptInput.

        領収書画像ファイルのファイル名  # noqa: E501

        :param filename: The filename of this ReceiptInput.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and filename is None:  # noqa: E501
            raise ValueError("Invalid value for `filename`, must not be `None`")  # noqa: E501

        self._filename = filename

    @property
    def process_type(self):
        """Gets the process_type of this ReceiptInput.  # noqa: E501

        0:何もしない、1:オペレーター入力, 2:OCR処理, 指定なしの場合何もしない  # noqa: E501

        :return: The process_type of this ReceiptInput.  # noqa: E501
        :rtype: str
        """
        return self._process_type

    @process_type.setter
    def process_type(self, process_type):
        """Sets the process_type of this ReceiptInput.

        0:何もしない、1:オペレーター入力, 2:OCR処理, 指定なしの場合何もしない  # noqa: E501

        :param process_type: The process_type of this ReceiptInput.  # noqa: E501
        :type: str
        """
        allowed_values = ["0", "1", "2"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and process_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `process_type` ({0}), must be one of {1}"  # noqa: E501
                .format(process_type, allowed_values)
            )

        self._process_type = process_type

    @property
    def split_pdf(self):
        """Gets the split_pdf of this ReceiptInput.  # noqa: E501

        trueの場合にPDFファイルであればページ分割をする  # noqa: E501

        :return: The split_pdf of this ReceiptInput.  # noqa: E501
        :rtype: bool
        """
        return self._split_pdf

    @split_pdf.setter
    def split_pdf(self, split_pdf):
        """Sets the split_pdf of this ReceiptInput.

        trueの場合にPDFファイルであればページ分割をする  # noqa: E501

        :param split_pdf: The split_pdf of this ReceiptInput.  # noqa: E501
        :type: bool
        """

        self._split_pdf = split_pdf

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReceiptInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReceiptInput):
            return True

        return self.to_dict() != other.to_dict()
