# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ProjectCode(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'code': 'str',
        'priority': 'int',
        'is_active': 'bool',
        'parent_id': 'str',
        'root_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'code': 'code',
        'priority': 'priority',
        'is_active': 'is_active',
        'parent_id': 'parent_id',
        'root_id': 'root_id'
    }

    def __init__(self, id=None, name=None, code=None, priority=100, is_active=True, parent_id=None, root_id=None, local_vars_configuration=None):  # noqa: E501
        """ProjectCode - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._code = None
        self._priority = None
        self._is_active = None
        self._parent_id = None
        self._root_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        self.code = code
        if priority is not None:
            self.priority = priority
        if is_active is not None:
            self.is_active = is_active
        if parent_id is not None:
            self.parent_id = parent_id
        if root_id is not None:
            self.root_id = root_id

    @property
    def id(self):
        """Gets the id of this ProjectCode.  # noqa: E501

        プロジェクトid  # noqa: E501

        :return: The id of this ProjectCode.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ProjectCode.

        プロジェクトid  # noqa: E501

        :param id: The id of this ProjectCode.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this ProjectCode.  # noqa: E501

        プロジェクト名称  # noqa: E501

        :return: The name of this ProjectCode.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ProjectCode.

        プロジェクト名称  # noqa: E501

        :param name: The name of this ProjectCode.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501

        self._name = name

    @property
    def code(self):
        """Gets the code of this ProjectCode.  # noqa: E501

        プロジェクトコード  # noqa: E501

        :return: The code of this ProjectCode.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this ProjectCode.

        プロジェクトコード  # noqa: E501

        :param code: The code of this ProjectCode.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and code is None:  # noqa: E501
            raise ValueError("Invalid value for `code`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                code is not None and len(code) > 30):
            raise ValueError("Invalid value for `code`, length must be less than or equal to `30`")  # noqa: E501

        self._code = code

    @property
    def priority(self):
        """Gets the priority of this ProjectCode.  # noqa: E501

        表示優先順（昇順）  # noqa: E501

        :return: The priority of this ProjectCode.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this ProjectCode.

        表示優先順（昇順）  # noqa: E501

        :param priority: The priority of this ProjectCode.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority > 16777215):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `16777215`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority < 0):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `0`")  # noqa: E501

        self._priority = priority

    @property
    def is_active(self):
        """Gets the is_active of this ProjectCode.  # noqa: E501

        表示フラグをオフで新規の経費登録等の選択肢に表示されなくなります  # noqa: E501

        :return: The is_active of this ProjectCode.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this ProjectCode.

        表示フラグをオフで新規の経費登録等の選択肢に表示されなくなります  # noqa: E501

        :param is_active: The is_active of this ProjectCode.  # noqa: E501
        :type: bool
        """

        self._is_active = is_active

    @property
    def parent_id(self):
        """Gets the parent_id of this ProjectCode.  # noqa: E501

        親プロジェクトid  # noqa: E501

        :return: The parent_id of this ProjectCode.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this ProjectCode.

        親プロジェクトid  # noqa: E501

        :param parent_id: The parent_id of this ProjectCode.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                parent_id is not None and len(parent_id) > 40):
            raise ValueError("Invalid value for `parent_id`, length must be less than or equal to `40`")  # noqa: E501

        self._parent_id = parent_id

    @property
    def root_id(self):
        """Gets the root_id of this ProjectCode.  # noqa: E501

        最上位プロジェクトid  # noqa: E501

        :return: The root_id of this ProjectCode.  # noqa: E501
        :rtype: str
        """
        return self._root_id

    @root_id.setter
    def root_id(self, root_id):
        """Sets the root_id of this ProjectCode.

        最上位プロジェクトid  # noqa: E501

        :param root_id: The root_id of this ProjectCode.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                root_id is not None and len(root_id) > 40):
            raise ValueError("Invalid value for `root_id`, length must be less than or equal to `40`")  # noqa: E501

        self._root_id = root_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ProjectCode):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ProjectCode):
            return True

        return self.to_dict() != other.to_dict()
