# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class Position(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'is_authorizer': 'bool',
        'priority': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'is_authorizer': 'is_authorizer',
        'priority': 'priority'
    }

    def __init__(self, id=None, name=None, is_authorizer=False, priority=100, local_vars_configuration=None):  # noqa: E501
        """Position - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._is_authorizer = None
        self._priority = None
        self.discriminator = None

        self.id = id
        self.name = name
        self.is_authorizer = is_authorizer
        self.priority = priority

    @property
    def id(self):
        """Gets the id of this Position.  # noqa: E501

        役職id  # noqa: E501

        :return: The id of this Position.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Position.

        役職id  # noqa: E501

        :param id: The id of this Position.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this Position.  # noqa: E501

        役職名称  # noqa: E501

        :return: The name of this Position.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Position.

        役職名称  # noqa: E501

        :param name: The name of this Position.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501

        self._name = name

    @property
    def is_authorizer(self):
        """Gets the is_authorizer of this Position.  # noqa: E501

        承認権限がデフォルトかどうか  # noqa: E501

        :return: The is_authorizer of this Position.  # noqa: E501
        :rtype: bool
        """
        return self._is_authorizer

    @is_authorizer.setter
    def is_authorizer(self, is_authorizer):
        """Sets the is_authorizer of this Position.

        承認権限がデフォルトかどうか  # noqa: E501

        :param is_authorizer: The is_authorizer of this Position.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_authorizer is None:  # noqa: E501
            raise ValueError("Invalid value for `is_authorizer`, must not be `None`")  # noqa: E501

        self._is_authorizer = is_authorizer

    @property
    def priority(self):
        """Gets the priority of this Position.  # noqa: E501

        表示優先順（昇順）  # noqa: E501

        :return: The priority of this Position.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this Position.

        表示優先順（昇順）  # noqa: E501

        :param priority: The priority of this Position.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and priority is None:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority > 65534):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `65534`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority < 1):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `1`")  # noqa: E501

        self._priority = priority

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Position):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Position):
            return True

        return self.to_dict() != other.to_dict()
