# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class OfficeMemberUpdateInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'number': 'str',
        'permission_role_id': 'int',
        'depts_attributes': 'list[OfficeMemberCreateInputDeptsAttributes]',
        'position_attributes': 'OfficeMemberCreateInputPositionAttributes'
    }

    attribute_map = {
        'name': 'name',
        'number': 'number',
        'permission_role_id': 'permission_role_id',
        'depts_attributes': 'depts_attributes',
        'position_attributes': 'position_attributes'
    }

    def __init__(self, name=None, number=None, permission_role_id=None, depts_attributes=None, position_attributes=None, local_vars_configuration=None):  # noqa: E501
        """OfficeMemberUpdateInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._number = None
        self._permission_role_id = None
        self._depts_attributes = None
        self._position_attributes = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if number is not None:
            self.number = number
        if permission_role_id is not None:
            self.permission_role_id = permission_role_id
        if depts_attributes is not None:
            self.depts_attributes = depts_attributes
        if position_attributes is not None:
            self.position_attributes = position_attributes

    @property
    def name(self):
        """Gets the name of this OfficeMemberUpdateInput.  # noqa: E501

        メンバー名  # noqa: E501

        :return: The name of this OfficeMemberUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OfficeMemberUpdateInput.

        メンバー名  # noqa: E501

        :param name: The name of this OfficeMemberUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 20):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `20`")  # noqa: E501

        self._name = name

    @property
    def number(self):
        """Gets the number of this OfficeMemberUpdateInput.  # noqa: E501

        従業員番号  # noqa: E501

        :return: The number of this OfficeMemberUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this OfficeMemberUpdateInput.

        従業員番号  # noqa: E501

        :param number: The number of this OfficeMemberUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                number is not None and len(number) > 50):
            raise ValueError("Invalid value for `number`, length must be less than or equal to `50`")  # noqa: E501

        self._number = number

    @property
    def permission_role_id(self):
        """Gets the permission_role_id of this OfficeMemberUpdateInput.  # noqa: E501

        201:一般利用者、202:承認者, 203:管理者  # noqa: E501

        :return: The permission_role_id of this OfficeMemberUpdateInput.  # noqa: E501
        :rtype: int
        """
        return self._permission_role_id

    @permission_role_id.setter
    def permission_role_id(self, permission_role_id):
        """Sets the permission_role_id of this OfficeMemberUpdateInput.

        201:一般利用者、202:承認者, 203:管理者  # noqa: E501

        :param permission_role_id: The permission_role_id of this OfficeMemberUpdateInput.  # noqa: E501
        :type: int
        """
        allowed_values = [201, 202, 203]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and permission_role_id not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `permission_role_id` ({0}), must be one of {1}"  # noqa: E501
                .format(permission_role_id, allowed_values)
            )

        self._permission_role_id = permission_role_id

    @property
    def depts_attributes(self):
        """Gets the depts_attributes of this OfficeMemberUpdateInput.  # noqa: E501

        メンバーの所属部門リストパラメータ  # noqa: E501

        :return: The depts_attributes of this OfficeMemberUpdateInput.  # noqa: E501
        :rtype: list[OfficeMemberCreateInputDeptsAttributes]
        """
        return self._depts_attributes

    @depts_attributes.setter
    def depts_attributes(self, depts_attributes):
        """Sets the depts_attributes of this OfficeMemberUpdateInput.

        メンバーの所属部門リストパラメータ  # noqa: E501

        :param depts_attributes: The depts_attributes of this OfficeMemberUpdateInput.  # noqa: E501
        :type: list[OfficeMemberCreateInputDeptsAttributes]
        """

        self._depts_attributes = depts_attributes

    @property
    def position_attributes(self):
        """Gets the position_attributes of this OfficeMemberUpdateInput.  # noqa: E501


        :return: The position_attributes of this OfficeMemberUpdateInput.  # noqa: E501
        :rtype: OfficeMemberCreateInputPositionAttributes
        """
        return self._position_attributes

    @position_attributes.setter
    def position_attributes(self, position_attributes):
        """Sets the position_attributes of this OfficeMemberUpdateInput.


        :param position_attributes: The position_attributes of this OfficeMemberUpdateInput.  # noqa: E501
        :type: OfficeMemberCreateInputPositionAttributes
        """

        self._position_attributes = position_attributes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfficeMemberUpdateInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OfficeMemberUpdateInput):
            return True

        return self.to_dict() != other.to_dict()
