# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class OfficeMember(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'identification_code': 'str',
        'number': 'str',
        'name': 'str',
        'created_at': 'Datetime',
        'updated_at': 'Datetime',
        'ex_activated_at': 'Datetime',
        'is_ex_user': 'bool',
        'is_ex_authorizer': 'bool',
        'is_ex_administrator': 'bool',
        'ex_office_member_setting': 'ExOfficeMemberSetting',
        'reimburse_bank_account': 'ReimburseBankAccount',
        'position': 'Position',
        'depts': 'list[Dept]'
    }

    attribute_map = {
        'id': 'id',
        'identification_code': 'identification_code',
        'number': 'number',
        'name': 'name',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'ex_activated_at': 'ex_activated_at',
        'is_ex_user': 'is_ex_user',
        'is_ex_authorizer': 'is_ex_authorizer',
        'is_ex_administrator': 'is_ex_administrator',
        'ex_office_member_setting': 'ex_office_member_setting',
        'reimburse_bank_account': 'reimburse_bank_account',
        'position': 'position',
        'depts': 'depts'
    }

    def __init__(self, id=None, identification_code=None, number=None, name=None, created_at=None, updated_at=None, ex_activated_at=None, is_ex_user=None, is_ex_authorizer=None, is_ex_administrator=None, ex_office_member_setting=None, reimburse_bank_account=None, position=None, depts=None, local_vars_configuration=None):  # noqa: E501
        """OfficeMember - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._identification_code = None
        self._number = None
        self._name = None
        self._created_at = None
        self._updated_at = None
        self._ex_activated_at = None
        self._is_ex_user = None
        self._is_ex_authorizer = None
        self._is_ex_administrator = None
        self._ex_office_member_setting = None
        self._reimburse_bank_account = None
        self._position = None
        self._depts = None
        self.discriminator = None

        self.id = id
        if identification_code is not None:
            self.identification_code = identification_code
        if number is not None:
            self.number = number
        if name is not None:
            self.name = name
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if ex_activated_at is not None:
            self.ex_activated_at = ex_activated_at
        if is_ex_user is not None:
            self.is_ex_user = is_ex_user
        if is_ex_authorizer is not None:
            self.is_ex_authorizer = is_ex_authorizer
        if is_ex_administrator is not None:
            self.is_ex_administrator = is_ex_administrator
        if ex_office_member_setting is not None:
            self.ex_office_member_setting = ex_office_member_setting
        if reimburse_bank_account is not None:
            self.reimburse_bank_account = reimburse_bank_account
        if position is not None:
            self.position = position
        if depts is not None:
            self.depts = depts

    @property
    def id(self):
        """Gets the id of this OfficeMember.  # noqa: E501

        メンバーid  # noqa: E501

        :return: The id of this OfficeMember.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OfficeMember.

        メンバーid  # noqa: E501

        :param id: The id of this OfficeMember.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def identification_code(self):
        """Gets the identification_code of this OfficeMember.  # noqa: E501

        メンバー識別番号  # noqa: E501

        :return: The identification_code of this OfficeMember.  # noqa: E501
        :rtype: str
        """
        return self._identification_code

    @identification_code.setter
    def identification_code(self, identification_code):
        """Sets the identification_code of this OfficeMember.

        メンバー識別番号  # noqa: E501

        :param identification_code: The identification_code of this OfficeMember.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                identification_code is not None and len(identification_code) > 12):
            raise ValueError("Invalid value for `identification_code`, length must be less than or equal to `12`")  # noqa: E501

        self._identification_code = identification_code

    @property
    def number(self):
        """Gets the number of this OfficeMember.  # noqa: E501

        従業員番号  # noqa: E501

        :return: The number of this OfficeMember.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this OfficeMember.

        従業員番号  # noqa: E501

        :param number: The number of this OfficeMember.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                number is not None and len(number) > 50):
            raise ValueError("Invalid value for `number`, length must be less than or equal to `50`")  # noqa: E501

        self._number = number

    @property
    def name(self):
        """Gets the name of this OfficeMember.  # noqa: E501

        メンバー名  # noqa: E501

        :return: The name of this OfficeMember.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OfficeMember.

        メンバー名  # noqa: E501

        :param name: The name of this OfficeMember.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 20):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `20`")  # noqa: E501

        self._name = name

    @property
    def created_at(self):
        """Gets the created_at of this OfficeMember.  # noqa: E501

        メンバー追加日時  # noqa: E501

        :return: The created_at of this OfficeMember.  # noqa: E501
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this OfficeMember.

        メンバー追加日時  # noqa: E501

        :param created_at: The created_at of this OfficeMember.  # noqa: E501
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this OfficeMember.  # noqa: E501

        メンバー更新日時  # noqa: E501

        :return: The updated_at of this OfficeMember.  # noqa: E501
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this OfficeMember.

        メンバー更新日時  # noqa: E501

        :param updated_at: The updated_at of this OfficeMember.  # noqa: E501
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def ex_activated_at(self):
        """Gets the ex_activated_at of this OfficeMember.  # noqa: E501

        直近マネーフォワード クラウド経費利用開始日時  # noqa: E501

        :return: The ex_activated_at of this OfficeMember.  # noqa: E501
        :rtype: Datetime
        """
        return self._ex_activated_at

    @ex_activated_at.setter
    def ex_activated_at(self, ex_activated_at):
        """Sets the ex_activated_at of this OfficeMember.

        直近マネーフォワード クラウド経費利用開始日時  # noqa: E501

        :param ex_activated_at: The ex_activated_at of this OfficeMember.  # noqa: E501
        :type: Datetime
        """

        self._ex_activated_at = ex_activated_at

    @property
    def is_ex_user(self):
        """Gets the is_ex_user of this OfficeMember.  # noqa: E501

        マネーフォワード クラウド経費の一般権限を持つかどうか  # noqa: E501

        :return: The is_ex_user of this OfficeMember.  # noqa: E501
        :rtype: bool
        """
        return self._is_ex_user

    @is_ex_user.setter
    def is_ex_user(self, is_ex_user):
        """Sets the is_ex_user of this OfficeMember.

        マネーフォワード クラウド経費の一般権限を持つかどうか  # noqa: E501

        :param is_ex_user: The is_ex_user of this OfficeMember.  # noqa: E501
        :type: bool
        """

        self._is_ex_user = is_ex_user

    @property
    def is_ex_authorizer(self):
        """Gets the is_ex_authorizer of this OfficeMember.  # noqa: E501

        マネーフォワード クラウド経費の承認権限を持つかどうか  # noqa: E501

        :return: The is_ex_authorizer of this OfficeMember.  # noqa: E501
        :rtype: bool
        """
        return self._is_ex_authorizer

    @is_ex_authorizer.setter
    def is_ex_authorizer(self, is_ex_authorizer):
        """Sets the is_ex_authorizer of this OfficeMember.

        マネーフォワード クラウド経費の承認権限を持つかどうか  # noqa: E501

        :param is_ex_authorizer: The is_ex_authorizer of this OfficeMember.  # noqa: E501
        :type: bool
        """

        self._is_ex_authorizer = is_ex_authorizer

    @property
    def is_ex_administrator(self):
        """Gets the is_ex_administrator of this OfficeMember.  # noqa: E501

        マネーフォワード クラウド経費の管理者権限を持つかどうか  # noqa: E501

        :return: The is_ex_administrator of this OfficeMember.  # noqa: E501
        :rtype: bool
        """
        return self._is_ex_administrator

    @is_ex_administrator.setter
    def is_ex_administrator(self, is_ex_administrator):
        """Sets the is_ex_administrator of this OfficeMember.

        マネーフォワード クラウド経費の管理者権限を持つかどうか  # noqa: E501

        :param is_ex_administrator: The is_ex_administrator of this OfficeMember.  # noqa: E501
        :type: bool
        """

        self._is_ex_administrator = is_ex_administrator

    @property
    def ex_office_member_setting(self):
        """Gets the ex_office_member_setting of this OfficeMember.  # noqa: E501


        :return: The ex_office_member_setting of this OfficeMember.  # noqa: E501
        :rtype: ExOfficeMemberSetting
        """
        return self._ex_office_member_setting

    @ex_office_member_setting.setter
    def ex_office_member_setting(self, ex_office_member_setting):
        """Sets the ex_office_member_setting of this OfficeMember.


        :param ex_office_member_setting: The ex_office_member_setting of this OfficeMember.  # noqa: E501
        :type: ExOfficeMemberSetting
        """

        self._ex_office_member_setting = ex_office_member_setting

    @property
    def reimburse_bank_account(self):
        """Gets the reimburse_bank_account of this OfficeMember.  # noqa: E501


        :return: The reimburse_bank_account of this OfficeMember.  # noqa: E501
        :rtype: ReimburseBankAccount
        """
        return self._reimburse_bank_account

    @reimburse_bank_account.setter
    def reimburse_bank_account(self, reimburse_bank_account):
        """Sets the reimburse_bank_account of this OfficeMember.


        :param reimburse_bank_account: The reimburse_bank_account of this OfficeMember.  # noqa: E501
        :type: ReimburseBankAccount
        """

        self._reimburse_bank_account = reimburse_bank_account

    @property
    def position(self):
        """Gets the position of this OfficeMember.  # noqa: E501


        :return: The position of this OfficeMember.  # noqa: E501
        :rtype: Position
        """
        return self._position

    @position.setter
    def position(self, position):
        """Sets the position of this OfficeMember.


        :param position: The position of this OfficeMember.  # noqa: E501
        :type: Position
        """

        self._position = position

    @property
    def depts(self):
        """Gets the depts of this OfficeMember.  # noqa: E501

        メンバーの所属部門リスト  # noqa: E501

        :return: The depts of this OfficeMember.  # noqa: E501
        :rtype: list[Dept]
        """
        return self._depts

    @depts.setter
    def depts(self, depts):
        """Sets the depts of this OfficeMember.

        メンバーの所属部門リスト  # noqa: E501

        :param depts: The depts of this OfficeMember.  # noqa: E501
        :type: list[Dept]
        """

        self._depts = depts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfficeMember):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OfficeMember):
            return True

        return self.to_dict() != other.to_dict()
