# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExTransactionUpdateInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'remark': 'str',
        'recognized_at': 'date',
        'value': 'float',
        'memo': 'str',
        'report_number': 'str',
        'jpyrate': 'float',
        'currency': 'str',
        'use_custom_jpy_rate': 'bool',
        'ex_item_id': 'str',
        'dr_excise_id': 'str',
        'dept_id': 'str',
        'project_code_id': 'str',
        'cr_item_id': 'str',
        'cr_sub_item_id': 'str'
    }

    attribute_map = {
        'remark': 'remark',
        'recognized_at': 'recognized_at',
        'value': 'value',
        'memo': 'memo',
        'report_number': 'report_number',
        'jpyrate': 'jpyrate',
        'currency': 'currency',
        'use_custom_jpy_rate': 'use_custom_jpy_rate',
        'ex_item_id': 'ex_item_id',
        'dr_excise_id': 'dr_excise_id',
        'dept_id': 'dept_id',
        'project_code_id': 'project_code_id',
        'cr_item_id': 'cr_item_id',
        'cr_sub_item_id': 'cr_sub_item_id'
    }

    def __init__(self, remark=None, recognized_at=None, value=None, memo=None, report_number=None, jpyrate=None, currency='JPY', use_custom_jpy_rate=False, ex_item_id=None, dr_excise_id=None, dept_id=None, project_code_id=None, cr_item_id=None, cr_sub_item_id=None, local_vars_configuration=None):  # noqa: E501
        """ExTransactionUpdateInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._remark = None
        self._recognized_at = None
        self._value = None
        self._memo = None
        self._report_number = None
        self._jpyrate = None
        self._currency = None
        self._use_custom_jpy_rate = None
        self._ex_item_id = None
        self._dr_excise_id = None
        self._dept_id = None
        self._project_code_id = None
        self._cr_item_id = None
        self._cr_sub_item_id = None
        self.discriminator = None

        if remark is not None:
            self.remark = remark
        if recognized_at is not None:
            self.recognized_at = recognized_at
        if value is not None:
            self.value = value
        if memo is not None:
            self.memo = memo
        if report_number is not None:
            self.report_number = report_number
        if jpyrate is not None:
            self.jpyrate = jpyrate
        if currency is not None:
            self.currency = currency
        if use_custom_jpy_rate is not None:
            self.use_custom_jpy_rate = use_custom_jpy_rate
        if ex_item_id is not None:
            self.ex_item_id = ex_item_id
        if dr_excise_id is not None:
            self.dr_excise_id = dr_excise_id
        if dept_id is not None:
            self.dept_id = dept_id
        if project_code_id is not None:
            self.project_code_id = project_code_id
        if cr_item_id is not None:
            self.cr_item_id = cr_item_id
        self.cr_sub_item_id = cr_sub_item_id

    @property
    def remark(self):
        """Gets the remark of this ExTransactionUpdateInput.  # noqa: E501

        支払先・内容  # noqa: E501

        :return: The remark of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._remark

    @remark.setter
    def remark(self, remark):
        """Sets the remark of this ExTransactionUpdateInput.

        支払先・内容  # noqa: E501

        :param remark: The remark of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                remark is not None and len(remark) > 100):
            raise ValueError("Invalid value for `remark`, length must be less than or equal to `100`")  # noqa: E501

        self._remark = remark

    @property
    def recognized_at(self):
        """Gets the recognized_at of this ExTransactionUpdateInput.  # noqa: E501

        日付  # noqa: E501

        :return: The recognized_at of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: date
        """
        return self._recognized_at

    @recognized_at.setter
    def recognized_at(self, recognized_at):
        """Sets the recognized_at of this ExTransactionUpdateInput.

        日付  # noqa: E501

        :param recognized_at: The recognized_at of this ExTransactionUpdateInput.  # noqa: E501
        :type: date
        """

        self._recognized_at = recognized_at

    @property
    def value(self):
        """Gets the value of this ExTransactionUpdateInput.  # noqa: E501

        金額  # noqa: E501

        :return: The value of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this ExTransactionUpdateInput.

        金額  # noqa: E501

        :param value: The value of this ExTransactionUpdateInput.  # noqa: E501
        :type: float
        """

        self._value = value

    @property
    def memo(self):
        """Gets the memo of this ExTransactionUpdateInput.  # noqa: E501

        メモ  # noqa: E501

        :return: The memo of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._memo

    @memo.setter
    def memo(self, memo):
        """Sets the memo of this ExTransactionUpdateInput.

        メモ  # noqa: E501

        :param memo: The memo of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                memo is not None and len(memo) > 800):
            raise ValueError("Invalid value for `memo`, length must be less than or equal to `800`")  # noqa: E501

        self._memo = memo

    @property
    def report_number(self):
        """Gets the report_number of this ExTransactionUpdateInput.  # noqa: E501

        事前申請番号  # noqa: E501

        :return: The report_number of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._report_number

    @report_number.setter
    def report_number(self, report_number):
        """Sets the report_number of this ExTransactionUpdateInput.

        事前申請番号  # noqa: E501

        :param report_number: The report_number of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                report_number is not None and len(report_number) > 50):
            raise ValueError("Invalid value for `report_number`, length must be less than or equal to `50`")  # noqa: E501

        self._report_number = report_number

    @property
    def jpyrate(self):
        """Gets the jpyrate of this ExTransactionUpdateInput.  # noqa: E501

        為替レート  # noqa: E501

        :return: The jpyrate of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: float
        """
        return self._jpyrate

    @jpyrate.setter
    def jpyrate(self, jpyrate):
        """Sets the jpyrate of this ExTransactionUpdateInput.

        為替レート  # noqa: E501

        :param jpyrate: The jpyrate of this ExTransactionUpdateInput.  # noqa: E501
        :type: float
        """

        self._jpyrate = jpyrate

    @property
    def currency(self):
        """Gets the currency of this ExTransactionUpdateInput.  # noqa: E501

        通貨  # noqa: E501

        :return: The currency of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this ExTransactionUpdateInput.

        通貨  # noqa: E501

        :param currency: The currency of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) > 3):
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) < 3):
            raise ValueError("Invalid value for `currency`, length must be greater than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def use_custom_jpy_rate(self):
        """Gets the use_custom_jpy_rate of this ExTransactionUpdateInput.  # noqa: E501

        為替レートを手動設定するかどうか  # noqa: E501

        :return: The use_custom_jpy_rate of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: bool
        """
        return self._use_custom_jpy_rate

    @use_custom_jpy_rate.setter
    def use_custom_jpy_rate(self, use_custom_jpy_rate):
        """Sets the use_custom_jpy_rate of this ExTransactionUpdateInput.

        為替レートを手動設定するかどうか  # noqa: E501

        :param use_custom_jpy_rate: The use_custom_jpy_rate of this ExTransactionUpdateInput.  # noqa: E501
        :type: bool
        """

        self._use_custom_jpy_rate = use_custom_jpy_rate

    @property
    def ex_item_id(self):
        """Gets the ex_item_id of this ExTransactionUpdateInput.  # noqa: E501

        経費科目id  # noqa: E501

        :return: The ex_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._ex_item_id

    @ex_item_id.setter
    def ex_item_id(self, ex_item_id):
        """Sets the ex_item_id of this ExTransactionUpdateInput.

        経費科目id  # noqa: E501

        :param ex_item_id: The ex_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                ex_item_id is not None and len(ex_item_id) > 40):
            raise ValueError("Invalid value for `ex_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._ex_item_id = ex_item_id

    @property
    def dr_excise_id(self):
        """Gets the dr_excise_id of this ExTransactionUpdateInput.  # noqa: E501

        税区分id  # noqa: E501

        :return: The dr_excise_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._dr_excise_id

    @dr_excise_id.setter
    def dr_excise_id(self, dr_excise_id):
        """Sets the dr_excise_id of this ExTransactionUpdateInput.

        税区分id  # noqa: E501

        :param dr_excise_id: The dr_excise_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dr_excise_id is not None and len(dr_excise_id) > 40):
            raise ValueError("Invalid value for `dr_excise_id`, length must be less than or equal to `40`")  # noqa: E501

        self._dr_excise_id = dr_excise_id

    @property
    def dept_id(self):
        """Gets the dept_id of this ExTransactionUpdateInput.  # noqa: E501

        部門id  # noqa: E501

        :return: The dept_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._dept_id

    @dept_id.setter
    def dept_id(self, dept_id):
        """Sets the dept_id of this ExTransactionUpdateInput.

        部門id  # noqa: E501

        :param dept_id: The dept_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dept_id is not None and len(dept_id) > 40):
            raise ValueError("Invalid value for `dept_id`, length must be less than or equal to `40`")  # noqa: E501

        self._dept_id = dept_id

    @property
    def project_code_id(self):
        """Gets the project_code_id of this ExTransactionUpdateInput.  # noqa: E501

        プロジェクトid  # noqa: E501

        :return: The project_code_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._project_code_id

    @project_code_id.setter
    def project_code_id(self, project_code_id):
        """Sets the project_code_id of this ExTransactionUpdateInput.

        プロジェクトid  # noqa: E501

        :param project_code_id: The project_code_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                project_code_id is not None and len(project_code_id) > 40):
            raise ValueError("Invalid value for `project_code_id`, length must be less than or equal to `40`")  # noqa: E501

        self._project_code_id = project_code_id

    @property
    def cr_item_id(self):
        """Gets the cr_item_id of this ExTransactionUpdateInput.  # noqa: E501

        貸方勘定科目id  # noqa: E501

        :return: The cr_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._cr_item_id

    @cr_item_id.setter
    def cr_item_id(self, cr_item_id):
        """Sets the cr_item_id of this ExTransactionUpdateInput.

        貸方勘定科目id  # noqa: E501

        :param cr_item_id: The cr_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cr_item_id is not None and len(cr_item_id) > 40):
            raise ValueError("Invalid value for `cr_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cr_item_id = cr_item_id

    @property
    def cr_sub_item_id(self):
        """Gets the cr_sub_item_id of this ExTransactionUpdateInput.  # noqa: E501

        貸方補助科目id  # noqa: E501

        :return: The cr_sub_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :rtype: str
        """
        return self._cr_sub_item_id

    @cr_sub_item_id.setter
    def cr_sub_item_id(self, cr_sub_item_id):
        """Sets the cr_sub_item_id of this ExTransactionUpdateInput.

        貸方補助科目id  # noqa: E501

        :param cr_sub_item_id: The cr_sub_item_id of this ExTransactionUpdateInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cr_sub_item_id is not None and len(cr_sub_item_id) > 40):
            raise ValueError("Invalid value for `cr_sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cr_sub_item_id = cr_sub_item_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExTransactionUpdateInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExTransactionUpdateInput):
            return True

        return self.to_dict() != other.to_dict()
