# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExTransaction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'number': 'int',
        'remark': 'str',
        'recognized_at': 'date',
        'value': 'float',
        'memo': 'str',
        'report_number': 'str',
        'jpyrate': 'float',
        'currency': 'str',
        'use_custom_jpy_rate': 'bool',
        'automatic_status': 'str',
        'error_message': 'str',
        'warning_message': 'str',
        'waiting_message': 'str',
        'office_member_id': 'str',
        'ex_item_id': 'str',
        'dr_excise_id': 'str',
        'dept_id': 'str',
        'project_code_id': 'str',
        'cr_item_id': 'str',
        'cr_sub_item_id': 'str',
        'created_at': 'Datetime',
        'updated_at': 'Datetime',
        'office_member': 'OfficeMember',
        'ex_item': 'ExItem',
        'dr_excise': 'Excise',
        'dept': 'Dept',
        'project_code': 'ProjectCode',
        'ex_report': 'ExReport',
        'ex_report_unit': 'ExReportUnit',
        'mf_file': 'MfFile',
        'attendants': 'list[Attendant]'
    }

    attribute_map = {
        'id': 'id',
        'number': 'number',
        'remark': 'remark',
        'recognized_at': 'recognized_at',
        'value': 'value',
        'memo': 'memo',
        'report_number': 'report_number',
        'jpyrate': 'jpyrate',
        'currency': 'currency',
        'use_custom_jpy_rate': 'use_custom_jpy_rate',
        'automatic_status': 'automatic_status',
        'error_message': 'error_message',
        'warning_message': 'warning_message',
        'waiting_message': 'waiting_message',
        'office_member_id': 'office_member_id',
        'ex_item_id': 'ex_item_id',
        'dr_excise_id': 'dr_excise_id',
        'dept_id': 'dept_id',
        'project_code_id': 'project_code_id',
        'cr_item_id': 'cr_item_id',
        'cr_sub_item_id': 'cr_sub_item_id',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'office_member': 'office_member',
        'ex_item': 'ex_item',
        'dr_excise': 'dr_excise',
        'dept': 'dept',
        'project_code': 'project_code',
        'ex_report': 'ex_report',
        'ex_report_unit': 'ex_report_unit',
        'mf_file': 'mf_file',
        'attendants': 'attendants'
    }

    def __init__(self, id=None, number=None, remark=None, recognized_at=None, value=None, memo=None, report_number=None, jpyrate=None, currency='JPY', use_custom_jpy_rate=False, automatic_status=None, error_message=None, warning_message=None, waiting_message=None, office_member_id=None, ex_item_id=None, dr_excise_id=None, dept_id=None, project_code_id=None, cr_item_id=None, cr_sub_item_id=None, created_at=None, updated_at=None, office_member=None, ex_item=None, dr_excise=None, dept=None, project_code=None, ex_report=None, ex_report_unit=None, mf_file=None, attendants=None, local_vars_configuration=None):  # noqa: E501
        """ExTransaction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._number = None
        self._remark = None
        self._recognized_at = None
        self._value = None
        self._memo = None
        self._report_number = None
        self._jpyrate = None
        self._currency = None
        self._use_custom_jpy_rate = None
        self._automatic_status = None
        self._error_message = None
        self._warning_message = None
        self._waiting_message = None
        self._office_member_id = None
        self._ex_item_id = None
        self._dr_excise_id = None
        self._dept_id = None
        self._project_code_id = None
        self._cr_item_id = None
        self._cr_sub_item_id = None
        self._created_at = None
        self._updated_at = None
        self._office_member = None
        self._ex_item = None
        self._dr_excise = None
        self._dept = None
        self._project_code = None
        self._ex_report = None
        self._ex_report_unit = None
        self._mf_file = None
        self._attendants = None
        self.discriminator = None

        self.id = id
        if number is not None:
            self.number = number
        if remark is not None:
            self.remark = remark
        if recognized_at is not None:
            self.recognized_at = recognized_at
        if value is not None:
            self.value = value
        if memo is not None:
            self.memo = memo
        if report_number is not None:
            self.report_number = report_number
        if jpyrate is not None:
            self.jpyrate = jpyrate
        if currency is not None:
            self.currency = currency
        if use_custom_jpy_rate is not None:
            self.use_custom_jpy_rate = use_custom_jpy_rate
        if automatic_status is not None:
            self.automatic_status = automatic_status
        if error_message is not None:
            self.error_message = error_message
        self.warning_message = warning_message
        self.waiting_message = waiting_message
        if office_member_id is not None:
            self.office_member_id = office_member_id
        if ex_item_id is not None:
            self.ex_item_id = ex_item_id
        if dr_excise_id is not None:
            self.dr_excise_id = dr_excise_id
        if dept_id is not None:
            self.dept_id = dept_id
        if project_code_id is not None:
            self.project_code_id = project_code_id
        if cr_item_id is not None:
            self.cr_item_id = cr_item_id
        self.cr_sub_item_id = cr_sub_item_id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if office_member is not None:
            self.office_member = office_member
        if ex_item is not None:
            self.ex_item = ex_item
        if dr_excise is not None:
            self.dr_excise = dr_excise
        if dept is not None:
            self.dept = dept
        if project_code is not None:
            self.project_code = project_code
        if ex_report is not None:
            self.ex_report = ex_report
        if ex_report_unit is not None:
            self.ex_report_unit = ex_report_unit
        if mf_file is not None:
            self.mf_file = mf_file
        if attendants is not None:
            self.attendants = attendants

    @property
    def id(self):
        """Gets the id of this ExTransaction.  # noqa: E501

        経費明細id  # noqa: E501

        :return: The id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExTransaction.

        経費明細id  # noqa: E501

        :param id: The id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def number(self):
        """Gets the number of this ExTransaction.  # noqa: E501

        明細番号  # noqa: E501

        :return: The number of this ExTransaction.  # noqa: E501
        :rtype: int
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this ExTransaction.

        明細番号  # noqa: E501

        :param number: The number of this ExTransaction.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number > 4294967295):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number < 1):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number = number

    @property
    def remark(self):
        """Gets the remark of this ExTransaction.  # noqa: E501

        支払先・内容  # noqa: E501

        :return: The remark of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._remark

    @remark.setter
    def remark(self, remark):
        """Sets the remark of this ExTransaction.

        支払先・内容  # noqa: E501

        :param remark: The remark of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                remark is not None and len(remark) > 100):
            raise ValueError("Invalid value for `remark`, length must be less than or equal to `100`")  # noqa: E501

        self._remark = remark

    @property
    def recognized_at(self):
        """Gets the recognized_at of this ExTransaction.  # noqa: E501

        日付  # noqa: E501

        :return: The recognized_at of this ExTransaction.  # noqa: E501
        :rtype: date
        """
        return self._recognized_at

    @recognized_at.setter
    def recognized_at(self, recognized_at):
        """Sets the recognized_at of this ExTransaction.

        日付  # noqa: E501

        :param recognized_at: The recognized_at of this ExTransaction.  # noqa: E501
        :type: date
        """

        self._recognized_at = recognized_at

    @property
    def value(self):
        """Gets the value of this ExTransaction.  # noqa: E501

        金額  # noqa: E501

        :return: The value of this ExTransaction.  # noqa: E501
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this ExTransaction.

        金額  # noqa: E501

        :param value: The value of this ExTransaction.  # noqa: E501
        :type: float
        """

        self._value = value

    @property
    def memo(self):
        """Gets the memo of this ExTransaction.  # noqa: E501

        メモ  # noqa: E501

        :return: The memo of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._memo

    @memo.setter
    def memo(self, memo):
        """Sets the memo of this ExTransaction.

        メモ  # noqa: E501

        :param memo: The memo of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                memo is not None and len(memo) > 800):
            raise ValueError("Invalid value for `memo`, length must be less than or equal to `800`")  # noqa: E501

        self._memo = memo

    @property
    def report_number(self):
        """Gets the report_number of this ExTransaction.  # noqa: E501

        事前申請番号  # noqa: E501

        :return: The report_number of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._report_number

    @report_number.setter
    def report_number(self, report_number):
        """Sets the report_number of this ExTransaction.

        事前申請番号  # noqa: E501

        :param report_number: The report_number of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                report_number is not None and len(report_number) > 50):
            raise ValueError("Invalid value for `report_number`, length must be less than or equal to `50`")  # noqa: E501

        self._report_number = report_number

    @property
    def jpyrate(self):
        """Gets the jpyrate of this ExTransaction.  # noqa: E501

        為替レート  # noqa: E501

        :return: The jpyrate of this ExTransaction.  # noqa: E501
        :rtype: float
        """
        return self._jpyrate

    @jpyrate.setter
    def jpyrate(self, jpyrate):
        """Sets the jpyrate of this ExTransaction.

        為替レート  # noqa: E501

        :param jpyrate: The jpyrate of this ExTransaction.  # noqa: E501
        :type: float
        """

        self._jpyrate = jpyrate

    @property
    def currency(self):
        """Gets the currency of this ExTransaction.  # noqa: E501

        通貨  # noqa: E501

        :return: The currency of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this ExTransaction.

        通貨  # noqa: E501

        :param currency: The currency of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) > 3):
            raise ValueError("Invalid value for `currency`, length must be less than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                currency is not None and len(currency) < 3):
            raise ValueError("Invalid value for `currency`, length must be greater than or equal to `3`")  # noqa: E501

        self._currency = currency

    @property
    def use_custom_jpy_rate(self):
        """Gets the use_custom_jpy_rate of this ExTransaction.  # noqa: E501

        為替レートを手動設定するかどうか  # noqa: E501

        :return: The use_custom_jpy_rate of this ExTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._use_custom_jpy_rate

    @use_custom_jpy_rate.setter
    def use_custom_jpy_rate(self, use_custom_jpy_rate):
        """Sets the use_custom_jpy_rate of this ExTransaction.

        為替レートを手動設定するかどうか  # noqa: E501

        :param use_custom_jpy_rate: The use_custom_jpy_rate of this ExTransaction.  # noqa: E501
        :type: bool
        """

        self._use_custom_jpy_rate = use_custom_jpy_rate

    @property
    def automatic_status(self):
        """Gets the automatic_status of this ExTransaction.  # noqa: E501

        manual: 手動登録, waiting_for_ocr_input: OCR処理待ち, waiting_for_streamed_upload: 画像アップロード待ち,  waiting_for_streamed_input: STREAMEDオペレーター入力待ち, waiting_for_input: オペレーター入力待ち, input_done: 入力完了, canceled: キャンセル  # noqa: E501

        :return: The automatic_status of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._automatic_status

    @automatic_status.setter
    def automatic_status(self, automatic_status):
        """Sets the automatic_status of this ExTransaction.

        manual: 手動登録, waiting_for_ocr_input: OCR処理待ち, waiting_for_streamed_upload: 画像アップロード待ち,  waiting_for_streamed_input: STREAMEDオペレーター入力待ち, waiting_for_input: オペレーター入力待ち, input_done: 入力完了, canceled: キャンセル  # noqa: E501

        :param automatic_status: The automatic_status of this ExTransaction.  # noqa: E501
        :type: str
        """
        allowed_values = ["manual", "waiting_for_ocr_input", "waiting_for_streamed_upload", "waiting_for_streamed_input", "waiting_for_input", "input_done", "canceled"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and automatic_status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `automatic_status` ({0}), must be one of {1}"  # noqa: E501
                .format(automatic_status, allowed_values)
            )

        self._automatic_status = automatic_status

    @property
    def error_message(self):
        """Gets the error_message of this ExTransaction.  # noqa: E501

        エラーメッセージ  # noqa: E501

        :return: The error_message of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """Sets the error_message of this ExTransaction.

        エラーメッセージ  # noqa: E501

        :param error_message: The error_message of this ExTransaction.  # noqa: E501
        :type: str
        """

        self._error_message = error_message

    @property
    def warning_message(self):
        """Gets the warning_message of this ExTransaction.  # noqa: E501

        ワーニングメッセージ  # noqa: E501

        :return: The warning_message of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._warning_message

    @warning_message.setter
    def warning_message(self, warning_message):
        """Sets the warning_message of this ExTransaction.

        ワーニングメッセージ  # noqa: E501

        :param warning_message: The warning_message of this ExTransaction.  # noqa: E501
        :type: str
        """

        self._warning_message = warning_message

    @property
    def waiting_message(self):
        """Gets the waiting_message of this ExTransaction.  # noqa: E501

        待機メッセージ  # noqa: E501

        :return: The waiting_message of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._waiting_message

    @waiting_message.setter
    def waiting_message(self, waiting_message):
        """Sets the waiting_message of this ExTransaction.

        待機メッセージ  # noqa: E501

        :param waiting_message: The waiting_message of this ExTransaction.  # noqa: E501
        :type: str
        """

        self._waiting_message = waiting_message

    @property
    def office_member_id(self):
        """Gets the office_member_id of this ExTransaction.  # noqa: E501

        メンバーid  # noqa: E501

        :return: The office_member_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._office_member_id

    @office_member_id.setter
    def office_member_id(self, office_member_id):
        """Sets the office_member_id of this ExTransaction.

        メンバーid  # noqa: E501

        :param office_member_id: The office_member_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office_member_id is not None and len(office_member_id) > 40):
            raise ValueError("Invalid value for `office_member_id`, length must be less than or equal to `40`")  # noqa: E501

        self._office_member_id = office_member_id

    @property
    def ex_item_id(self):
        """Gets the ex_item_id of this ExTransaction.  # noqa: E501

        経費科目id  # noqa: E501

        :return: The ex_item_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._ex_item_id

    @ex_item_id.setter
    def ex_item_id(self, ex_item_id):
        """Sets the ex_item_id of this ExTransaction.

        経費科目id  # noqa: E501

        :param ex_item_id: The ex_item_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                ex_item_id is not None and len(ex_item_id) > 40):
            raise ValueError("Invalid value for `ex_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._ex_item_id = ex_item_id

    @property
    def dr_excise_id(self):
        """Gets the dr_excise_id of this ExTransaction.  # noqa: E501

        税区分id  # noqa: E501

        :return: The dr_excise_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._dr_excise_id

    @dr_excise_id.setter
    def dr_excise_id(self, dr_excise_id):
        """Sets the dr_excise_id of this ExTransaction.

        税区分id  # noqa: E501

        :param dr_excise_id: The dr_excise_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dr_excise_id is not None and len(dr_excise_id) > 40):
            raise ValueError("Invalid value for `dr_excise_id`, length must be less than or equal to `40`")  # noqa: E501

        self._dr_excise_id = dr_excise_id

    @property
    def dept_id(self):
        """Gets the dept_id of this ExTransaction.  # noqa: E501

        部門id  # noqa: E501

        :return: The dept_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._dept_id

    @dept_id.setter
    def dept_id(self, dept_id):
        """Sets the dept_id of this ExTransaction.

        部門id  # noqa: E501

        :param dept_id: The dept_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dept_id is not None and len(dept_id) > 40):
            raise ValueError("Invalid value for `dept_id`, length must be less than or equal to `40`")  # noqa: E501

        self._dept_id = dept_id

    @property
    def project_code_id(self):
        """Gets the project_code_id of this ExTransaction.  # noqa: E501

        プロジェクトid  # noqa: E501

        :return: The project_code_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._project_code_id

    @project_code_id.setter
    def project_code_id(self, project_code_id):
        """Sets the project_code_id of this ExTransaction.

        プロジェクトid  # noqa: E501

        :param project_code_id: The project_code_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                project_code_id is not None and len(project_code_id) > 40):
            raise ValueError("Invalid value for `project_code_id`, length must be less than or equal to `40`")  # noqa: E501

        self._project_code_id = project_code_id

    @property
    def cr_item_id(self):
        """Gets the cr_item_id of this ExTransaction.  # noqa: E501

        貸方勘定科目id  # noqa: E501

        :return: The cr_item_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._cr_item_id

    @cr_item_id.setter
    def cr_item_id(self, cr_item_id):
        """Sets the cr_item_id of this ExTransaction.

        貸方勘定科目id  # noqa: E501

        :param cr_item_id: The cr_item_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cr_item_id is not None and len(cr_item_id) > 40):
            raise ValueError("Invalid value for `cr_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cr_item_id = cr_item_id

    @property
    def cr_sub_item_id(self):
        """Gets the cr_sub_item_id of this ExTransaction.  # noqa: E501

        貸方補助科目id  # noqa: E501

        :return: The cr_sub_item_id of this ExTransaction.  # noqa: E501
        :rtype: str
        """
        return self._cr_sub_item_id

    @cr_sub_item_id.setter
    def cr_sub_item_id(self, cr_sub_item_id):
        """Sets the cr_sub_item_id of this ExTransaction.

        貸方補助科目id  # noqa: E501

        :param cr_sub_item_id: The cr_sub_item_id of this ExTransaction.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                cr_sub_item_id is not None and len(cr_sub_item_id) > 40):
            raise ValueError("Invalid value for `cr_sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._cr_sub_item_id = cr_sub_item_id

    @property
    def created_at(self):
        """Gets the created_at of this ExTransaction.  # noqa: E501

        登録日時  # noqa: E501

        :return: The created_at of this ExTransaction.  # noqa: E501
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ExTransaction.

        登録日時  # noqa: E501

        :param created_at: The created_at of this ExTransaction.  # noqa: E501
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ExTransaction.  # noqa: E501

        更新日時  # noqa: E501

        :return: The updated_at of this ExTransaction.  # noqa: E501
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ExTransaction.

        更新日時  # noqa: E501

        :param updated_at: The updated_at of this ExTransaction.  # noqa: E501
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def office_member(self):
        """Gets the office_member of this ExTransaction.  # noqa: E501


        :return: The office_member of this ExTransaction.  # noqa: E501
        :rtype: OfficeMember
        """
        return self._office_member

    @office_member.setter
    def office_member(self, office_member):
        """Sets the office_member of this ExTransaction.


        :param office_member: The office_member of this ExTransaction.  # noqa: E501
        :type: OfficeMember
        """

        self._office_member = office_member

    @property
    def ex_item(self):
        """Gets the ex_item of this ExTransaction.  # noqa: E501


        :return: The ex_item of this ExTransaction.  # noqa: E501
        :rtype: ExItem
        """
        return self._ex_item

    @ex_item.setter
    def ex_item(self, ex_item):
        """Sets the ex_item of this ExTransaction.


        :param ex_item: The ex_item of this ExTransaction.  # noqa: E501
        :type: ExItem
        """

        self._ex_item = ex_item

    @property
    def dr_excise(self):
        """Gets the dr_excise of this ExTransaction.  # noqa: E501


        :return: The dr_excise of this ExTransaction.  # noqa: E501
        :rtype: Excise
        """
        return self._dr_excise

    @dr_excise.setter
    def dr_excise(self, dr_excise):
        """Sets the dr_excise of this ExTransaction.


        :param dr_excise: The dr_excise of this ExTransaction.  # noqa: E501
        :type: Excise
        """

        self._dr_excise = dr_excise

    @property
    def dept(self):
        """Gets the dept of this ExTransaction.  # noqa: E501


        :return: The dept of this ExTransaction.  # noqa: E501
        :rtype: Dept
        """
        return self._dept

    @dept.setter
    def dept(self, dept):
        """Sets the dept of this ExTransaction.


        :param dept: The dept of this ExTransaction.  # noqa: E501
        :type: Dept
        """

        self._dept = dept

    @property
    def project_code(self):
        """Gets the project_code of this ExTransaction.  # noqa: E501


        :return: The project_code of this ExTransaction.  # noqa: E501
        :rtype: ProjectCode
        """
        return self._project_code

    @project_code.setter
    def project_code(self, project_code):
        """Sets the project_code of this ExTransaction.


        :param project_code: The project_code of this ExTransaction.  # noqa: E501
        :type: ProjectCode
        """

        self._project_code = project_code

    @property
    def ex_report(self):
        """Gets the ex_report of this ExTransaction.  # noqa: E501


        :return: The ex_report of this ExTransaction.  # noqa: E501
        :rtype: ExReport
        """
        return self._ex_report

    @ex_report.setter
    def ex_report(self, ex_report):
        """Sets the ex_report of this ExTransaction.


        :param ex_report: The ex_report of this ExTransaction.  # noqa: E501
        :type: ExReport
        """

        self._ex_report = ex_report

    @property
    def ex_report_unit(self):
        """Gets the ex_report_unit of this ExTransaction.  # noqa: E501


        :return: The ex_report_unit of this ExTransaction.  # noqa: E501
        :rtype: ExReportUnit
        """
        return self._ex_report_unit

    @ex_report_unit.setter
    def ex_report_unit(self, ex_report_unit):
        """Sets the ex_report_unit of this ExTransaction.


        :param ex_report_unit: The ex_report_unit of this ExTransaction.  # noqa: E501
        :type: ExReportUnit
        """

        self._ex_report_unit = ex_report_unit

    @property
    def mf_file(self):
        """Gets the mf_file of this ExTransaction.  # noqa: E501


        :return: The mf_file of this ExTransaction.  # noqa: E501
        :rtype: MfFile
        """
        return self._mf_file

    @mf_file.setter
    def mf_file(self, mf_file):
        """Sets the mf_file of this ExTransaction.


        :param mf_file: The mf_file of this ExTransaction.  # noqa: E501
        :type: MfFile
        """

        self._mf_file = mf_file

    @property
    def attendants(self):
        """Gets the attendants of this ExTransaction.  # noqa: E501


        :return: The attendants of this ExTransaction.  # noqa: E501
        :rtype: list[Attendant]
        """
        return self._attendants

    @attendants.setter
    def attendants(self, attendants):
        """Sets the attendants of this ExTransaction.


        :param attendants: The attendants of this ExTransaction.  # noqa: E501
        :type: list[Attendant]
        """

        self._attendants = attendants

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExTransaction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExTransaction):
            return True

        return self.to_dict() != other.to_dict()
