# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExReportUnit(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'office_id': 'str',
        'number': 'int',
        'title': 'str',
        'payment_date': 'date',
        'created_at': 'Datetime',
        'updated_at': 'Datetime'
    }

    attribute_map = {
        'id': 'id',
        'office_id': 'office_id',
        'number': 'number',
        'title': 'title',
        'payment_date': 'payment_date',
        'created_at': 'created_at',
        'updated_at': 'updated_at'
    }

    def __init__(self, id=None, office_id=None, number=None, title=None, payment_date=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """ExReportUnit - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._office_id = None
        self._number = None
        self._title = None
        self._payment_date = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        self.id = id
        if office_id is not None:
            self.office_id = office_id
        if number is not None:
            self.number = number
        if title is not None:
            self.title = title
        if payment_date is not None:
            self.payment_date = payment_date
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this ExReportUnit.  # noqa: E501

        集計id  # noqa: E501

        :return: The id of this ExReportUnit.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExReportUnit.

        集計id  # noqa: E501

        :param id: The id of this ExReportUnit.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def office_id(self):
        """Gets the office_id of this ExReportUnit.  # noqa: E501

        メンバーid  # noqa: E501

        :return: The office_id of this ExReportUnit.  # noqa: E501
        :rtype: str
        """
        return self._office_id

    @office_id.setter
    def office_id(self, office_id):
        """Sets the office_id of this ExReportUnit.

        メンバーid  # noqa: E501

        :param office_id: The office_id of this ExReportUnit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office_id is not None and len(office_id) > 40):
            raise ValueError("Invalid value for `office_id`, length must be less than or equal to `40`")  # noqa: E501

        self._office_id = office_id

    @property
    def number(self):
        """Gets the number of this ExReportUnit.  # noqa: E501

        集計番号  # noqa: E501

        :return: The number of this ExReportUnit.  # noqa: E501
        :rtype: int
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this ExReportUnit.

        集計番号  # noqa: E501

        :param number: The number of this ExReportUnit.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number > 4294967295):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number < 1):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number = number

    @property
    def title(self):
        """Gets the title of this ExReportUnit.  # noqa: E501

        タイトル  # noqa: E501

        :return: The title of this ExReportUnit.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ExReportUnit.

        タイトル  # noqa: E501

        :param title: The title of this ExReportUnit.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                title is not None and len(title) > 100):
            raise ValueError("Invalid value for `title`, length must be less than or equal to `100`")  # noqa: E501

        self._title = title

    @property
    def payment_date(self):
        """Gets the payment_date of this ExReportUnit.  # noqa: E501

        支払日  # noqa: E501

        :return: The payment_date of this ExReportUnit.  # noqa: E501
        :rtype: date
        """
        return self._payment_date

    @payment_date.setter
    def payment_date(self, payment_date):
        """Sets the payment_date of this ExReportUnit.

        支払日  # noqa: E501

        :param payment_date: The payment_date of this ExReportUnit.  # noqa: E501
        :type: date
        """

        self._payment_date = payment_date

    @property
    def created_at(self):
        """Gets the created_at of this ExReportUnit.  # noqa: E501

        登録日時  # noqa: E501

        :return: The created_at of this ExReportUnit.  # noqa: E501
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ExReportUnit.

        登録日時  # noqa: E501

        :param created_at: The created_at of this ExReportUnit.  # noqa: E501
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ExReportUnit.  # noqa: E501

        更新日時  # noqa: E501

        :return: The updated_at of this ExReportUnit.  # noqa: E501
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ExReportUnit.

        更新日時  # noqa: E501

        :param updated_at: The updated_at of this ExReportUnit.  # noqa: E501
        :type: Datetime
        """

        self._updated_at = updated_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExReportUnit):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExReportUnit):
            return True

        return self.to_dict() != other.to_dict()
