# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExReportApproval(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'step': 'int',
        'is_active': 'bool',
        'approved_at': 'Datetime',
        'approve_office_member': 'OfficeMember'
    }

    attribute_map = {
        'step': 'step',
        'is_active': 'is_active',
        'approved_at': 'approved_at',
        'approve_office_member': 'approve_office_member'
    }

    def __init__(self, step=None, is_active=None, approved_at=None, approve_office_member=None, local_vars_configuration=None):  # noqa: E501
        """ExReportApproval - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._step = None
        self._is_active = None
        self._approved_at = None
        self._approve_office_member = None
        self.discriminator = None

        self.step = step
        self.is_active = is_active
        if approved_at is not None:
            self.approved_at = approved_at
        if approve_office_member is not None:
            self.approve_office_member = approve_office_member

    @property
    def step(self):
        """Gets the step of this ExReportApproval.  # noqa: E501

        承認ステップ  # noqa: E501

        :return: The step of this ExReportApproval.  # noqa: E501
        :rtype: int
        """
        return self._step

    @step.setter
    def step(self, step):
        """Sets the step of this ExReportApproval.

        承認ステップ  # noqa: E501

        :param step: The step of this ExReportApproval.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and step is None:  # noqa: E501
            raise ValueError("Invalid value for `step`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                step is not None and step > 10):  # noqa: E501
            raise ValueError("Invalid value for `step`, must be a value less than or equal to `10`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                step is not None and step < 1):  # noqa: E501
            raise ValueError("Invalid value for `step`, must be a value greater than or equal to `1`")  # noqa: E501

        self._step = step

    @property
    def is_active(self):
        """Gets the is_active of this ExReportApproval.  # noqa: E501

        現在承認待ちかどうか  # noqa: E501

        :return: The is_active of this ExReportApproval.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this ExReportApproval.

        現在承認待ちかどうか  # noqa: E501

        :param is_active: The is_active of this ExReportApproval.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_active is None:  # noqa: E501
            raise ValueError("Invalid value for `is_active`, must not be `None`")  # noqa: E501

        self._is_active = is_active

    @property
    def approved_at(self):
        """Gets the approved_at of this ExReportApproval.  # noqa: E501

        承認時刻  # noqa: E501

        :return: The approved_at of this ExReportApproval.  # noqa: E501
        :rtype: Datetime
        """
        return self._approved_at

    @approved_at.setter
    def approved_at(self, approved_at):
        """Sets the approved_at of this ExReportApproval.

        承認時刻  # noqa: E501

        :param approved_at: The approved_at of this ExReportApproval.  # noqa: E501
        :type: Datetime
        """

        self._approved_at = approved_at

    @property
    def approve_office_member(self):
        """Gets the approve_office_member of this ExReportApproval.  # noqa: E501


        :return: The approve_office_member of this ExReportApproval.  # noqa: E501
        :rtype: OfficeMember
        """
        return self._approve_office_member

    @approve_office_member.setter
    def approve_office_member(self, approve_office_member):
        """Sets the approve_office_member of this ExReportApproval.


        :param approve_office_member: The approve_office_member of this ExReportApproval.  # noqa: E501
        :type: OfficeMember
        """

        self._approve_office_member = approve_office_member

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExReportApproval):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExReportApproval):
            return True

        return self.to_dict() != other.to_dict()
