# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExReport(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'ex_report_type_id': 'str',
        'office_member_id': 'str',
        'number': 'int',
        'title': 'str',
        'submitted_at': 'Datetime',
        'approved_at': 'Datetime',
        'created_at': 'Datetime',
        'updated_at': 'Datetime',
        'status': 'str',
        'ex_report_approvals': 'list[ExReportApproval]'
    }

    attribute_map = {
        'id': 'id',
        'ex_report_type_id': 'ex_report_type_id',
        'office_member_id': 'office_member_id',
        'number': 'number',
        'title': 'title',
        'submitted_at': 'submitted_at',
        'approved_at': 'approved_at',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'status': 'status',
        'ex_report_approvals': 'ex_report_approvals'
    }

    def __init__(self, id=None, ex_report_type_id=None, office_member_id=None, number=None, title=None, submitted_at=None, approved_at=None, created_at=None, updated_at=None, status=None, ex_report_approvals=None, local_vars_configuration=None):  # noqa: E501
        """ExReport - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._ex_report_type_id = None
        self._office_member_id = None
        self._number = None
        self._title = None
        self._submitted_at = None
        self._approved_at = None
        self._created_at = None
        self._updated_at = None
        self._status = None
        self._ex_report_approvals = None
        self.discriminator = None

        self.id = id
        if ex_report_type_id is not None:
            self.ex_report_type_id = ex_report_type_id
        if office_member_id is not None:
            self.office_member_id = office_member_id
        if number is not None:
            self.number = number
        if title is not None:
            self.title = title
        if submitted_at is not None:
            self.submitted_at = submitted_at
        if approved_at is not None:
            self.approved_at = approved_at
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if status is not None:
            self.status = status
        if ex_report_approvals is not None:
            self.ex_report_approvals = ex_report_approvals

    @property
    def id(self):
        """Gets the id of this ExReport.  # noqa: E501

        申請id  # noqa: E501

        :return: The id of this ExReport.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExReport.

        申請id  # noqa: E501

        :param id: The id of this ExReport.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def ex_report_type_id(self):
        """Gets the ex_report_type_id of this ExReport.  # noqa: E501

        申請種類id  # noqa: E501

        :return: The ex_report_type_id of this ExReport.  # noqa: E501
        :rtype: str
        """
        return self._ex_report_type_id

    @ex_report_type_id.setter
    def ex_report_type_id(self, ex_report_type_id):
        """Sets the ex_report_type_id of this ExReport.

        申請種類id  # noqa: E501

        :param ex_report_type_id: The ex_report_type_id of this ExReport.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                ex_report_type_id is not None and len(ex_report_type_id) > 40):
            raise ValueError("Invalid value for `ex_report_type_id`, length must be less than or equal to `40`")  # noqa: E501

        self._ex_report_type_id = ex_report_type_id

    @property
    def office_member_id(self):
        """Gets the office_member_id of this ExReport.  # noqa: E501

        メンバーid  # noqa: E501

        :return: The office_member_id of this ExReport.  # noqa: E501
        :rtype: str
        """
        return self._office_member_id

    @office_member_id.setter
    def office_member_id(self, office_member_id):
        """Sets the office_member_id of this ExReport.

        メンバーid  # noqa: E501

        :param office_member_id: The office_member_id of this ExReport.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office_member_id is not None and len(office_member_id) > 40):
            raise ValueError("Invalid value for `office_member_id`, length must be less than or equal to `40`")  # noqa: E501

        self._office_member_id = office_member_id

    @property
    def number(self):
        """Gets the number of this ExReport.  # noqa: E501

        申請番号  # noqa: E501

        :return: The number of this ExReport.  # noqa: E501
        :rtype: int
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this ExReport.

        申請番号  # noqa: E501

        :param number: The number of this ExReport.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number > 4294967295):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number is not None and number < 1):  # noqa: E501
            raise ValueError("Invalid value for `number`, must be a value greater than or equal to `1`")  # noqa: E501

        self._number = number

    @property
    def title(self):
        """Gets the title of this ExReport.  # noqa: E501

        タイトル  # noqa: E501

        :return: The title of this ExReport.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this ExReport.

        タイトル  # noqa: E501

        :param title: The title of this ExReport.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                title is not None and len(title) > 100):
            raise ValueError("Invalid value for `title`, length must be less than or equal to `100`")  # noqa: E501

        self._title = title

    @property
    def submitted_at(self):
        """Gets the submitted_at of this ExReport.  # noqa: E501

        申請日時  # noqa: E501

        :return: The submitted_at of this ExReport.  # noqa: E501
        :rtype: Datetime
        """
        return self._submitted_at

    @submitted_at.setter
    def submitted_at(self, submitted_at):
        """Sets the submitted_at of this ExReport.

        申請日時  # noqa: E501

        :param submitted_at: The submitted_at of this ExReport.  # noqa: E501
        :type: Datetime
        """

        self._submitted_at = submitted_at

    @property
    def approved_at(self):
        """Gets the approved_at of this ExReport.  # noqa: E501

        承認日時  # noqa: E501

        :return: The approved_at of this ExReport.  # noqa: E501
        :rtype: Datetime
        """
        return self._approved_at

    @approved_at.setter
    def approved_at(self, approved_at):
        """Sets the approved_at of this ExReport.

        承認日時  # noqa: E501

        :param approved_at: The approved_at of this ExReport.  # noqa: E501
        :type: Datetime
        """

        self._approved_at = approved_at

    @property
    def created_at(self):
        """Gets the created_at of this ExReport.  # noqa: E501

        登録日時  # noqa: E501

        :return: The created_at of this ExReport.  # noqa: E501
        :rtype: Datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this ExReport.

        登録日時  # noqa: E501

        :param created_at: The created_at of this ExReport.  # noqa: E501
        :type: Datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this ExReport.  # noqa: E501

        更新日時  # noqa: E501

        :return: The updated_at of this ExReport.  # noqa: E501
        :rtype: Datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this ExReport.

        更新日時  # noqa: E501

        :param updated_at: The updated_at of this ExReport.  # noqa: E501
        :type: Datetime
        """

        self._updated_at = updated_at

    @property
    def status(self):
        """Gets the status of this ExReport.  # noqa: E501

        unsubmitted: 下書き, waiting_step_one: 第一承認待ち, waiting_step_two: 第二承認待ち, waiting_step_three: 第三承認待ち, waiting_step_four: 第四承認待ち, waiting_step_five: 第五承認待ち, approved: 承認済み, paid: 支払済み, canceled: 取消済み, rejected: 却下済み  # noqa: E501

        :return: The status of this ExReport.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this ExReport.

        unsubmitted: 下書き, waiting_step_one: 第一承認待ち, waiting_step_two: 第二承認待ち, waiting_step_three: 第三承認待ち, waiting_step_four: 第四承認待ち, waiting_step_five: 第五承認待ち, approved: 承認済み, paid: 支払済み, canceled: 取消済み, rejected: 却下済み  # noqa: E501

        :param status: The status of this ExReport.  # noqa: E501
        :type: str
        """
        allowed_values = ["unsubmitted", "waiting_step_one", "waiting_step_two", "waiting_step_three", "waiting_step_four", "waiting_step_five", "approved", "paid", "canceled", "rejected"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def ex_report_approvals(self):
        """Gets the ex_report_approvals of this ExReport.  # noqa: E501

        承認レコードリスト  # noqa: E501

        :return: The ex_report_approvals of this ExReport.  # noqa: E501
        :rtype: list[ExReportApproval]
        """
        return self._ex_report_approvals

    @ex_report_approvals.setter
    def ex_report_approvals(self, ex_report_approvals):
        """Sets the ex_report_approvals of this ExReport.

        承認レコードリスト  # noqa: E501

        :param ex_report_approvals: The ex_report_approvals of this ExReport.  # noqa: E501
        :type: list[ExReportApproval]
        """

        self._ex_report_approvals = ex_report_approvals

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExReport):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExReport):
            return True

        return self.to_dict() != other.to_dict()
