# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExOfficeMemberSettingInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'use_agent': 'bool',
        'approving_priority': 'int',
        'id': 'str',
        'default_cr_item_id': 'str',
        'default_cr_sub_item_id': 'str',
        'default_transportation_ex_item_id': 'str',
        'default_driving_expense_ex_item_id': 'str',
        'default_project_code_id': 'str',
        'default_dept_id': 'str'
    }

    attribute_map = {
        'use_agent': 'use_agent',
        'approving_priority': 'approving_priority',
        'id': 'id',
        'default_cr_item_id': 'default_cr_item_id',
        'default_cr_sub_item_id': 'default_cr_sub_item_id',
        'default_transportation_ex_item_id': 'default_transportation_ex_item_id',
        'default_driving_expense_ex_item_id': 'default_driving_expense_ex_item_id',
        'default_project_code_id': 'default_project_code_id',
        'default_dept_id': 'default_dept_id'
    }

    def __init__(self, use_agent=False, approving_priority=None, id=None, default_cr_item_id=None, default_cr_sub_item_id=None, default_transportation_ex_item_id=None, default_driving_expense_ex_item_id=None, default_project_code_id=None, default_dept_id=None, local_vars_configuration=None):  # noqa: E501
        """ExOfficeMemberSettingInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._use_agent = None
        self._approving_priority = None
        self._id = None
        self._default_cr_item_id = None
        self._default_cr_sub_item_id = None
        self._default_transportation_ex_item_id = None
        self._default_driving_expense_ex_item_id = None
        self._default_project_code_id = None
        self._default_dept_id = None
        self.discriminator = None

        if use_agent is not None:
            self.use_agent = use_agent
        if approving_priority is not None:
            self.approving_priority = approving_priority
        if id is not None:
            self.id = id
        if default_cr_item_id is not None:
            self.default_cr_item_id = default_cr_item_id
        if default_cr_sub_item_id is not None:
            self.default_cr_sub_item_id = default_cr_sub_item_id
        if default_transportation_ex_item_id is not None:
            self.default_transportation_ex_item_id = default_transportation_ex_item_id
        if default_driving_expense_ex_item_id is not None:
            self.default_driving_expense_ex_item_id = default_driving_expense_ex_item_id
        if default_project_code_id is not None:
            self.default_project_code_id = default_project_code_id
        if default_dept_id is not None:
            self.default_dept_id = default_dept_id

    @property
    def use_agent(self):
        """Gets the use_agent of this ExOfficeMemberSettingInput.  # noqa: E501

        代理承認オンフラグ  # noqa: E501

        :return: The use_agent of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: bool
        """
        return self._use_agent

    @use_agent.setter
    def use_agent(self, use_agent):
        """Sets the use_agent of this ExOfficeMemberSettingInput.

        代理承認オンフラグ  # noqa: E501

        :param use_agent: The use_agent of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: bool
        """

        self._use_agent = use_agent

    @property
    def approving_priority(self):
        """Gets the approving_priority of this ExOfficeMemberSettingInput.  # noqa: E501

        承認優先順位  # noqa: E501

        :return: The approving_priority of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: int
        """
        return self._approving_priority

    @approving_priority.setter
    def approving_priority(self, approving_priority):
        """Sets the approving_priority of this ExOfficeMemberSettingInput.

        承認優先順位  # noqa: E501

        :param approving_priority: The approving_priority of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                approving_priority is not None and approving_priority < 1):  # noqa: E501
            raise ValueError("Invalid value for `approving_priority`, must be a value greater than or equal to `1`")  # noqa: E501

        self._approving_priority = approving_priority

    @property
    def id(self):
        """Gets the id of this ExOfficeMemberSettingInput.  # noqa: E501

        経費メンバー設定id  # noqa: E501

        :return: The id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExOfficeMemberSettingInput.

        経費メンバー設定id  # noqa: E501

        :param id: The id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def default_cr_item_id(self):
        """Gets the default_cr_item_id of this ExOfficeMemberSettingInput.  # noqa: E501

        立替経費デフォルト貸方科目id  # noqa: E501

        :return: The default_cr_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_cr_item_id

    @default_cr_item_id.setter
    def default_cr_item_id(self, default_cr_item_id):
        """Sets the default_cr_item_id of this ExOfficeMemberSettingInput.

        立替経費デフォルト貸方科目id  # noqa: E501

        :param default_cr_item_id: The default_cr_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_cr_item_id is not None and len(default_cr_item_id) > 40):
            raise ValueError("Invalid value for `default_cr_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_cr_item_id = default_cr_item_id

    @property
    def default_cr_sub_item_id(self):
        """Gets the default_cr_sub_item_id of this ExOfficeMemberSettingInput.  # noqa: E501

        立替経費デフォルト貸方補助科目id  # noqa: E501

        :return: The default_cr_sub_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_cr_sub_item_id

    @default_cr_sub_item_id.setter
    def default_cr_sub_item_id(self, default_cr_sub_item_id):
        """Sets the default_cr_sub_item_id of this ExOfficeMemberSettingInput.

        立替経費デフォルト貸方補助科目id  # noqa: E501

        :param default_cr_sub_item_id: The default_cr_sub_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_cr_sub_item_id is not None and len(default_cr_sub_item_id) > 40):
            raise ValueError("Invalid value for `default_cr_sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_cr_sub_item_id = default_cr_sub_item_id

    @property
    def default_transportation_ex_item_id(self):
        """Gets the default_transportation_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501

        経路から立替経費登録デフォルト経費科目id  # noqa: E501

        :return: The default_transportation_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_transportation_ex_item_id

    @default_transportation_ex_item_id.setter
    def default_transportation_ex_item_id(self, default_transportation_ex_item_id):
        """Sets the default_transportation_ex_item_id of this ExOfficeMemberSettingInput.

        経路から立替経費登録デフォルト経費科目id  # noqa: E501

        :param default_transportation_ex_item_id: The default_transportation_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_transportation_ex_item_id is not None and len(default_transportation_ex_item_id) > 40):
            raise ValueError("Invalid value for `default_transportation_ex_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_transportation_ex_item_id = default_transportation_ex_item_id

    @property
    def default_driving_expense_ex_item_id(self):
        """Gets the default_driving_expense_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501

        移動距離から立替経費登録デフォルト経費科目id  # noqa: E501

        :return: The default_driving_expense_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_driving_expense_ex_item_id

    @default_driving_expense_ex_item_id.setter
    def default_driving_expense_ex_item_id(self, default_driving_expense_ex_item_id):
        """Sets the default_driving_expense_ex_item_id of this ExOfficeMemberSettingInput.

        移動距離から立替経費登録デフォルト経費科目id  # noqa: E501

        :param default_driving_expense_ex_item_id: The default_driving_expense_ex_item_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_driving_expense_ex_item_id is not None and len(default_driving_expense_ex_item_id) > 40):
            raise ValueError("Invalid value for `default_driving_expense_ex_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_driving_expense_ex_item_id = default_driving_expense_ex_item_id

    @property
    def default_project_code_id(self):
        """Gets the default_project_code_id of this ExOfficeMemberSettingInput.  # noqa: E501

        立替経費デフォルトプロジェクトid  # noqa: E501

        :return: The default_project_code_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_project_code_id

    @default_project_code_id.setter
    def default_project_code_id(self, default_project_code_id):
        """Sets the default_project_code_id of this ExOfficeMemberSettingInput.

        立替経費デフォルトプロジェクトid  # noqa: E501

        :param default_project_code_id: The default_project_code_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_project_code_id is not None and len(default_project_code_id) > 40):
            raise ValueError("Invalid value for `default_project_code_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_project_code_id = default_project_code_id

    @property
    def default_dept_id(self):
        """Gets the default_dept_id of this ExOfficeMemberSettingInput.  # noqa: E501

        立替経費デフォルト部門id  # noqa: E501

        :return: The default_dept_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :rtype: str
        """
        return self._default_dept_id

    @default_dept_id.setter
    def default_dept_id(self, default_dept_id):
        """Sets the default_dept_id of this ExOfficeMemberSettingInput.

        立替経費デフォルト部門id  # noqa: E501

        :param default_dept_id: The default_dept_id of this ExOfficeMemberSettingInput.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_dept_id is not None and len(default_dept_id) > 40):
            raise ValueError("Invalid value for `default_dept_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_dept_id = default_dept_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExOfficeMemberSettingInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExOfficeMemberSettingInput):
            return True

        return self.to_dict() != other.to_dict()
