# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExOfficeMemberSetting(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'use_agent': 'bool',
        'approving_priority': 'int',
        'default_cr_item': 'Item',
        'default_cr_sub_item': 'SubItem',
        'default_transportation_ex_item': 'ExItem',
        'default_driving_expense_ex_item': 'ExItem',
        'default_project_code': 'Dept'
    }

    attribute_map = {
        'id': 'id',
        'use_agent': 'use_agent',
        'approving_priority': 'approving_priority',
        'default_cr_item': 'default_cr_item',
        'default_cr_sub_item': 'default_cr_sub_item',
        'default_transportation_ex_item': 'default_transportation_ex_item',
        'default_driving_expense_ex_item': 'default_driving_expense_ex_item',
        'default_project_code': 'default_project_code'
    }

    def __init__(self, id=None, use_agent=False, approving_priority=None, default_cr_item=None, default_cr_sub_item=None, default_transportation_ex_item=None, default_driving_expense_ex_item=None, default_project_code=None, local_vars_configuration=None):  # noqa: E501
        """ExOfficeMemberSetting - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._use_agent = None
        self._approving_priority = None
        self._default_cr_item = None
        self._default_cr_sub_item = None
        self._default_transportation_ex_item = None
        self._default_driving_expense_ex_item = None
        self._default_project_code = None
        self.discriminator = None

        self.id = id
        if use_agent is not None:
            self.use_agent = use_agent
        if approving_priority is not None:
            self.approving_priority = approving_priority
        if default_cr_item is not None:
            self.default_cr_item = default_cr_item
        if default_cr_sub_item is not None:
            self.default_cr_sub_item = default_cr_sub_item
        if default_transportation_ex_item is not None:
            self.default_transportation_ex_item = default_transportation_ex_item
        if default_driving_expense_ex_item is not None:
            self.default_driving_expense_ex_item = default_driving_expense_ex_item
        if default_project_code is not None:
            self.default_project_code = default_project_code

    @property
    def id(self):
        """Gets the id of this ExOfficeMemberSetting.  # noqa: E501

        経費メンバー設定id  # noqa: E501

        :return: The id of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExOfficeMemberSetting.

        経費メンバー設定id  # noqa: E501

        :param id: The id of this ExOfficeMemberSetting.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def use_agent(self):
        """Gets the use_agent of this ExOfficeMemberSetting.  # noqa: E501

        代理承認オンフラグ  # noqa: E501

        :return: The use_agent of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: bool
        """
        return self._use_agent

    @use_agent.setter
    def use_agent(self, use_agent):
        """Sets the use_agent of this ExOfficeMemberSetting.

        代理承認オンフラグ  # noqa: E501

        :param use_agent: The use_agent of this ExOfficeMemberSetting.  # noqa: E501
        :type: bool
        """

        self._use_agent = use_agent

    @property
    def approving_priority(self):
        """Gets the approving_priority of this ExOfficeMemberSetting.  # noqa: E501

        承認優先順位  # noqa: E501

        :return: The approving_priority of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: int
        """
        return self._approving_priority

    @approving_priority.setter
    def approving_priority(self, approving_priority):
        """Sets the approving_priority of this ExOfficeMemberSetting.

        承認優先順位  # noqa: E501

        :param approving_priority: The approving_priority of this ExOfficeMemberSetting.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                approving_priority is not None and approving_priority < 1):  # noqa: E501
            raise ValueError("Invalid value for `approving_priority`, must be a value greater than or equal to `1`")  # noqa: E501

        self._approving_priority = approving_priority

    @property
    def default_cr_item(self):
        """Gets the default_cr_item of this ExOfficeMemberSetting.  # noqa: E501


        :return: The default_cr_item of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: Item
        """
        return self._default_cr_item

    @default_cr_item.setter
    def default_cr_item(self, default_cr_item):
        """Sets the default_cr_item of this ExOfficeMemberSetting.


        :param default_cr_item: The default_cr_item of this ExOfficeMemberSetting.  # noqa: E501
        :type: Item
        """

        self._default_cr_item = default_cr_item

    @property
    def default_cr_sub_item(self):
        """Gets the default_cr_sub_item of this ExOfficeMemberSetting.  # noqa: E501


        :return: The default_cr_sub_item of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: SubItem
        """
        return self._default_cr_sub_item

    @default_cr_sub_item.setter
    def default_cr_sub_item(self, default_cr_sub_item):
        """Sets the default_cr_sub_item of this ExOfficeMemberSetting.


        :param default_cr_sub_item: The default_cr_sub_item of this ExOfficeMemberSetting.  # noqa: E501
        :type: SubItem
        """

        self._default_cr_sub_item = default_cr_sub_item

    @property
    def default_transportation_ex_item(self):
        """Gets the default_transportation_ex_item of this ExOfficeMemberSetting.  # noqa: E501


        :return: The default_transportation_ex_item of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: ExItem
        """
        return self._default_transportation_ex_item

    @default_transportation_ex_item.setter
    def default_transportation_ex_item(self, default_transportation_ex_item):
        """Sets the default_transportation_ex_item of this ExOfficeMemberSetting.


        :param default_transportation_ex_item: The default_transportation_ex_item of this ExOfficeMemberSetting.  # noqa: E501
        :type: ExItem
        """

        self._default_transportation_ex_item = default_transportation_ex_item

    @property
    def default_driving_expense_ex_item(self):
        """Gets the default_driving_expense_ex_item of this ExOfficeMemberSetting.  # noqa: E501


        :return: The default_driving_expense_ex_item of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: ExItem
        """
        return self._default_driving_expense_ex_item

    @default_driving_expense_ex_item.setter
    def default_driving_expense_ex_item(self, default_driving_expense_ex_item):
        """Sets the default_driving_expense_ex_item of this ExOfficeMemberSetting.


        :param default_driving_expense_ex_item: The default_driving_expense_ex_item of this ExOfficeMemberSetting.  # noqa: E501
        :type: ExItem
        """

        self._default_driving_expense_ex_item = default_driving_expense_ex_item

    @property
    def default_project_code(self):
        """Gets the default_project_code of this ExOfficeMemberSetting.  # noqa: E501


        :return: The default_project_code of this ExOfficeMemberSetting.  # noqa: E501
        :rtype: Dept
        """
        return self._default_project_code

    @default_project_code.setter
    def default_project_code(self, default_project_code):
        """Sets the default_project_code of this ExOfficeMemberSetting.


        :param default_project_code: The default_project_code of this ExOfficeMemberSetting.  # noqa: E501
        :type: Dept
        """

        self._default_project_code = default_project_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExOfficeMemberSetting):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExOfficeMemberSetting):
            return True

        return self.to_dict() != other.to_dict()
