# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExJournalBranchSide(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'item_id': 'str',
        'sub_item_id': 'str',
        'excise_id': 'str',
        'dept_id': 'str',
        'project_code_id': 'str',
        'ex_destination_id': 'str',
        'side': 'int',
        'value': 'int',
        'excise_value': 'int',
        'item': 'Item',
        'sub_item': 'Item',
        'excise': 'Excise',
        'dept': 'Dept',
        'project_code': 'ProjectCode',
        'ex_destination': 'ExDestination'
    }

    attribute_map = {
        'item_id': 'item_id',
        'sub_item_id': 'sub_item_id',
        'excise_id': 'excise_id',
        'dept_id': 'dept_id',
        'project_code_id': 'project_code_id',
        'ex_destination_id': 'ex_destination_id',
        'side': 'side',
        'value': 'value',
        'excise_value': 'excise_value',
        'item': 'item',
        'sub_item': 'sub_item',
        'excise': 'excise',
        'dept': 'dept',
        'project_code': 'project_code',
        'ex_destination': 'ex_destination'
    }

    def __init__(self, item_id=None, sub_item_id=None, excise_id=None, dept_id=None, project_code_id=None, ex_destination_id=None, side=None, value=None, excise_value=None, item=None, sub_item=None, excise=None, dept=None, project_code=None, ex_destination=None, local_vars_configuration=None):  # noqa: E501
        """ExJournalBranchSide - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._item_id = None
        self._sub_item_id = None
        self._excise_id = None
        self._dept_id = None
        self._project_code_id = None
        self._ex_destination_id = None
        self._side = None
        self._value = None
        self._excise_value = None
        self._item = None
        self._sub_item = None
        self._excise = None
        self._dept = None
        self._project_code = None
        self._ex_destination = None
        self.discriminator = None

        self.item_id = item_id
        self.sub_item_id = sub_item_id
        self.excise_id = excise_id
        self.dept_id = dept_id
        self.project_code_id = project_code_id
        self.ex_destination_id = ex_destination_id
        if side is not None:
            self.side = side
        if value is not None:
            self.value = value
        if excise_value is not None:
            self.excise_value = excise_value
        if item is not None:
            self.item = item
        if sub_item is not None:
            self.sub_item = sub_item
        if excise is not None:
            self.excise = excise
        if dept is not None:
            self.dept = dept
        if project_code is not None:
            self.project_code = project_code
        if ex_destination is not None:
            self.ex_destination = ex_destination

    @property
    def item_id(self):
        """Gets the item_id of this ExJournalBranchSide.  # noqa: E501

        勘定科目id  # noqa: E501

        :return: The item_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this ExJournalBranchSide.

        勘定科目id  # noqa: E501

        :param item_id: The item_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                item_id is not None and len(item_id) > 40):
            raise ValueError("Invalid value for `item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._item_id = item_id

    @property
    def sub_item_id(self):
        """Gets the sub_item_id of this ExJournalBranchSide.  # noqa: E501

        補助科目id  # noqa: E501

        :return: The sub_item_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._sub_item_id

    @sub_item_id.setter
    def sub_item_id(self, sub_item_id):
        """Sets the sub_item_id of this ExJournalBranchSide.

        補助科目id  # noqa: E501

        :param sub_item_id: The sub_item_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                sub_item_id is not None and len(sub_item_id) > 40):
            raise ValueError("Invalid value for `sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._sub_item_id = sub_item_id

    @property
    def excise_id(self):
        """Gets the excise_id of this ExJournalBranchSide.  # noqa: E501

        税区分id  # noqa: E501

        :return: The excise_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._excise_id

    @excise_id.setter
    def excise_id(self, excise_id):
        """Sets the excise_id of this ExJournalBranchSide.

        税区分id  # noqa: E501

        :param excise_id: The excise_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                excise_id is not None and len(excise_id) > 40):
            raise ValueError("Invalid value for `excise_id`, length must be less than or equal to `40`")  # noqa: E501

        self._excise_id = excise_id

    @property
    def dept_id(self):
        """Gets the dept_id of this ExJournalBranchSide.  # noqa: E501

        部門id  # noqa: E501

        :return: The dept_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._dept_id

    @dept_id.setter
    def dept_id(self, dept_id):
        """Sets the dept_id of this ExJournalBranchSide.

        部門id  # noqa: E501

        :param dept_id: The dept_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                dept_id is not None and len(dept_id) > 40):
            raise ValueError("Invalid value for `dept_id`, length must be less than or equal to `40`")  # noqa: E501

        self._dept_id = dept_id

    @property
    def project_code_id(self):
        """Gets the project_code_id of this ExJournalBranchSide.  # noqa: E501

        プロジェクトid  # noqa: E501

        :return: The project_code_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._project_code_id

    @project_code_id.setter
    def project_code_id(self, project_code_id):
        """Sets the project_code_id of this ExJournalBranchSide.

        プロジェクトid  # noqa: E501

        :param project_code_id: The project_code_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                project_code_id is not None and len(project_code_id) > 40):
            raise ValueError("Invalid value for `project_code_id`, length must be less than or equal to `40`")  # noqa: E501

        self._project_code_id = project_code_id

    @property
    def ex_destination_id(self):
        """Gets the ex_destination_id of this ExJournalBranchSide.  # noqa: E501

        支払先id  # noqa: E501

        :return: The ex_destination_id of this ExJournalBranchSide.  # noqa: E501
        :rtype: str
        """
        return self._ex_destination_id

    @ex_destination_id.setter
    def ex_destination_id(self, ex_destination_id):
        """Sets the ex_destination_id of this ExJournalBranchSide.

        支払先id  # noqa: E501

        :param ex_destination_id: The ex_destination_id of this ExJournalBranchSide.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                ex_destination_id is not None and len(ex_destination_id) > 40):
            raise ValueError("Invalid value for `ex_destination_id`, length must be less than or equal to `40`")  # noqa: E501

        self._ex_destination_id = ex_destination_id

    @property
    def side(self):
        """Gets the side of this ExJournalBranchSide.  # noqa: E501

        借方:1, 貸方:-1  # noqa: E501

        :return: The side of this ExJournalBranchSide.  # noqa: E501
        :rtype: int
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this ExJournalBranchSide.

        借方:1, 貸方:-1  # noqa: E501

        :param side: The side of this ExJournalBranchSide.  # noqa: E501
        :type: int
        """
        allowed_values = [1, -1]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and side not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}"  # noqa: E501
                .format(side, allowed_values)
            )

        self._side = side

    @property
    def value(self):
        """Gets the value of this ExJournalBranchSide.  # noqa: E501

        金額  # noqa: E501

        :return: The value of this ExJournalBranchSide.  # noqa: E501
        :rtype: int
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this ExJournalBranchSide.

        金額  # noqa: E501

        :param value: The value of this ExJournalBranchSide.  # noqa: E501
        :type: int
        """

        self._value = value

    @property
    def excise_value(self):
        """Gets the excise_value of this ExJournalBranchSide.  # noqa: E501

        消費税額  # noqa: E501

        :return: The excise_value of this ExJournalBranchSide.  # noqa: E501
        :rtype: int
        """
        return self._excise_value

    @excise_value.setter
    def excise_value(self, excise_value):
        """Sets the excise_value of this ExJournalBranchSide.

        消費税額  # noqa: E501

        :param excise_value: The excise_value of this ExJournalBranchSide.  # noqa: E501
        :type: int
        """

        self._excise_value = excise_value

    @property
    def item(self):
        """Gets the item of this ExJournalBranchSide.  # noqa: E501


        :return: The item of this ExJournalBranchSide.  # noqa: E501
        :rtype: Item
        """
        return self._item

    @item.setter
    def item(self, item):
        """Sets the item of this ExJournalBranchSide.


        :param item: The item of this ExJournalBranchSide.  # noqa: E501
        :type: Item
        """

        self._item = item

    @property
    def sub_item(self):
        """Gets the sub_item of this ExJournalBranchSide.  # noqa: E501


        :return: The sub_item of this ExJournalBranchSide.  # noqa: E501
        :rtype: Item
        """
        return self._sub_item

    @sub_item.setter
    def sub_item(self, sub_item):
        """Sets the sub_item of this ExJournalBranchSide.


        :param sub_item: The sub_item of this ExJournalBranchSide.  # noqa: E501
        :type: Item
        """

        self._sub_item = sub_item

    @property
    def excise(self):
        """Gets the excise of this ExJournalBranchSide.  # noqa: E501


        :return: The excise of this ExJournalBranchSide.  # noqa: E501
        :rtype: Excise
        """
        return self._excise

    @excise.setter
    def excise(self, excise):
        """Sets the excise of this ExJournalBranchSide.


        :param excise: The excise of this ExJournalBranchSide.  # noqa: E501
        :type: Excise
        """

        self._excise = excise

    @property
    def dept(self):
        """Gets the dept of this ExJournalBranchSide.  # noqa: E501


        :return: The dept of this ExJournalBranchSide.  # noqa: E501
        :rtype: Dept
        """
        return self._dept

    @dept.setter
    def dept(self, dept):
        """Sets the dept of this ExJournalBranchSide.


        :param dept: The dept of this ExJournalBranchSide.  # noqa: E501
        :type: Dept
        """

        self._dept = dept

    @property
    def project_code(self):
        """Gets the project_code of this ExJournalBranchSide.  # noqa: E501


        :return: The project_code of this ExJournalBranchSide.  # noqa: E501
        :rtype: ProjectCode
        """
        return self._project_code

    @project_code.setter
    def project_code(self, project_code):
        """Sets the project_code of this ExJournalBranchSide.


        :param project_code: The project_code of this ExJournalBranchSide.  # noqa: E501
        :type: ProjectCode
        """

        self._project_code = project_code

    @property
    def ex_destination(self):
        """Gets the ex_destination of this ExJournalBranchSide.  # noqa: E501


        :return: The ex_destination of this ExJournalBranchSide.  # noqa: E501
        :rtype: ExDestination
        """
        return self._ex_destination

    @ex_destination.setter
    def ex_destination(self, ex_destination):
        """Sets the ex_destination of this ExJournalBranchSide.


        :param ex_destination: The ex_destination of this ExJournalBranchSide.  # noqa: E501
        :type: ExDestination
        """

        self._ex_destination = ex_destination

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExJournalBranchSide):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExJournalBranchSide):
            return True

        return self.to_dict() != other.to_dict()
