# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExJournal(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'office_id': 'str',
        'recognized_at': 'date',
        'memo': 'str',
        'ex_journal_branches': 'list[ExJournalBranch]'
    }

    attribute_map = {
        'office_id': 'office_id',
        'recognized_at': 'recognized_at',
        'memo': 'memo',
        'ex_journal_branches': 'ex_journal_branches'
    }

    def __init__(self, office_id=None, recognized_at=None, memo=None, ex_journal_branches=None, local_vars_configuration=None):  # noqa: E501
        """ExJournal - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._office_id = None
        self._recognized_at = None
        self._memo = None
        self._ex_journal_branches = None
        self.discriminator = None

        if office_id is not None:
            self.office_id = office_id
        self.recognized_at = recognized_at
        self.memo = memo
        if ex_journal_branches is not None:
            self.ex_journal_branches = ex_journal_branches

    @property
    def office_id(self):
        """Gets the office_id of this ExJournal.  # noqa: E501

        事業所id  # noqa: E501

        :return: The office_id of this ExJournal.  # noqa: E501
        :rtype: str
        """
        return self._office_id

    @office_id.setter
    def office_id(self, office_id):
        """Sets the office_id of this ExJournal.

        事業所id  # noqa: E501

        :param office_id: The office_id of this ExJournal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                office_id is not None and len(office_id) > 40):
            raise ValueError("Invalid value for `office_id`, length must be less than or equal to `40`")  # noqa: E501

        self._office_id = office_id

    @property
    def recognized_at(self):
        """Gets the recognized_at of this ExJournal.  # noqa: E501

        取引日  # noqa: E501

        :return: The recognized_at of this ExJournal.  # noqa: E501
        :rtype: date
        """
        return self._recognized_at

    @recognized_at.setter
    def recognized_at(self, recognized_at):
        """Sets the recognized_at of this ExJournal.

        取引日  # noqa: E501

        :param recognized_at: The recognized_at of this ExJournal.  # noqa: E501
        :type: date
        """

        self._recognized_at = recognized_at

    @property
    def memo(self):
        """Gets the memo of this ExJournal.  # noqa: E501

        メモ  # noqa: E501

        :return: The memo of this ExJournal.  # noqa: E501
        :rtype: str
        """
        return self._memo

    @memo.setter
    def memo(self, memo):
        """Sets the memo of this ExJournal.

        メモ  # noqa: E501

        :param memo: The memo of this ExJournal.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                memo is not None and len(memo) > 1000):
            raise ValueError("Invalid value for `memo`, length must be less than or equal to `1000`")  # noqa: E501

        self._memo = memo

    @property
    def ex_journal_branches(self):
        """Gets the ex_journal_branches of this ExJournal.  # noqa: E501

        仕訳行  # noqa: E501

        :return: The ex_journal_branches of this ExJournal.  # noqa: E501
        :rtype: list[ExJournalBranch]
        """
        return self._ex_journal_branches

    @ex_journal_branches.setter
    def ex_journal_branches(self, ex_journal_branches):
        """Sets the ex_journal_branches of this ExJournal.

        仕訳行  # noqa: E501

        :param ex_journal_branches: The ex_journal_branches of this ExJournal.  # noqa: E501
        :type: list[ExJournalBranch]
        """

        self._ex_journal_branches = ex_journal_branches

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExJournal):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExJournal):
            return True

        return self.to_dict() != other.to_dict()
