# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'code': 'str',
        'is_active': 'bool',
        'item_id': 'str',
        'sub_item_id': 'str',
        'default_excise_id': 'str',
        'item': 'Item',
        'sub_item': 'SubItem',
        'default_dr_excise': 'Excise'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'code': 'code',
        'is_active': 'is_active',
        'item_id': 'item_id',
        'sub_item_id': 'sub_item_id',
        'default_excise_id': 'default_excise_id',
        'item': 'item',
        'sub_item': 'sub_item',
        'default_dr_excise': 'default_dr_excise'
    }

    def __init__(self, id=None, name=None, code=None, is_active=True, item_id=None, sub_item_id=None, default_excise_id=None, item=None, sub_item=None, default_dr_excise=None, local_vars_configuration=None):  # noqa: E501
        """ExItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._code = None
        self._is_active = None
        self._item_id = None
        self._sub_item_id = None
        self._default_excise_id = None
        self._item = None
        self._sub_item = None
        self._default_dr_excise = None
        self.discriminator = None

        self.id = id
        if name is not None:
            self.name = name
        if code is not None:
            self.code = code
        if is_active is not None:
            self.is_active = is_active
        if item_id is not None:
            self.item_id = item_id
        if sub_item_id is not None:
            self.sub_item_id = sub_item_id
        if default_excise_id is not None:
            self.default_excise_id = default_excise_id
        if item is not None:
            self.item = item
        if sub_item is not None:
            self.sub_item = sub_item
        if default_dr_excise is not None:
            self.default_dr_excise = default_dr_excise

    @property
    def id(self):
        """Gets the id of this ExItem.  # noqa: E501

        経費科目id  # noqa: E501

        :return: The id of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExItem.

        経費科目id  # noqa: E501

        :param id: The id of this ExItem.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this ExItem.  # noqa: E501

        経費科目名称  # noqa: E501

        :return: The name of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ExItem.

        経費科目名称  # noqa: E501

        :param name: The name of this ExItem.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 40):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `40`")  # noqa: E501

        self._name = name

    @property
    def code(self):
        """Gets the code of this ExItem.  # noqa: E501

        コード  # noqa: E501

        :return: The code of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this ExItem.

        コード  # noqa: E501

        :param code: The code of this ExItem.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                code is not None and len(code) > 50):
            raise ValueError("Invalid value for `code`, length must be less than or equal to `50`")  # noqa: E501

        self._code = code

    @property
    def is_active(self):
        """Gets the is_active of this ExItem.  # noqa: E501

        利用可否フラグ。新規の経費登録等で利用できるかどうかを表す。  # noqa: E501

        :return: The is_active of this ExItem.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this ExItem.

        利用可否フラグ。新規の経費登録等で利用できるかどうかを表す。  # noqa: E501

        :param is_active: The is_active of this ExItem.  # noqa: E501
        :type: bool
        """

        self._is_active = is_active

    @property
    def item_id(self):
        """Gets the item_id of this ExItem.  # noqa: E501

        勘定科目id  # noqa: E501

        :return: The item_id of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this ExItem.

        勘定科目id  # noqa: E501

        :param item_id: The item_id of this ExItem.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                item_id is not None and len(item_id) > 40):
            raise ValueError("Invalid value for `item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._item_id = item_id

    @property
    def sub_item_id(self):
        """Gets the sub_item_id of this ExItem.  # noqa: E501

        補助科目id  # noqa: E501

        :return: The sub_item_id of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._sub_item_id

    @sub_item_id.setter
    def sub_item_id(self, sub_item_id):
        """Sets the sub_item_id of this ExItem.

        補助科目id  # noqa: E501

        :param sub_item_id: The sub_item_id of this ExItem.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                sub_item_id is not None and len(sub_item_id) > 40):
            raise ValueError("Invalid value for `sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._sub_item_id = sub_item_id

    @property
    def default_excise_id(self):
        """Gets the default_excise_id of this ExItem.  # noqa: E501

        デフォルト税区分id  # noqa: E501

        :return: The default_excise_id of this ExItem.  # noqa: E501
        :rtype: str
        """
        return self._default_excise_id

    @default_excise_id.setter
    def default_excise_id(self, default_excise_id):
        """Sets the default_excise_id of this ExItem.

        デフォルト税区分id  # noqa: E501

        :param default_excise_id: The default_excise_id of this ExItem.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_excise_id is not None and len(default_excise_id) > 40):
            raise ValueError("Invalid value for `default_excise_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_excise_id = default_excise_id

    @property
    def item(self):
        """Gets the item of this ExItem.  # noqa: E501


        :return: The item of this ExItem.  # noqa: E501
        :rtype: Item
        """
        return self._item

    @item.setter
    def item(self, item):
        """Sets the item of this ExItem.


        :param item: The item of this ExItem.  # noqa: E501
        :type: Item
        """

        self._item = item

    @property
    def sub_item(self):
        """Gets the sub_item of this ExItem.  # noqa: E501


        :return: The sub_item of this ExItem.  # noqa: E501
        :rtype: SubItem
        """
        return self._sub_item

    @sub_item.setter
    def sub_item(self, sub_item):
        """Sets the sub_item of this ExItem.


        :param sub_item: The sub_item of this ExItem.  # noqa: E501
        :type: SubItem
        """

        self._sub_item = sub_item

    @property
    def default_dr_excise(self):
        """Gets the default_dr_excise of this ExItem.  # noqa: E501


        :return: The default_dr_excise of this ExItem.  # noqa: E501
        :rtype: Excise
        """
        return self._default_dr_excise

    @default_dr_excise.setter
    def default_dr_excise(self, default_dr_excise):
        """Sets the default_dr_excise of this ExItem.


        :param default_dr_excise: The default_dr_excise of this ExItem.  # noqa: E501
        :type: Excise
        """

        self._default_dr_excise = default_dr_excise

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExItem):
            return True

        return self.to_dict() != other.to_dict()
