# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class ExDestination(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'code': 'str',
        'pay_day': 'int',
        'number_of_months_later': 'int',
        'exclude_holiday_kind': 'int',
        'is_withholding_tax': 'bool',
        'default_ex_item_id': 'str',
        'default_cr_item_id': 'str',
        'default_cr_sub_item_id': 'str',
        'default_dept_id': 'str',
        'default_project_code_id': 'str',
        'withholding_tax_cr_item_id': 'str',
        'withholding_tax_cr_sub_item_id': 'str',
        'is_tax_include': 'bool',
        'is_active': 'bool',
        'priority': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'code': 'code',
        'pay_day': 'pay_day',
        'number_of_months_later': 'number_of_months_later',
        'exclude_holiday_kind': 'exclude_holiday_kind',
        'is_withholding_tax': 'is_withholding_tax',
        'default_ex_item_id': 'default_ex_item_id',
        'default_cr_item_id': 'default_cr_item_id',
        'default_cr_sub_item_id': 'default_cr_sub_item_id',
        'default_dept_id': 'default_dept_id',
        'default_project_code_id': 'default_project_code_id',
        'withholding_tax_cr_item_id': 'withholding_tax_cr_item_id',
        'withholding_tax_cr_sub_item_id': 'withholding_tax_cr_sub_item_id',
        'is_tax_include': 'is_tax_include',
        'is_active': 'is_active',
        'priority': 'priority'
    }

    def __init__(self, id=None, name=None, code=None, pay_day=None, number_of_months_later=None, exclude_holiday_kind=None, is_withholding_tax=False, default_ex_item_id=None, default_cr_item_id=None, default_cr_sub_item_id=None, default_dept_id=None, default_project_code_id=None, withholding_tax_cr_item_id=None, withholding_tax_cr_sub_item_id=None, is_tax_include=False, is_active=True, priority=100, local_vars_configuration=None):  # noqa: E501
        """ExDestination - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._code = None
        self._pay_day = None
        self._number_of_months_later = None
        self._exclude_holiday_kind = None
        self._is_withholding_tax = None
        self._default_ex_item_id = None
        self._default_cr_item_id = None
        self._default_cr_sub_item_id = None
        self._default_dept_id = None
        self._default_project_code_id = None
        self._withholding_tax_cr_item_id = None
        self._withholding_tax_cr_sub_item_id = None
        self._is_tax_include = None
        self._is_active = None
        self._priority = None
        self.discriminator = None

        self.id = id
        self.name = name
        if code is not None:
            self.code = code
        self.pay_day = pay_day
        self.number_of_months_later = number_of_months_later
        self.exclude_holiday_kind = exclude_holiday_kind
        self.is_withholding_tax = is_withholding_tax
        if default_ex_item_id is not None:
            self.default_ex_item_id = default_ex_item_id
        if default_cr_item_id is not None:
            self.default_cr_item_id = default_cr_item_id
        if default_cr_sub_item_id is not None:
            self.default_cr_sub_item_id = default_cr_sub_item_id
        if default_dept_id is not None:
            self.default_dept_id = default_dept_id
        if default_project_code_id is not None:
            self.default_project_code_id = default_project_code_id
        if withholding_tax_cr_item_id is not None:
            self.withholding_tax_cr_item_id = withholding_tax_cr_item_id
        if withholding_tax_cr_sub_item_id is not None:
            self.withholding_tax_cr_sub_item_id = withholding_tax_cr_sub_item_id
        if is_tax_include is not None:
            self.is_tax_include = is_tax_include
        self.is_active = is_active
        self.priority = priority

    @property
    def id(self):
        """Gets the id of this ExDestination.  # noqa: E501

        支配先id  # noqa: E501

        :return: The id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ExDestination.

        支配先id  # noqa: E501

        :param id: The id of this ExDestination.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this ExDestination.  # noqa: E501

        名称  # noqa: E501

        :return: The name of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ExDestination.

        名称  # noqa: E501

        :param name: The name of this ExDestination.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 40):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `40`")  # noqa: E501

        self._name = name

    @property
    def code(self):
        """Gets the code of this ExDestination.  # noqa: E501

        支払先コード  # noqa: E501

        :return: The code of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this ExDestination.

        支払先コード  # noqa: E501

        :param code: The code of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                code is not None and len(code) > 50):
            raise ValueError("Invalid value for `code`, length must be less than or equal to `50`")  # noqa: E501

        self._code = code

    @property
    def pay_day(self):
        """Gets the pay_day of this ExDestination.  # noqa: E501

        支払日（月末は31）  # noqa: E501

        :return: The pay_day of this ExDestination.  # noqa: E501
        :rtype: int
        """
        return self._pay_day

    @pay_day.setter
    def pay_day(self, pay_day):
        """Sets the pay_day of this ExDestination.

        支払日（月末は31）  # noqa: E501

        :param pay_day: The pay_day of this ExDestination.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and pay_day is None:  # noqa: E501
            raise ValueError("Invalid value for `pay_day`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                pay_day is not None and pay_day > 31):  # noqa: E501
            raise ValueError("Invalid value for `pay_day`, must be a value less than or equal to `31`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                pay_day is not None and pay_day < 1):  # noqa: E501
            raise ValueError("Invalid value for `pay_day`, must be a value greater than or equal to `1`")  # noqa: E501

        self._pay_day = pay_day

    @property
    def number_of_months_later(self):
        """Gets the number_of_months_later of this ExDestination.  # noqa: E501

        支払が通常請求書を受け取ったタイミングから何ヶ月後か  # noqa: E501

        :return: The number_of_months_later of this ExDestination.  # noqa: E501
        :rtype: int
        """
        return self._number_of_months_later

    @number_of_months_later.setter
    def number_of_months_later(self, number_of_months_later):
        """Sets the number_of_months_later of this ExDestination.

        支払が通常請求書を受け取ったタイミングから何ヶ月後か  # noqa: E501

        :param number_of_months_later: The number_of_months_later of this ExDestination.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and number_of_months_later is None:  # noqa: E501
            raise ValueError("Invalid value for `number_of_months_later`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_of_months_later is not None and number_of_months_later > 3):  # noqa: E501
            raise ValueError("Invalid value for `number_of_months_later`, must be a value less than or equal to `3`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                number_of_months_later is not None and number_of_months_later < 0):  # noqa: E501
            raise ValueError("Invalid value for `number_of_months_later`, must be a value greater than or equal to `0`")  # noqa: E501

        self._number_of_months_later = number_of_months_later

    @property
    def exclude_holiday_kind(self):
        """Gets the exclude_holiday_kind of this ExDestination.  # noqa: E501

        休日調整（0:調整しない, 1:前倒し, 2:後ろ倒し  # noqa: E501

        :return: The exclude_holiday_kind of this ExDestination.  # noqa: E501
        :rtype: int
        """
        return self._exclude_holiday_kind

    @exclude_holiday_kind.setter
    def exclude_holiday_kind(self, exclude_holiday_kind):
        """Sets the exclude_holiday_kind of this ExDestination.

        休日調整（0:調整しない, 1:前倒し, 2:後ろ倒し  # noqa: E501

        :param exclude_holiday_kind: The exclude_holiday_kind of this ExDestination.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and exclude_holiday_kind is None:  # noqa: E501
            raise ValueError("Invalid value for `exclude_holiday_kind`, must not be `None`")  # noqa: E501
        allowed_values = [0, 1, 2]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and exclude_holiday_kind not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `exclude_holiday_kind` ({0}), must be one of {1}"  # noqa: E501
                .format(exclude_holiday_kind, allowed_values)
            )

        self._exclude_holiday_kind = exclude_holiday_kind

    @property
    def is_withholding_tax(self):
        """Gets the is_withholding_tax of this ExDestination.  # noqa: E501

        源泉徴収対象支払先かどうか  # noqa: E501

        :return: The is_withholding_tax of this ExDestination.  # noqa: E501
        :rtype: bool
        """
        return self._is_withholding_tax

    @is_withholding_tax.setter
    def is_withholding_tax(self, is_withholding_tax):
        """Sets the is_withholding_tax of this ExDestination.

        源泉徴収対象支払先かどうか  # noqa: E501

        :param is_withholding_tax: The is_withholding_tax of this ExDestination.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_withholding_tax is None:  # noqa: E501
            raise ValueError("Invalid value for `is_withholding_tax`, must not be `None`")  # noqa: E501

        self._is_withholding_tax = is_withholding_tax

    @property
    def default_ex_item_id(self):
        """Gets the default_ex_item_id of this ExDestination.  # noqa: E501

        デフォルト経費科目id  # noqa: E501

        :return: The default_ex_item_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._default_ex_item_id

    @default_ex_item_id.setter
    def default_ex_item_id(self, default_ex_item_id):
        """Sets the default_ex_item_id of this ExDestination.

        デフォルト経費科目id  # noqa: E501

        :param default_ex_item_id: The default_ex_item_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_ex_item_id is not None and len(default_ex_item_id) > 40):
            raise ValueError("Invalid value for `default_ex_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_ex_item_id = default_ex_item_id

    @property
    def default_cr_item_id(self):
        """Gets the default_cr_item_id of this ExDestination.  # noqa: E501

        デフォルト貸方科目id  # noqa: E501

        :return: The default_cr_item_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._default_cr_item_id

    @default_cr_item_id.setter
    def default_cr_item_id(self, default_cr_item_id):
        """Sets the default_cr_item_id of this ExDestination.

        デフォルト貸方科目id  # noqa: E501

        :param default_cr_item_id: The default_cr_item_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_cr_item_id is not None and len(default_cr_item_id) > 40):
            raise ValueError("Invalid value for `default_cr_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_cr_item_id = default_cr_item_id

    @property
    def default_cr_sub_item_id(self):
        """Gets the default_cr_sub_item_id of this ExDestination.  # noqa: E501

        デフォルト貸方補助科目id  # noqa: E501

        :return: The default_cr_sub_item_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._default_cr_sub_item_id

    @default_cr_sub_item_id.setter
    def default_cr_sub_item_id(self, default_cr_sub_item_id):
        """Sets the default_cr_sub_item_id of this ExDestination.

        デフォルト貸方補助科目id  # noqa: E501

        :param default_cr_sub_item_id: The default_cr_sub_item_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_cr_sub_item_id is not None and len(default_cr_sub_item_id) > 40):
            raise ValueError("Invalid value for `default_cr_sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_cr_sub_item_id = default_cr_sub_item_id

    @property
    def default_dept_id(self):
        """Gets the default_dept_id of this ExDestination.  # noqa: E501

        デフォルト部門id  # noqa: E501

        :return: The default_dept_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._default_dept_id

    @default_dept_id.setter
    def default_dept_id(self, default_dept_id):
        """Sets the default_dept_id of this ExDestination.

        デフォルト部門id  # noqa: E501

        :param default_dept_id: The default_dept_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_dept_id is not None and len(default_dept_id) > 40):
            raise ValueError("Invalid value for `default_dept_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_dept_id = default_dept_id

    @property
    def default_project_code_id(self):
        """Gets the default_project_code_id of this ExDestination.  # noqa: E501

        デフォルトプロジェクトid  # noqa: E501

        :return: The default_project_code_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._default_project_code_id

    @default_project_code_id.setter
    def default_project_code_id(self, default_project_code_id):
        """Sets the default_project_code_id of this ExDestination.

        デフォルトプロジェクトid  # noqa: E501

        :param default_project_code_id: The default_project_code_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                default_project_code_id is not None and len(default_project_code_id) > 40):
            raise ValueError("Invalid value for `default_project_code_id`, length must be less than or equal to `40`")  # noqa: E501

        self._default_project_code_id = default_project_code_id

    @property
    def withholding_tax_cr_item_id(self):
        """Gets the withholding_tax_cr_item_id of this ExDestination.  # noqa: E501

        デフォルト源泉徴収用貸方科目id  # noqa: E501

        :return: The withholding_tax_cr_item_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._withholding_tax_cr_item_id

    @withholding_tax_cr_item_id.setter
    def withholding_tax_cr_item_id(self, withholding_tax_cr_item_id):
        """Sets the withholding_tax_cr_item_id of this ExDestination.

        デフォルト源泉徴収用貸方科目id  # noqa: E501

        :param withholding_tax_cr_item_id: The withholding_tax_cr_item_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                withholding_tax_cr_item_id is not None and len(withholding_tax_cr_item_id) > 40):
            raise ValueError("Invalid value for `withholding_tax_cr_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._withholding_tax_cr_item_id = withholding_tax_cr_item_id

    @property
    def withholding_tax_cr_sub_item_id(self):
        """Gets the withholding_tax_cr_sub_item_id of this ExDestination.  # noqa: E501

        デフォルト源泉徴収用貸方補助科目id  # noqa: E501

        :return: The withholding_tax_cr_sub_item_id of this ExDestination.  # noqa: E501
        :rtype: str
        """
        return self._withholding_tax_cr_sub_item_id

    @withholding_tax_cr_sub_item_id.setter
    def withholding_tax_cr_sub_item_id(self, withholding_tax_cr_sub_item_id):
        """Sets the withholding_tax_cr_sub_item_id of this ExDestination.

        デフォルト源泉徴収用貸方補助科目id  # noqa: E501

        :param withholding_tax_cr_sub_item_id: The withholding_tax_cr_sub_item_id of this ExDestination.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                withholding_tax_cr_sub_item_id is not None and len(withholding_tax_cr_sub_item_id) > 40):
            raise ValueError("Invalid value for `withholding_tax_cr_sub_item_id`, length must be less than or equal to `40`")  # noqa: E501

        self._withholding_tax_cr_sub_item_id = withholding_tax_cr_sub_item_id

    @property
    def is_tax_include(self):
        """Gets the is_tax_include of this ExDestination.  # noqa: E501

        税込入力フラグ  # noqa: E501

        :return: The is_tax_include of this ExDestination.  # noqa: E501
        :rtype: bool
        """
        return self._is_tax_include

    @is_tax_include.setter
    def is_tax_include(self, is_tax_include):
        """Sets the is_tax_include of this ExDestination.

        税込入力フラグ  # noqa: E501

        :param is_tax_include: The is_tax_include of this ExDestination.  # noqa: E501
        :type: bool
        """

        self._is_tax_include = is_tax_include

    @property
    def is_active(self):
        """Gets the is_active of this ExDestination.  # noqa: E501

        表示フラグ。オフで新規の登録等の選択肢に表示されなくなります  # noqa: E501

        :return: The is_active of this ExDestination.  # noqa: E501
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active):
        """Sets the is_active of this ExDestination.

        表示フラグ。オフで新規の登録等の選択肢に表示されなくなります  # noqa: E501

        :param is_active: The is_active of this ExDestination.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and is_active is None:  # noqa: E501
            raise ValueError("Invalid value for `is_active`, must not be `None`")  # noqa: E501

        self._is_active = is_active

    @property
    def priority(self):
        """Gets the priority of this ExDestination.  # noqa: E501

        表示優先順（昇順）  # noqa: E501

        :return: The priority of this ExDestination.  # noqa: E501
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this ExDestination.

        表示優先順（昇順）  # noqa: E501

        :param priority: The priority of this ExDestination.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and priority is None:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority > 9999):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value less than or equal to `9999`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                priority is not None and priority < 0):  # noqa: E501
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `0`")  # noqa: E501

        self._priority = priority

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExDestination):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExDestination):
            return True

        return self.to_dict() != other.to_dict()
