# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from moneyforward_ex.configuration import Configuration


class EDocMetaDatum(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'number': 'int',
        'business_partner_name': 'str',
        'trade_date': 'date',
        'amount': 'float',
        'ex_transactionable_type_text': 'str',
        'ex_transactionable_number': 'int',
        'name': 'str',
        'document_type_text': 'str',
        'image_width': 'int',
        'image_height': 'int',
        'page_width': 'float',
        'page_height': 'float',
        'iso216_paper_size': 'str',
        'dpi': 'int',
        'image_depth': 'int',
        'timestamp_serial': 'int',
        'timestamp_at': 'Datetime',
        'timestamp_version': 'int',
        'timestamp_station_name': 'str',
        'timestamp_expires_at': 'Datetime',
        'scan_office_member_name': 'str',
        'scan_office_member_number': 'str'
    }

    attribute_map = {
        'id': 'id',
        'number': 'number',
        'business_partner_name': 'business_partner_name',
        'trade_date': 'trade_date',
        'amount': 'amount',
        'ex_transactionable_type_text': 'ex_transactionable_type_text',
        'ex_transactionable_number': 'ex_transactionable_number',
        'name': 'name',
        'document_type_text': 'document_type_text',
        'image_width': 'image_width',
        'image_height': 'image_height',
        'page_width': 'page_width',
        'page_height': 'page_height',
        'iso216_paper_size': 'iso216_paper_size',
        'dpi': 'dpi',
        'image_depth': 'image_depth',
        'timestamp_serial': 'timestamp_serial',
        'timestamp_at': 'timestamp_at',
        'timestamp_version': 'timestamp_version',
        'timestamp_station_name': 'timestamp_station_name',
        'timestamp_expires_at': 'timestamp_expires_at',
        'scan_office_member_name': 'scan_office_member_name',
        'scan_office_member_number': 'scan_office_member_number'
    }

    def __init__(self, id=None, number=None, business_partner_name=None, trade_date=None, amount=None, ex_transactionable_type_text=None, ex_transactionable_number=None, name=None, document_type_text=None, image_width=None, image_height=None, page_width=None, page_height=None, iso216_paper_size=None, dpi=None, image_depth=None, timestamp_serial=None, timestamp_at=None, timestamp_version=None, timestamp_station_name=None, timestamp_expires_at=None, scan_office_member_name=None, scan_office_member_number=None, local_vars_configuration=None):  # noqa: E501
        """EDocMetaDatum - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._number = None
        self._business_partner_name = None
        self._trade_date = None
        self._amount = None
        self._ex_transactionable_type_text = None
        self._ex_transactionable_number = None
        self._name = None
        self._document_type_text = None
        self._image_width = None
        self._image_height = None
        self._page_width = None
        self._page_height = None
        self._iso216_paper_size = None
        self._dpi = None
        self._image_depth = None
        self._timestamp_serial = None
        self._timestamp_at = None
        self._timestamp_version = None
        self._timestamp_station_name = None
        self._timestamp_expires_at = None
        self._scan_office_member_name = None
        self._scan_office_member_number = None
        self.discriminator = None

        self.id = id
        self.number = number
        if business_partner_name is not None:
            self.business_partner_name = business_partner_name
        if trade_date is not None:
            self.trade_date = trade_date
        if amount is not None:
            self.amount = amount
        if ex_transactionable_type_text is not None:
            self.ex_transactionable_type_text = ex_transactionable_type_text
        if ex_transactionable_number is not None:
            self.ex_transactionable_number = ex_transactionable_number
        self.name = name
        self.document_type_text = document_type_text
        if image_width is not None:
            self.image_width = image_width
        if image_height is not None:
            self.image_height = image_height
        if page_width is not None:
            self.page_width = page_width
        if page_height is not None:
            self.page_height = page_height
        if iso216_paper_size is not None:
            self.iso216_paper_size = iso216_paper_size
        if dpi is not None:
            self.dpi = dpi
        if image_depth is not None:
            self.image_depth = image_depth
        self.timestamp_serial = timestamp_serial
        self.timestamp_at = timestamp_at
        self.timestamp_version = timestamp_version
        self.timestamp_station_name = timestamp_station_name
        self.timestamp_expires_at = timestamp_expires_at
        if scan_office_member_name is not None:
            self.scan_office_member_name = scan_office_member_name
        if scan_office_member_number is not None:
            self.scan_office_member_number = scan_office_member_number

    @property
    def id(self):
        """Gets the id of this EDocMetaDatum.  # noqa: E501

        e_doc id  # noqa: E501

        :return: The id of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this EDocMetaDatum.

        e_doc id  # noqa: E501

        :param id: The id of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                id is not None and len(id) > 40):
            raise ValueError("Invalid value for `id`, length must be less than or equal to `40`")  # noqa: E501

        self._id = id

    @property
    def number(self):
        """Gets the number of this EDocMetaDatum.  # noqa: E501

        書類番号（シーケンスで採番）  # noqa: E501

        :return: The number of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this EDocMetaDatum.

        書類番号（シーケンスで採番）  # noqa: E501

        :param number: The number of this EDocMetaDatum.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and number is None:  # noqa: E501
            raise ValueError("Invalid value for `number`, must not be `None`")  # noqa: E501

        self._number = number

    @property
    def business_partner_name(self):
        """Gets the business_partner_name of this EDocMetaDatum.  # noqa: E501

        支払先  # noqa: E501

        :return: The business_partner_name of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._business_partner_name

    @business_partner_name.setter
    def business_partner_name(self, business_partner_name):
        """Sets the business_partner_name of this EDocMetaDatum.

        支払先  # noqa: E501

        :param business_partner_name: The business_partner_name of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                business_partner_name is not None and len(business_partner_name) > 100):
            raise ValueError("Invalid value for `business_partner_name`, length must be less than or equal to `100`")  # noqa: E501

        self._business_partner_name = business_partner_name

    @property
    def trade_date(self):
        """Gets the trade_date of this EDocMetaDatum.  # noqa: E501

        取引日  # noqa: E501

        :return: The trade_date of this EDocMetaDatum.  # noqa: E501
        :rtype: date
        """
        return self._trade_date

    @trade_date.setter
    def trade_date(self, trade_date):
        """Sets the trade_date of this EDocMetaDatum.

        取引日  # noqa: E501

        :param trade_date: The trade_date of this EDocMetaDatum.  # noqa: E501
        :type: date
        """

        self._trade_date = trade_date

    @property
    def amount(self):
        """Gets the amount of this EDocMetaDatum.  # noqa: E501

        取引金額  # noqa: E501

        :return: The amount of this EDocMetaDatum.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this EDocMetaDatum.

        取引金額  # noqa: E501

        :param amount: The amount of this EDocMetaDatum.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def ex_transactionable_type_text(self):
        """Gets the ex_transactionable_type_text of this EDocMetaDatum.  # noqa: E501

        明細または申請種別  # noqa: E501

        :return: The ex_transactionable_type_text of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._ex_transactionable_type_text

    @ex_transactionable_type_text.setter
    def ex_transactionable_type_text(self, ex_transactionable_type_text):
        """Sets the ex_transactionable_type_text of this EDocMetaDatum.

        明細または申請種別  # noqa: E501

        :param ex_transactionable_type_text: The ex_transactionable_type_text of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        allowed_values = ["経費明細", "その他の申請の明細", "支払依頼"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and ex_transactionable_type_text not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `ex_transactionable_type_text` ({0}), must be one of {1}"  # noqa: E501
                .format(ex_transactionable_type_text, allowed_values)
            )

        self._ex_transactionable_type_text = ex_transactionable_type_text

    @property
    def ex_transactionable_number(self):
        """Gets the ex_transactionable_number of this EDocMetaDatum.  # noqa: E501

        明細または申請番号  # noqa: E501

        :return: The ex_transactionable_number of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._ex_transactionable_number

    @ex_transactionable_number.setter
    def ex_transactionable_number(self, ex_transactionable_number):
        """Sets the ex_transactionable_number of this EDocMetaDatum.

        明細または申請番号  # noqa: E501

        :param ex_transactionable_number: The ex_transactionable_number of this EDocMetaDatum.  # noqa: E501
        :type: int
        """

        self._ex_transactionable_number = ex_transactionable_number

    @property
    def name(self):
        """Gets the name of this EDocMetaDatum.  # noqa: E501

        ファイル名  # noqa: E501

        :return: The name of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EDocMetaDatum.

        ファイル名  # noqa: E501

        :param name: The name of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501

        self._name = name

    @property
    def document_type_text(self):
        """Gets the document_type_text of this EDocMetaDatum.  # noqa: E501

        書類の種類  # noqa: E501

        :return: The document_type_text of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._document_type_text

    @document_type_text.setter
    def document_type_text(self, document_type_text):
        """Sets the document_type_text of this EDocMetaDatum.

        書類の種類  # noqa: E501

        :param document_type_text: The document_type_text of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and document_type_text is None:  # noqa: E501
            raise ValueError("Invalid value for `document_type_text`, must not be `None`")  # noqa: E501
        allowed_values = ["領収書", "請求書"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and document_type_text not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `document_type_text` ({0}), must be one of {1}"  # noqa: E501
                .format(document_type_text, allowed_values)
            )

        self._document_type_text = document_type_text

    @property
    def image_width(self):
        """Gets the image_width of this EDocMetaDatum.  # noqa: E501

        画像サイズ幅（ピクセル）  # noqa: E501

        :return: The image_width of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._image_width

    @image_width.setter
    def image_width(self, image_width):
        """Sets the image_width of this EDocMetaDatum.

        画像サイズ幅（ピクセル）  # noqa: E501

        :param image_width: The image_width of this EDocMetaDatum.  # noqa: E501
        :type: int
        """

        self._image_width = image_width

    @property
    def image_height(self):
        """Gets the image_height of this EDocMetaDatum.  # noqa: E501

        画像サイズ縦（ピクセル）  # noqa: E501

        :return: The image_height of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._image_height

    @image_height.setter
    def image_height(self, image_height):
        """Sets the image_height of this EDocMetaDatum.

        画像サイズ縦（ピクセル）  # noqa: E501

        :param image_height: The image_height of this EDocMetaDatum.  # noqa: E501
        :type: int
        """

        self._image_height = image_height

    @property
    def page_width(self):
        """Gets the page_width of this EDocMetaDatum.  # noqa: E501

        ページサイズ幅（ポイント）  # noqa: E501

        :return: The page_width of this EDocMetaDatum.  # noqa: E501
        :rtype: float
        """
        return self._page_width

    @page_width.setter
    def page_width(self, page_width):
        """Sets the page_width of this EDocMetaDatum.

        ページサイズ幅（ポイント）  # noqa: E501

        :param page_width: The page_width of this EDocMetaDatum.  # noqa: E501
        :type: float
        """

        self._page_width = page_width

    @property
    def page_height(self):
        """Gets the page_height of this EDocMetaDatum.  # noqa: E501

        ページサイズ縦（ピクセル）  # noqa: E501

        :return: The page_height of this EDocMetaDatum.  # noqa: E501
        :rtype: float
        """
        return self._page_height

    @page_height.setter
    def page_height(self, page_height):
        """Sets the page_height of this EDocMetaDatum.

        ページサイズ縦（ピクセル）  # noqa: E501

        :param page_height: The page_height of this EDocMetaDatum.  # noqa: E501
        :type: float
        """

        self._page_height = page_height

    @property
    def iso216_paper_size(self):
        """Gets the iso216_paper_size of this EDocMetaDatum.  # noqa: E501

        ページサイズ(ISO216規格)  # noqa: E501

        :return: The iso216_paper_size of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._iso216_paper_size

    @iso216_paper_size.setter
    def iso216_paper_size(self, iso216_paper_size):
        """Sets the iso216_paper_size of this EDocMetaDatum.

        ページサイズ(ISO216規格)  # noqa: E501

        :param iso216_paper_size: The iso216_paper_size of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                iso216_paper_size is not None and len(iso216_paper_size) > 5):
            raise ValueError("Invalid value for `iso216_paper_size`, length must be less than or equal to `5`")  # noqa: E501

        self._iso216_paper_size = iso216_paper_size

    @property
    def dpi(self):
        """Gets the dpi of this EDocMetaDatum.  # noqa: E501

        解像度（dpi）  # noqa: E501

        :return: The dpi of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._dpi

    @dpi.setter
    def dpi(self, dpi):
        """Sets the dpi of this EDocMetaDatum.

        解像度（dpi）  # noqa: E501

        :param dpi: The dpi of this EDocMetaDatum.  # noqa: E501
        :type: int
        """

        self._dpi = dpi

    @property
    def image_depth(self):
        """Gets the image_depth of this EDocMetaDatum.  # noqa: E501

        階調（色）  # noqa: E501

        :return: The image_depth of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._image_depth

    @image_depth.setter
    def image_depth(self, image_depth):
        """Sets the image_depth of this EDocMetaDatum.

        階調（色）  # noqa: E501

        :param image_depth: The image_depth of this EDocMetaDatum.  # noqa: E501
        :type: int
        """

        self._image_depth = image_depth

    @property
    def timestamp_serial(self):
        """Gets the timestamp_serial of this EDocMetaDatum.  # noqa: E501

        タイムスタンプシリアル番号  # noqa: E501

        :return: The timestamp_serial of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._timestamp_serial

    @timestamp_serial.setter
    def timestamp_serial(self, timestamp_serial):
        """Sets the timestamp_serial of this EDocMetaDatum.

        タイムスタンプシリアル番号  # noqa: E501

        :param timestamp_serial: The timestamp_serial of this EDocMetaDatum.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timestamp_serial is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp_serial`, must not be `None`")  # noqa: E501

        self._timestamp_serial = timestamp_serial

    @property
    def timestamp_at(self):
        """Gets the timestamp_at of this EDocMetaDatum.  # noqa: E501

        タイムスタンプ時刻  # noqa: E501

        :return: The timestamp_at of this EDocMetaDatum.  # noqa: E501
        :rtype: Datetime
        """
        return self._timestamp_at

    @timestamp_at.setter
    def timestamp_at(self, timestamp_at):
        """Sets the timestamp_at of this EDocMetaDatum.

        タイムスタンプ時刻  # noqa: E501

        :param timestamp_at: The timestamp_at of this EDocMetaDatum.  # noqa: E501
        :type: Datetime
        """
        if self.local_vars_configuration.client_side_validation and timestamp_at is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp_at`, must not be `None`")  # noqa: E501

        self._timestamp_at = timestamp_at

    @property
    def timestamp_version(self):
        """Gets the timestamp_version of this EDocMetaDatum.  # noqa: E501

        タイムスタンプバージョン  # noqa: E501

        :return: The timestamp_version of this EDocMetaDatum.  # noqa: E501
        :rtype: int
        """
        return self._timestamp_version

    @timestamp_version.setter
    def timestamp_version(self, timestamp_version):
        """Sets the timestamp_version of this EDocMetaDatum.

        タイムスタンプバージョン  # noqa: E501

        :param timestamp_version: The timestamp_version of this EDocMetaDatum.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and timestamp_version is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp_version`, must not be `None`")  # noqa: E501

        self._timestamp_version = timestamp_version

    @property
    def timestamp_station_name(self):
        """Gets the timestamp_station_name of this EDocMetaDatum.  # noqa: E501

        タイムスタンプ局情報  # noqa: E501

        :return: The timestamp_station_name of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._timestamp_station_name

    @timestamp_station_name.setter
    def timestamp_station_name(self, timestamp_station_name):
        """Sets the timestamp_station_name of this EDocMetaDatum.

        タイムスタンプ局情報  # noqa: E501

        :param timestamp_station_name: The timestamp_station_name of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and timestamp_station_name is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp_station_name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                timestamp_station_name is not None and len(timestamp_station_name) > 255):
            raise ValueError("Invalid value for `timestamp_station_name`, length must be less than or equal to `255`")  # noqa: E501

        self._timestamp_station_name = timestamp_station_name

    @property
    def timestamp_expires_at(self):
        """Gets the timestamp_expires_at of this EDocMetaDatum.  # noqa: E501

        タイムスタンプ有効期限  # noqa: E501

        :return: The timestamp_expires_at of this EDocMetaDatum.  # noqa: E501
        :rtype: Datetime
        """
        return self._timestamp_expires_at

    @timestamp_expires_at.setter
    def timestamp_expires_at(self, timestamp_expires_at):
        """Sets the timestamp_expires_at of this EDocMetaDatum.

        タイムスタンプ有効期限  # noqa: E501

        :param timestamp_expires_at: The timestamp_expires_at of this EDocMetaDatum.  # noqa: E501
        :type: Datetime
        """
        if self.local_vars_configuration.client_side_validation and timestamp_expires_at is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp_expires_at`, must not be `None`")  # noqa: E501

        self._timestamp_expires_at = timestamp_expires_at

    @property
    def scan_office_member_name(self):
        """Gets the scan_office_member_name of this EDocMetaDatum.  # noqa: E501

        登録者氏名  # noqa: E501

        :return: The scan_office_member_name of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._scan_office_member_name

    @scan_office_member_name.setter
    def scan_office_member_name(self, scan_office_member_name):
        """Sets the scan_office_member_name of this EDocMetaDatum.

        登録者氏名  # noqa: E501

        :param scan_office_member_name: The scan_office_member_name of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                scan_office_member_name is not None and len(scan_office_member_name) > 20):
            raise ValueError("Invalid value for `scan_office_member_name`, length must be less than or equal to `20`")  # noqa: E501

        self._scan_office_member_name = scan_office_member_name

    @property
    def scan_office_member_number(self):
        """Gets the scan_office_member_number of this EDocMetaDatum.  # noqa: E501

        登録者番号  # noqa: E501

        :return: The scan_office_member_number of this EDocMetaDatum.  # noqa: E501
        :rtype: str
        """
        return self._scan_office_member_number

    @scan_office_member_number.setter
    def scan_office_member_number(self, scan_office_member_number):
        """Sets the scan_office_member_number of this EDocMetaDatum.

        登録者番号  # noqa: E501

        :param scan_office_member_number: The scan_office_member_number of this EDocMetaDatum.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                scan_office_member_number is not None and len(scan_office_member_number) > 50):
            raise ValueError("Invalid value for `scan_office_member_number`, length must be less than or equal to `50`")  # noqa: E501

        self._scan_office_member_number = scan_office_member_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EDocMetaDatum):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EDocMetaDatum):
            return True

        return self.to_dict() != other.to_dict()
