# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from moneyforward_ex.api_client import ApiClient
from moneyforward_ex.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MfFileApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def find_office_ex_transaction_mf_file(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_mf_file_with_http_info(office_id, ex_transaction_id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_mf_file_with_http_info(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_with_http_info(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction_mf_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction_mf_file`")  # noqa: E501
        # verify the required parameter 'ex_transaction_id' is set
        if self.api_client.client_side_validation and ('ex_transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_transaction_id` when calling `find_office_ex_transaction_mf_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_transaction_id' in local_var_params:
            path_params['ex_transaction_id'] = local_var_params['ex_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{ex_transaction_id}/mf_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transaction_mf_file_me(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_me(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_mf_file_me_with_http_info(office_id, ex_transaction_id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_mf_file_me_with_http_info(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_me_with_http_info(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction_mf_file_me" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction_mf_file_me`")  # noqa: E501
        # verify the required parameter 'ex_transaction_id' is set
        if self.api_client.client_side_validation and ('ex_transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_transaction_id` when calling `find_office_ex_transaction_mf_file_me`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_transaction_id' in local_var_params:
            path_params['ex_transaction_id'] = local_var_params['ex_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions/{ex_transaction_id}/mf_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_mf_file_belongs_to_e_doc(self, office_id, e_doc_id, **kwargs):  # noqa: E501
        """電子帳簿保存法書類データに紐づく画像ファイルを返す  # noqa: E501

        電子帳簿保存法書類データに紐づく画像ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_mf_file_belongs_to_e_doc(office_id, e_doc_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str e_doc_id: e_doc id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_mf_file_belongs_to_e_doc_with_http_info(office_id, e_doc_id, **kwargs)  # noqa: E501

    def send_mf_file_belongs_to_e_doc_with_http_info(self, office_id, e_doc_id, **kwargs):  # noqa: E501
        """電子帳簿保存法書類データに紐づく画像ファイルを返す  # noqa: E501

        電子帳簿保存法書類データに紐づく画像ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_mf_file_belongs_to_e_doc_with_http_info(office_id, e_doc_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str e_doc_id: e_doc id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'e_doc_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_mf_file_belongs_to_e_doc" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `send_mf_file_belongs_to_e_doc`")  # noqa: E501
        # verify the required parameter 'e_doc_id' is set
        if self.api_client.client_side_validation and ('e_doc_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['e_doc_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `e_doc_id` when calling `send_mf_file_belongs_to_e_doc`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'e_doc_id' in local_var_params:
            path_params['e_doc_id'] = local_var_params['e_doc_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/e_docs/{e_doc_id}/mf_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
