# coding: utf-8

"""
    マネーフォワード クラウド経費API

    このページは[マネーフォワード クラウド経費](https://expense.moneyforward.com)（クラウド型の経費精算・ワークフローサービス）のAPIドキュメントです。ご利用開始の手順については、[github](https://github.com/moneyforward/expense-api-doc) をご覧ください。バグ報告や改善要望はgithub上からissue登録をして頂ければ幸いです。このドキュメントは[Swagger](http://swagger.io)の仕様で作成されています。実際にこのページでAPIの試打を行うことができます。試打を行いたい場合は、APIを利用するアプリケーションの登録の際に、Redirect URIを`https://expense.moneyforward.com/api/oauth2-redirect.html`に指定してお試しください。  # noqa: E501

    The version of the OpenAPI document: 1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from moneyforward_ex.api_client import ApiClient
from moneyforward_ex.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ExTransactionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ex_transaction(self, office_id, unknown_base_type, **kwargs):  # noqa: E501
        """自分の経費明細を追加する  # noqa: E501

        自分の経費明細を追加する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ex_transaction(office_id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_ex_transaction_with_http_info(office_id, unknown_base_type, **kwargs)  # noqa: E501

    def create_ex_transaction_with_http_info(self, office_id, unknown_base_type, **kwargs):  # noqa: E501
        """自分の経費明細を追加する  # noqa: E501

        自分の経費明細を追加する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ex_transaction_with_http_info(office_id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `create_ex_transaction`")  # noqa: E501
        # verify the required parameter 'unknown_base_type' is set
        if self.api_client.client_side_validation and ('unknown_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['unknown_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unknown_base_type` when calling `create_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_office_ex_transaction(self, office_id, office_member_id, unknown_base_type, **kwargs):  # noqa: E501
        """経費明細を追加する  # noqa: E501

        経費明細を追加する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_office_ex_transaction(office_id, office_member_id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_office_ex_transaction_with_http_info(office_id, office_member_id, unknown_base_type, **kwargs)  # noqa: E501

    def create_office_ex_transaction_with_http_info(self, office_id, office_member_id, unknown_base_type, **kwargs):  # noqa: E501
        """経費明細を追加する  # noqa: E501

        経費明細を追加する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_office_ex_transaction_with_http_info(office_id, office_member_id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'office_member_id',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_office_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `create_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'office_member_id' is set
        if self.api_client.client_side_validation and ('office_member_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_member_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_member_id` when calling `create_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'unknown_base_type' is set
        if self.api_client.client_side_validation and ('unknown_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['unknown_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unknown_base_type` when calling `create_office_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'office_member_id' in local_var_params:
            path_params['office_member_id'] = local_var_params['office_member_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/office_members/{office_member_id}/ex_transactions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_ex_transaction(self, office_id, id, **kwargs):  # noqa: E501
        """自分の経費明細を削除する  # noqa: E501

        自分の経費明細を削除する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_ex_transaction(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_ex_transaction_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def destroy_ex_transaction_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """自分の経費明細を削除する  # noqa: E501

        自分の経費明細を削除する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_ex_transaction_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `destroy_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `destroy_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def destroy_office_ex_transaction(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を削除する  # noqa: E501

        事業所全体の指定idの経費明細を削除する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_office_ex_transaction(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.destroy_office_ex_transaction_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def destroy_office_ex_transaction_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を削除する  # noqa: E501

        事業所全体の指定idの経費明細を削除する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.destroy_office_ex_transaction_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method destroy_office_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `destroy_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `destroy_office_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_ex_report_ex_transactions(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """経費申請に含まれる経費明細リストを返す  # noqa: E501

        経費申請に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_ex_transactions(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_ex_report_ex_transactions_with_http_info(office_id, ex_report_id, **kwargs)  # noqa: E501

    def find_ex_report_ex_transactions_with_http_info(self, office_id, ex_report_id, **kwargs):  # noqa: E501
        """経費申請に含まれる経費明細リストを返す  # noqa: E501

        経費申請に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_ex_transactions_with_http_info(office_id, ex_report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_id: 申請id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_report_id',
            'page',
            'query_object_dept_id',
            'query_object_project_code_id',
            'query_object_ex_item_id',
            'query_object_office_member_id',
            'query_object_number',
            'query_object_number_from',
            'query_object_number_to',
            'query_object_value_min',
            'query_object_value_max',
            'query_object_is_exported',
            'query_object_is_reported',
            'query_object_approved_at_from',
            'query_object_approved_at_to',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ex_report_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_ex_report_ex_transactions`")  # noqa: E501
        # verify the required parameter 'ex_report_id' is set
        if self.api_client.client_side_validation and ('ex_report_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_report_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_report_id` when calling `find_ex_report_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_report_id' in local_var_params:
            path_params['ex_report_id'] = local_var_params['ex_report_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_dept_id' in local_var_params and local_var_params['query_object_dept_id'] is not None:  # noqa: E501
            query_params.append(('query_object[dept_id]', local_var_params['query_object_dept_id']))  # noqa: E501
        if 'query_object_project_code_id' in local_var_params and local_var_params['query_object_project_code_id'] is not None:  # noqa: E501
            query_params.append(('query_object[project_code_id]', local_var_params['query_object_project_code_id']))  # noqa: E501
        if 'query_object_ex_item_id' in local_var_params and local_var_params['query_object_ex_item_id'] is not None:  # noqa: E501
            query_params.append(('query_object[ex_item_id]', local_var_params['query_object_ex_item_id']))  # noqa: E501
        if 'query_object_office_member_id' in local_var_params and local_var_params['query_object_office_member_id'] is not None:  # noqa: E501
            query_params.append(('query_object[office_member_id]', local_var_params['query_object_office_member_id']))  # noqa: E501
        if 'query_object_number' in local_var_params and local_var_params['query_object_number'] is not None:  # noqa: E501
            query_params.append(('query_object[number]', local_var_params['query_object_number']))  # noqa: E501
        if 'query_object_number_from' in local_var_params and local_var_params['query_object_number_from'] is not None:  # noqa: E501
            query_params.append(('query_object[number_from]', local_var_params['query_object_number_from']))  # noqa: E501
        if 'query_object_number_to' in local_var_params and local_var_params['query_object_number_to'] is not None:  # noqa: E501
            query_params.append(('query_object[number_to]', local_var_params['query_object_number_to']))  # noqa: E501
        if 'query_object_value_min' in local_var_params and local_var_params['query_object_value_min'] is not None:  # noqa: E501
            query_params.append(('query_object[value_min]', local_var_params['query_object_value_min']))  # noqa: E501
        if 'query_object_value_max' in local_var_params and local_var_params['query_object_value_max'] is not None:  # noqa: E501
            query_params.append(('query_object[value_max]', local_var_params['query_object_value_max']))  # noqa: E501
        if 'query_object_is_exported' in local_var_params and local_var_params['query_object_is_exported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_exported]', local_var_params['query_object_is_exported']))  # noqa: E501
        if 'query_object_is_reported' in local_var_params and local_var_params['query_object_is_reported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_reported]', local_var_params['query_object_is_reported']))  # noqa: E501
        if 'query_object_approved_at_from' in local_var_params and local_var_params['query_object_approved_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_from]', local_var_params['query_object_approved_at_from']))  # noqa: E501
        if 'query_object_approved_at_to' in local_var_params and local_var_params['query_object_approved_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_to]', local_var_params['query_object_approved_at_to']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_reports/{ex_report_id}/ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_ex_report_unit_ex_transactions(self, office_id, ex_report_unit_id, **kwargs):  # noqa: E501
        """経費集計に含まれる経費明細リストを返す  # noqa: E501

        経費集計に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_unit_ex_transactions(office_id, ex_report_unit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_unit_id: 集計id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_ex_report_unit_ex_transactions_with_http_info(office_id, ex_report_unit_id, **kwargs)  # noqa: E501

    def find_ex_report_unit_ex_transactions_with_http_info(self, office_id, ex_report_unit_id, **kwargs):  # noqa: E501
        """経費集計に含まれる経費明細リストを返す  # noqa: E501

        経費集計に含まれる経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_report_unit_ex_transactions_with_http_info(office_id, ex_report_unit_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_report_unit_id: 集計id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_report_unit_id',
            'page',
            'query_object_dept_id',
            'query_object_project_code_id',
            'query_object_ex_item_id',
            'query_object_office_member_id',
            'query_object_number',
            'query_object_number_from',
            'query_object_number_to',
            'query_object_value_min',
            'query_object_value_max',
            'query_object_is_exported',
            'query_object_is_reported',
            'query_object_approved_at_from',
            'query_object_approved_at_to',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ex_report_unit_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_ex_report_unit_ex_transactions`")  # noqa: E501
        # verify the required parameter 'ex_report_unit_id' is set
        if self.api_client.client_side_validation and ('ex_report_unit_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_report_unit_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_report_unit_id` when calling `find_ex_report_unit_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_report_unit_id' in local_var_params:
            path_params['ex_report_unit_id'] = local_var_params['ex_report_unit_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_dept_id' in local_var_params and local_var_params['query_object_dept_id'] is not None:  # noqa: E501
            query_params.append(('query_object[dept_id]', local_var_params['query_object_dept_id']))  # noqa: E501
        if 'query_object_project_code_id' in local_var_params and local_var_params['query_object_project_code_id'] is not None:  # noqa: E501
            query_params.append(('query_object[project_code_id]', local_var_params['query_object_project_code_id']))  # noqa: E501
        if 'query_object_ex_item_id' in local_var_params and local_var_params['query_object_ex_item_id'] is not None:  # noqa: E501
            query_params.append(('query_object[ex_item_id]', local_var_params['query_object_ex_item_id']))  # noqa: E501
        if 'query_object_office_member_id' in local_var_params and local_var_params['query_object_office_member_id'] is not None:  # noqa: E501
            query_params.append(('query_object[office_member_id]', local_var_params['query_object_office_member_id']))  # noqa: E501
        if 'query_object_number' in local_var_params and local_var_params['query_object_number'] is not None:  # noqa: E501
            query_params.append(('query_object[number]', local_var_params['query_object_number']))  # noqa: E501
        if 'query_object_number_from' in local_var_params and local_var_params['query_object_number_from'] is not None:  # noqa: E501
            query_params.append(('query_object[number_from]', local_var_params['query_object_number_from']))  # noqa: E501
        if 'query_object_number_to' in local_var_params and local_var_params['query_object_number_to'] is not None:  # noqa: E501
            query_params.append(('query_object[number_to]', local_var_params['query_object_number_to']))  # noqa: E501
        if 'query_object_value_min' in local_var_params and local_var_params['query_object_value_min'] is not None:  # noqa: E501
            query_params.append(('query_object[value_min]', local_var_params['query_object_value_min']))  # noqa: E501
        if 'query_object_value_max' in local_var_params and local_var_params['query_object_value_max'] is not None:  # noqa: E501
            query_params.append(('query_object[value_max]', local_var_params['query_object_value_max']))  # noqa: E501
        if 'query_object_is_exported' in local_var_params and local_var_params['query_object_is_exported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_exported]', local_var_params['query_object_is_exported']))  # noqa: E501
        if 'query_object_is_reported' in local_var_params and local_var_params['query_object_is_reported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_reported]', local_var_params['query_object_is_reported']))  # noqa: E501
        if 'query_object_approved_at_from' in local_var_params and local_var_params['query_object_approved_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_from]', local_var_params['query_object_approved_at_from']))  # noqa: E501
        if 'query_object_approved_at_to' in local_var_params and local_var_params['query_object_approved_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_to]', local_var_params['query_object_approved_at_to']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_report_units/{ex_report_unit_id}/ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_ex_transaction(self, office_id, id, **kwargs):  # noqa: E501
        """自分の経費明細を返す  # noqa: E501

        自分の経費明細を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_transaction(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_ex_transaction_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def find_ex_transaction_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """自分の経費明細を返す  # noqa: E501

        自分の経費明細を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_transaction_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `find_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_ex_transactions(self, office_id, **kwargs):  # noqa: E501
        """自分の経費明細リストを返す  # noqa: E501

        自分の経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_transactions(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param bool query_object_is_recognized_at_blank: 日付が空でフィルタ
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_ex_transactions_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_ex_transactions_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """自分の経費明細リストを返す  # noqa: E501

        自分の経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ex_transactions_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param bool query_object_is_recognized_at_blank: 日付が空でフィルタ
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page',
            'query_object_dept_id',
            'query_object_project_code_id',
            'query_object_ex_item_id',
            'query_object_office_member_id',
            'query_object_number',
            'query_object_number_from',
            'query_object_number_to',
            'query_object_value_min',
            'query_object_value_max',
            'query_object_is_exported',
            'query_object_is_reported',
            'query_object_approved_at_from',
            'query_object_approved_at_to',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to',
            'query_object_is_recognized_at_blank'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_dept_id' in local_var_params and local_var_params['query_object_dept_id'] is not None:  # noqa: E501
            query_params.append(('query_object[dept_id]', local_var_params['query_object_dept_id']))  # noqa: E501
        if 'query_object_project_code_id' in local_var_params and local_var_params['query_object_project_code_id'] is not None:  # noqa: E501
            query_params.append(('query_object[project_code_id]', local_var_params['query_object_project_code_id']))  # noqa: E501
        if 'query_object_ex_item_id' in local_var_params and local_var_params['query_object_ex_item_id'] is not None:  # noqa: E501
            query_params.append(('query_object[ex_item_id]', local_var_params['query_object_ex_item_id']))  # noqa: E501
        if 'query_object_office_member_id' in local_var_params and local_var_params['query_object_office_member_id'] is not None:  # noqa: E501
            query_params.append(('query_object[office_member_id]', local_var_params['query_object_office_member_id']))  # noqa: E501
        if 'query_object_number' in local_var_params and local_var_params['query_object_number'] is not None:  # noqa: E501
            query_params.append(('query_object[number]', local_var_params['query_object_number']))  # noqa: E501
        if 'query_object_number_from' in local_var_params and local_var_params['query_object_number_from'] is not None:  # noqa: E501
            query_params.append(('query_object[number_from]', local_var_params['query_object_number_from']))  # noqa: E501
        if 'query_object_number_to' in local_var_params and local_var_params['query_object_number_to'] is not None:  # noqa: E501
            query_params.append(('query_object[number_to]', local_var_params['query_object_number_to']))  # noqa: E501
        if 'query_object_value_min' in local_var_params and local_var_params['query_object_value_min'] is not None:  # noqa: E501
            query_params.append(('query_object[value_min]', local_var_params['query_object_value_min']))  # noqa: E501
        if 'query_object_value_max' in local_var_params and local_var_params['query_object_value_max'] is not None:  # noqa: E501
            query_params.append(('query_object[value_max]', local_var_params['query_object_value_max']))  # noqa: E501
        if 'query_object_is_exported' in local_var_params and local_var_params['query_object_is_exported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_exported]', local_var_params['query_object_is_exported']))  # noqa: E501
        if 'query_object_is_reported' in local_var_params and local_var_params['query_object_is_reported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_reported]', local_var_params['query_object_is_reported']))  # noqa: E501
        if 'query_object_approved_at_from' in local_var_params and local_var_params['query_object_approved_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_from]', local_var_params['query_object_approved_at_from']))  # noqa: E501
        if 'query_object_approved_at_to' in local_var_params and local_var_params['query_object_approved_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_to]', local_var_params['query_object_approved_at_to']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501
        if 'query_object_is_recognized_at_blank' in local_var_params and local_var_params['query_object_is_recognized_at_blank'] is not None:  # noqa: E501
            query_params.append(('query_object[is_recognized_at_blank]', local_var_params['query_object_is_recognized_at_blank']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_journals_by_ex_transactions(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の明細に紐づく仕訳リストを返す  # noqa: E501

        事業所全体の明細に紐づく仕訳リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_journals_by_ex_transactions(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param date query_object_recognized_at_from: 仕訳の計上日について指定日以降でフィルタ (recognized_at_to との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param date query_object_recognized_at_to: 仕訳の計上日について指定日以前でフィルタ (recognized_at_from との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_journals_by_ex_transactions_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_ex_journals_by_ex_transactions_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の明細に紐づく仕訳リストを返す  # noqa: E501

        事業所全体の明細に紐づく仕訳リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_journals_by_ex_transactions_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param date query_object_recognized_at_from: 仕訳の計上日について指定日以降でフィルタ (recognized_at_to との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param date query_object_recognized_at_to: 仕訳の計上日について指定日以前でフィルタ (recognized_at_from との期間は最大で 3 ヶ月) ex.`2019-09-30`
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_journals_by_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_journals_by_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_journals_by_ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transaction(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を返す  # noqa: E501

        事業所全体の指定idの経費明細を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_with_http_info(office_id, id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_with_http_info(self, office_id, id, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を返す  # noqa: E501

        事業所全体の指定idの経費明細を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_with_http_info(office_id, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str id: id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `find_office_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transaction_journal(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に対応する仕訳を返す  # noqa: E501

        経費明細に対応する仕訳を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_journal(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExJournal
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_journal_with_http_info(office_id, ex_transaction_id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_journal_with_http_info(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に対応する仕訳を返す  # noqa: E501

        経費明細に対応する仕訳を返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_journal_with_http_info(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExJournal, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction_journal" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction_journal`")  # noqa: E501
        # verify the required parameter 'ex_transaction_id' is set
        if self.api_client.client_side_validation and ('ex_transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_transaction_id` when calling `find_office_ex_transaction_journal`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_transaction_id' in local_var_params:
            path_params['ex_transaction_id'] = local_var_params['ex_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{ex_transaction_id}/ex_journal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExJournal',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transaction_mf_file(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_mf_file_with_http_info(office_id, ex_transaction_id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_mf_file_with_http_info(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_with_http_info(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction_mf_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction_mf_file`")  # noqa: E501
        # verify the required parameter 'ex_transaction_id' is set
        if self.api_client.client_side_validation and ('ex_transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_transaction_id` when calling `find_office_ex_transaction_mf_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_transaction_id' in local_var_params:
            path_params['ex_transaction_id'] = local_var_params['ex_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{ex_transaction_id}/mf_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transaction_mf_file_me(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_me(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transaction_mf_file_me_with_http_info(office_id, ex_transaction_id, **kwargs)  # noqa: E501

    def find_office_ex_transaction_mf_file_me_with_http_info(self, office_id, ex_transaction_id, **kwargs):  # noqa: E501
        """経費明細に紐づく添付ファイルを返す  # noqa: E501

        経費明細に紐づく添付ファイルを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transaction_mf_file_me_with_http_info(office_id, ex_transaction_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str ex_transaction_id: 経費明細id (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'ex_transaction_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transaction_mf_file_me" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transaction_mf_file_me`")  # noqa: E501
        # verify the required parameter 'ex_transaction_id' is set
        if self.api_client.client_side_validation and ('ex_transaction_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['ex_transaction_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `ex_transaction_id` when calling `find_office_ex_transaction_mf_file_me`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'ex_transaction_id' in local_var_params:
            path_params['ex_transaction_id'] = local_var_params['ex_transaction_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions/{ex_transaction_id}/mf_file', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_office_ex_transactions(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の経費明細リストを返す  # noqa: E501

        事業所全体の経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transactions(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param bool query_object_is_recognized_at_blank: 日付が空でフィルタ
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_office_ex_transactions_with_http_info(office_id, **kwargs)  # noqa: E501

    def find_office_ex_transactions_with_http_info(self, office_id, **kwargs):  # noqa: E501
        """事業所全体の経費明細リストを返す  # noqa: E501

        事業所全体の経費明細リストを返す  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_office_ex_transactions_with_http_info(office_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param int page: ページ番号
        :param str query_object_dept_id: 部門idでフィルタ
        :param str query_object_project_code_id: プロジェクトidでフィルタ
        :param str query_object_ex_item_id: 経費科目idでフィルタ
        :param str query_object_office_member_id: メンバーidでフィルタ
        :param int query_object_number: 経費明細番号でフィルタ
        :param int query_object_number_from: 指定番号以上の経費明細番号でフィルタ
        :param int query_object_number_to: 指定番号以下の経費明細番号でフィルタ
        :param float query_object_value_min: 金額下限でフィルタ
        :param float query_object_value_max: 金額上限でフィルタ
        :param bool query_object_is_exported: 仕訳出力済みかどうかでフィルタ
        :param bool query_object_is_reported: 経費申請に含まれるかどうかでフィルタ
        :param datetime query_object_approved_at_from: 申請の承認時刻について指定時刻以降でフィルタ ex.`2018-09-30 00:00:00 +0900`
        :param datetime query_object_approved_at_to: 申請の承認時刻について指定時刻以前でフィルタ ex.`2018-09-30 23:59:59 +0900`
        :param date query_object_recognized_at_from: 日付に指定日付以降でフィルタ ex.`2018-09-30`
        :param date query_object_recognized_at_to: 日付に指定日付以前でフィルタ ex.`2018-09-30`
        :param bool query_object_is_recognized_at_blank: 日付が空でフィルタ
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'page',
            'query_object_dept_id',
            'query_object_project_code_id',
            'query_object_ex_item_id',
            'query_object_office_member_id',
            'query_object_number',
            'query_object_number_from',
            'query_object_number_to',
            'query_object_value_min',
            'query_object_value_max',
            'query_object_is_exported',
            'query_object_is_reported',
            'query_object_approved_at_from',
            'query_object_approved_at_to',
            'query_object_recognized_at_from',
            'query_object_recognized_at_to',
            'query_object_is_recognized_at_blank'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_office_ex_transactions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `find_office_ex_transactions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'query_object_dept_id' in local_var_params and local_var_params['query_object_dept_id'] is not None:  # noqa: E501
            query_params.append(('query_object[dept_id]', local_var_params['query_object_dept_id']))  # noqa: E501
        if 'query_object_project_code_id' in local_var_params and local_var_params['query_object_project_code_id'] is not None:  # noqa: E501
            query_params.append(('query_object[project_code_id]', local_var_params['query_object_project_code_id']))  # noqa: E501
        if 'query_object_ex_item_id' in local_var_params and local_var_params['query_object_ex_item_id'] is not None:  # noqa: E501
            query_params.append(('query_object[ex_item_id]', local_var_params['query_object_ex_item_id']))  # noqa: E501
        if 'query_object_office_member_id' in local_var_params and local_var_params['query_object_office_member_id'] is not None:  # noqa: E501
            query_params.append(('query_object[office_member_id]', local_var_params['query_object_office_member_id']))  # noqa: E501
        if 'query_object_number' in local_var_params and local_var_params['query_object_number'] is not None:  # noqa: E501
            query_params.append(('query_object[number]', local_var_params['query_object_number']))  # noqa: E501
        if 'query_object_number_from' in local_var_params and local_var_params['query_object_number_from'] is not None:  # noqa: E501
            query_params.append(('query_object[number_from]', local_var_params['query_object_number_from']))  # noqa: E501
        if 'query_object_number_to' in local_var_params and local_var_params['query_object_number_to'] is not None:  # noqa: E501
            query_params.append(('query_object[number_to]', local_var_params['query_object_number_to']))  # noqa: E501
        if 'query_object_value_min' in local_var_params and local_var_params['query_object_value_min'] is not None:  # noqa: E501
            query_params.append(('query_object[value_min]', local_var_params['query_object_value_min']))  # noqa: E501
        if 'query_object_value_max' in local_var_params and local_var_params['query_object_value_max'] is not None:  # noqa: E501
            query_params.append(('query_object[value_max]', local_var_params['query_object_value_max']))  # noqa: E501
        if 'query_object_is_exported' in local_var_params and local_var_params['query_object_is_exported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_exported]', local_var_params['query_object_is_exported']))  # noqa: E501
        if 'query_object_is_reported' in local_var_params and local_var_params['query_object_is_reported'] is not None:  # noqa: E501
            query_params.append(('query_object[is_reported]', local_var_params['query_object_is_reported']))  # noqa: E501
        if 'query_object_approved_at_from' in local_var_params and local_var_params['query_object_approved_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_from]', local_var_params['query_object_approved_at_from']))  # noqa: E501
        if 'query_object_approved_at_to' in local_var_params and local_var_params['query_object_approved_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[approved_at_to]', local_var_params['query_object_approved_at_to']))  # noqa: E501
        if 'query_object_recognized_at_from' in local_var_params and local_var_params['query_object_recognized_at_from'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_from]', local_var_params['query_object_recognized_at_from']))  # noqa: E501
        if 'query_object_recognized_at_to' in local_var_params and local_var_params['query_object_recognized_at_to'] is not None:  # noqa: E501
            query_params.append(('query_object[recognized_at_to]', local_var_params['query_object_recognized_at_to']))  # noqa: E501
        if 'query_object_is_recognized_at_blank' in local_var_params and local_var_params['query_object_is_recognized_at_blank'] is not None:  # noqa: E501
            query_params.append(('query_object[is_recognized_at_blank]', local_var_params['query_object_is_recognized_at_blank']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_ex_transaction(self, office_id, office_member_id, id, unknown_base_type, **kwargs):  # noqa: E501
        """自分の経費明細を更新する  # noqa: E501

        自分の経費明細を更新する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ex_transaction(office_id, office_member_id, id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param str id: id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_ex_transaction_with_http_info(office_id, office_member_id, id, unknown_base_type, **kwargs)  # noqa: E501

    def update_ex_transaction_with_http_info(self, office_id, office_member_id, id, unknown_base_type, **kwargs):  # noqa: E501
        """自分の経費明細を更新する  # noqa: E501

        自分の経費明細を更新する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ex_transaction_with_http_info(office_id, office_member_id, id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param str id: id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'office_member_id',
            'id',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `update_ex_transaction`")  # noqa: E501
        # verify the required parameter 'office_member_id' is set
        if self.api_client.client_side_validation and ('office_member_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_member_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_member_id` when calling `update_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_ex_transaction`")  # noqa: E501
        # verify the required parameter 'unknown_base_type' is set
        if self.api_client.client_side_validation and ('unknown_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['unknown_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unknown_base_type` when calling `update_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'office_member_id' in local_var_params:
            path_params['office_member_id'] = local_var_params['office_member_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/ex_transactions/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_office_ex_transaction(self, office_id, office_member_id, id, unknown_base_type, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を更新する  # noqa: E501

        事業所全体の指定idの経費明細を更新する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_office_ex_transaction(office_id, office_member_id, id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param str id: id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ExTransaction
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_office_ex_transaction_with_http_info(office_id, office_member_id, id, unknown_base_type, **kwargs)  # noqa: E501

    def update_office_ex_transaction_with_http_info(self, office_id, office_member_id, id, unknown_base_type, **kwargs):  # noqa: E501
        """事業所全体の指定idの経費明細を更新する  # noqa: E501

        事業所全体の指定idの経費明細を更新する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_office_ex_transaction_with_http_info(office_id, office_member_id, id, unknown_base_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param str id: id (required)
        :param UNKNOWN_BASE_TYPE unknown_base_type: 経費明細のパラメータ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExTransaction, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'office_member_id',
            'id',
            'unknown_base_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_office_ex_transaction" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `update_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'office_member_id' is set
        if self.api_client.client_side_validation and ('office_member_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_member_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_member_id` when calling `update_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `update_office_ex_transaction`")  # noqa: E501
        # verify the required parameter 'unknown_base_type' is set
        if self.api_client.client_side_validation and ('unknown_base_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['unknown_base_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `unknown_base_type` when calling `update_office_ex_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'office_member_id' in local_var_params:
            path_params['office_member_id'] = local_var_params['office_member_id']  # noqa: E501
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'unknown_base_type' in local_var_params:
            body_params = local_var_params['unknown_base_type']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/ex_transactions/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExTransaction',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_member_receipt(self, office_id, office_member_id, receipt_input, **kwargs):  # noqa: E501
        """領収書をアップロードして経費登録する  # noqa: E501

        領収書をアップロードして経費登録する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_member_receipt(office_id, office_member_id, receipt_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param ReceiptInput receipt_input: 領収書像データ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_member_receipt_with_http_info(office_id, office_member_id, receipt_input, **kwargs)  # noqa: E501

    def upload_member_receipt_with_http_info(self, office_id, office_member_id, receipt_input, **kwargs):  # noqa: E501
        """領収書をアップロードして経費登録する  # noqa: E501

        領収書をアップロードして経費登録する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_member_receipt_with_http_info(office_id, office_member_id, receipt_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param str office_member_id: メンバーid (required)
        :param ReceiptInput receipt_input: 領収書像データ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'office_member_id',
            'receipt_input'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_member_receipt" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `upload_member_receipt`")  # noqa: E501
        # verify the required parameter 'office_member_id' is set
        if self.api_client.client_side_validation and ('office_member_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_member_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_member_id` when calling `upload_member_receipt`")  # noqa: E501
        # verify the required parameter 'receipt_input' is set
        if self.api_client.client_side_validation and ('receipt_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['receipt_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `receipt_input` when calling `upload_member_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501
        if 'office_member_id' in local_var_params:
            path_params['office_member_id'] = local_var_params['office_member_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'receipt_input' in local_var_params:
            body_params = local_var_params['receipt_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/office_members/{office_member_id}/upload_receipt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_receipt(self, office_id, receipt_input, **kwargs):  # noqa: E501
        """自分の領収書をアップロードして経費登録する  # noqa: E501

        自分の領収書をアップロードして経費登録する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_receipt(office_id, receipt_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param ReceiptInput receipt_input: 領収書像データ (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upload_receipt_with_http_info(office_id, receipt_input, **kwargs)  # noqa: E501

    def upload_receipt_with_http_info(self, office_id, receipt_input, **kwargs):  # noqa: E501
        """自分の領収書をアップロードして経費登録する  # noqa: E501

        自分の領収書をアップロードして経費登録する  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_receipt_with_http_info(office_id, receipt_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str office_id: 事業所id (required)
        :param ReceiptInput receipt_input: 領収書像データ (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'office_id',
            'receipt_input'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_receipt" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'office_id' is set
        if self.api_client.client_side_validation and ('office_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['office_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `office_id` when calling `upload_receipt`")  # noqa: E501
        # verify the required parameter 'receipt_input' is set
        if self.api_client.client_side_validation and ('receipt_input' not in local_var_params or  # noqa: E501
                                                        local_var_params['receipt_input'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `receipt_input` when calling `upload_receipt`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'office_id' in local_var_params:
            path_params['office_id'] = local_var_params['office_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'receipt_input' in local_var_params:
            body_params = local_var_params['receipt_input']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['mf_expense_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/api/external/v1/offices/{office_id}/me/upload_receipt', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
